/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.bytecode.AttributeInfo;
import ai.h2o.javassist.bytecode.ByteArray;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.annotation.Annotation;
import ai.h2o.javassist.bytecode.annotation.AnnotationMemberValue;
import ai.h2o.javassist.bytecode.annotation.AnnotationsWriter;
import ai.h2o.javassist.bytecode.annotation.ArrayMemberValue;
import ai.h2o.javassist.bytecode.annotation.BooleanMemberValue;
import ai.h2o.javassist.bytecode.annotation.ByteMemberValue;
import ai.h2o.javassist.bytecode.annotation.CharMemberValue;
import ai.h2o.javassist.bytecode.annotation.ClassMemberValue;
import ai.h2o.javassist.bytecode.annotation.DoubleMemberValue;
import ai.h2o.javassist.bytecode.annotation.EnumMemberValue;
import ai.h2o.javassist.bytecode.annotation.FloatMemberValue;
import ai.h2o.javassist.bytecode.annotation.IntegerMemberValue;
import ai.h2o.javassist.bytecode.annotation.LongMemberValue;
import ai.h2o.javassist.bytecode.annotation.MemberValue;
import ai.h2o.javassist.bytecode.annotation.ShortMemberValue;
import ai.h2o.javassist.bytecode.annotation.StringMemberValue;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AnnotationsAttribute
extends AttributeInfo {
    public static final String visibleTag = "RuntimeVisibleAnnotations";
    public static final String invisibleTag = "RuntimeInvisibleAnnotations";

    public AnnotationsAttribute(ConstPool cp, String attrname, byte[] info) {
        super(cp, attrname, info);
    }

    public AnnotationsAttribute(ConstPool cp, String attrname) {
        this(cp, attrname, new byte[]{0, 0});
    }

    AnnotationsAttribute(ConstPool cp, int n2, DataInputStream in) throws IOException {
        super(cp, n2, in);
    }

    public int numAnnotations() {
        return ByteArray.readU16bit(this.info, 0);
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        Copier copier = new Copier(this.info, this.constPool, newCp, classnames);
        try {
            copier.annotationArray();
            return new AnnotationsAttribute(newCp, this.getName(), copier.close());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Annotation getAnnotation(String type) {
        Annotation[] annotationArray = this.getAnnotations();
        for (int i2 = 0; i2 < annotationArray.length; ++i2) {
            if (!annotationArray[i2].getTypeName().equals(type)) continue;
            return annotationArray[i2];
        }
        return null;
    }

    public void addAnnotation(Annotation annotation) {
        String string = annotation.getTypeName();
        Annotation[] annotationArray = this.getAnnotations();
        for (int i2 = 0; i2 < annotationArray.length; ++i2) {
            if (!annotationArray[i2].getTypeName().equals(string)) continue;
            annotationArray[i2] = annotation;
            this.setAnnotations(annotationArray);
            return;
        }
        Annotation[] annotationArray2 = new Annotation[annotationArray.length + 1];
        System.arraycopy(annotationArray, 0, annotationArray2, 0, annotationArray.length);
        annotationArray2[annotationArray.length] = annotation;
        this.setAnnotations(annotationArray2);
    }

    public boolean removeAnnotation(String type) {
        Annotation[] annotationArray = this.getAnnotations();
        for (int i2 = 0; i2 < annotationArray.length; ++i2) {
            if (!annotationArray[i2].getTypeName().equals(type)) continue;
            Annotation[] annotationArray2 = new Annotation[annotationArray.length - 1];
            System.arraycopy(annotationArray, 0, annotationArray2, 0, i2);
            if (i2 < annotationArray.length - 1) {
                System.arraycopy(annotationArray, i2 + 1, annotationArray2, i2, annotationArray.length - i2 - 1);
            }
            this.setAnnotations(annotationArray2);
            return true;
        }
        return false;
    }

    public Annotation[] getAnnotations() {
        try {
            return new Parser(this.info, this.constPool).parseAnnotations();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setAnnotations(Annotation[] annotations) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        AnnotationsWriter annotationsWriter = new AnnotationsWriter(byteArrayOutputStream, this.constPool);
        try {
            int n2 = annotations.length;
            annotationsWriter.numAnnotations(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                annotations[i2].write(annotationsWriter);
            }
            annotationsWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.set(byteArrayOutputStream.toByteArray());
    }

    public void setAnnotation(Annotation annotation) {
        this.setAnnotations(new Annotation[]{annotation});
    }

    @Override
    void renameClass(String oldname, String newname) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(oldname, newname);
        this.renameClass(hashMap);
    }

    @Override
    void renameClass(Map<String, String> classnames) {
        Renamer renamer = new Renamer(this.info, this.getConstPool(), classnames);
        try {
            renamer.annotationArray();
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    void getRefClasses(Map<String, String> classnames) {
        this.renameClass(classnames);
    }

    public String toString() {
        Annotation[] annotationArray = this.getAnnotations();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < annotationArray.length) {
            stringBuilder.append(annotationArray[n2++].toString());
            if (n2 == annotationArray.length) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    static class Parser
    extends Walker {
        ConstPool pool;
        Annotation[][] allParams;
        Annotation[] allAnno;
        Annotation currentAnno;
        MemberValue currentMember;

        Parser(byte[] info, ConstPool cp) {
            super(info);
            this.pool = cp;
        }

        Annotation[][] parseParameters() throws Exception {
            this.parameters();
            return this.allParams;
        }

        Annotation[] parseAnnotations() throws Exception {
            this.annotationArray();
            return this.allAnno;
        }

        MemberValue parseMemberValue() throws Exception {
            this.memberValue(0);
            return this.currentMember;
        }

        @Override
        void parameters(int numParam, int pos) throws Exception {
            Annotation[][] annotationArrayArray = new Annotation[numParam][];
            for (int i2 = 0; i2 < numParam; ++i2) {
                pos = this.annotationArray(pos);
                annotationArrayArray[i2] = this.allAnno;
            }
            this.allParams = annotationArrayArray;
        }

        @Override
        int annotationArray(int pos, int num) throws Exception {
            Annotation[] annotationArray = new Annotation[num];
            for (int i2 = 0; i2 < num; ++i2) {
                pos = this.annotation(pos);
                annotationArray[i2] = this.currentAnno;
            }
            this.allAnno = annotationArray;
            return pos;
        }

        @Override
        int annotation(int pos, int type, int numPairs) throws Exception {
            this.currentAnno = new Annotation(type, this.pool);
            return super.annotation(pos, type, numPairs);
        }

        @Override
        int memberValuePair(int pos, int nameIndex) throws Exception {
            pos = super.memberValuePair(pos, nameIndex);
            this.currentAnno.addMemberValue(nameIndex, this.currentMember);
            return pos;
        }

        @Override
        void constValueMember(int tag, int index) throws Exception {
            MemberValue memberValue;
            ConstPool constPool = this.pool;
            switch (tag) {
                case 66: {
                    memberValue = new ByteMemberValue(index, constPool);
                    break;
                }
                case 67: {
                    memberValue = new CharMemberValue(index, constPool);
                    break;
                }
                case 68: {
                    memberValue = new DoubleMemberValue(index, constPool);
                    break;
                }
                case 70: {
                    memberValue = new FloatMemberValue(index, constPool);
                    break;
                }
                case 73: {
                    memberValue = new IntegerMemberValue(index, constPool);
                    break;
                }
                case 74: {
                    memberValue = new LongMemberValue(index, constPool);
                    break;
                }
                case 83: {
                    memberValue = new ShortMemberValue(index, constPool);
                    break;
                }
                case 90: {
                    memberValue = new BooleanMemberValue(index, constPool);
                    break;
                }
                case 115: {
                    memberValue = new StringMemberValue(index, constPool);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown tag:" + tag);
                }
            }
            this.currentMember = memberValue;
            super.constValueMember(tag, index);
        }

        @Override
        void enumMemberValue(int pos, int typeNameIndex, int constNameIndex) throws Exception {
            this.currentMember = new EnumMemberValue(typeNameIndex, constNameIndex, this.pool);
            super.enumMemberValue(pos, typeNameIndex, constNameIndex);
        }

        @Override
        void classMemberValue(int pos, int index) throws Exception {
            this.currentMember = new ClassMemberValue(index, this.pool);
            super.classMemberValue(pos, index);
        }

        @Override
        int annotationMemberValue(int pos) throws Exception {
            Annotation annotation = this.currentAnno;
            pos = super.annotationMemberValue(pos);
            this.currentMember = new AnnotationMemberValue(this.currentAnno, this.pool);
            this.currentAnno = annotation;
            return pos;
        }

        @Override
        int arrayMemberValue(int pos, int num) throws Exception {
            ArrayMemberValue arrayMemberValue = new ArrayMemberValue(this.pool);
            MemberValue[] memberValueArray = new MemberValue[num];
            for (int i2 = 0; i2 < num; ++i2) {
                pos = this.memberValue(pos);
                memberValueArray[i2] = this.currentMember;
            }
            arrayMemberValue.setValue(memberValueArray);
            this.currentMember = arrayMemberValue;
            return pos;
        }
    }

    static class Copier
    extends Walker {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AnnotationsWriter writer;
        ConstPool srcPool;
        ConstPool destPool;
        Map<String, String> classnames;

        Copier(byte[] info, ConstPool src, ConstPool dest, Map<String, String> map) {
            this(info, src, dest, map, true);
        }

        Copier(byte[] info, ConstPool src, ConstPool dest, Map<String, String> map, boolean makeWriter) {
            super(info);
            if (makeWriter) {
                this.writer = new AnnotationsWriter(this.output, dest);
            }
            this.srcPool = src;
            this.destPool = dest;
            this.classnames = map;
        }

        byte[] close() throws IOException {
            this.writer.close();
            return this.output.toByteArray();
        }

        @Override
        void parameters(int numParam, int pos) throws Exception {
            this.writer.numParameters(numParam);
            super.parameters(numParam, pos);
        }

        @Override
        int annotationArray(int pos, int num) throws Exception {
            this.writer.numAnnotations(num);
            return super.annotationArray(pos, num);
        }

        @Override
        int annotation(int pos, int type, int numPairs) throws Exception {
            this.writer.annotation(this.copyType(type), numPairs);
            return super.annotation(pos, type, numPairs);
        }

        @Override
        int memberValuePair(int pos, int nameIndex) throws Exception {
            this.writer.memberValuePair(this.copy(nameIndex));
            return super.memberValuePair(pos, nameIndex);
        }

        @Override
        void constValueMember(int tag, int index) throws Exception {
            this.writer.constValueIndex(tag, this.copy(index));
            super.constValueMember(tag, index);
        }

        @Override
        void enumMemberValue(int pos, int typeNameIndex, int constNameIndex) throws Exception {
            this.writer.enumConstValue(this.copyType(typeNameIndex), this.copy(constNameIndex));
            super.enumMemberValue(pos, typeNameIndex, constNameIndex);
        }

        @Override
        void classMemberValue(int pos, int index) throws Exception {
            this.writer.classInfoIndex(this.copyType(index));
            super.classMemberValue(pos, index);
        }

        @Override
        int annotationMemberValue(int pos) throws Exception {
            this.writer.annotationValue();
            return super.annotationMemberValue(pos);
        }

        @Override
        int arrayMemberValue(int pos, int num) throws Exception {
            this.writer.arrayValue(num);
            return super.arrayMemberValue(pos, num);
        }

        int copy(int srcIndex) {
            return this.srcPool.copy(srcIndex, this.destPool, this.classnames);
        }

        int copyType(int srcIndex) {
            String string = this.srcPool.getUtf8Info(srcIndex);
            String string2 = Descriptor.rename(string, this.classnames);
            return this.destPool.addUtf8Info(string2);
        }
    }

    static class Renamer
    extends Walker {
        ConstPool cpool;
        Map<String, String> classnames;

        Renamer(byte[] info, ConstPool cp, Map<String, String> map) {
            super(info);
            this.cpool = cp;
            this.classnames = map;
        }

        @Override
        int annotation(int pos, int type, int numPairs) throws Exception {
            this.renameType(pos - 4, type);
            return super.annotation(pos, type, numPairs);
        }

        @Override
        void enumMemberValue(int pos, int typeNameIndex, int constNameIndex) throws Exception {
            this.renameType(pos + 1, typeNameIndex);
            super.enumMemberValue(pos, typeNameIndex, constNameIndex);
        }

        @Override
        void classMemberValue(int pos, int index) throws Exception {
            this.renameType(pos + 1, index);
            super.classMemberValue(pos, index);
        }

        private void renameType(int pos, int index) {
            String string;
            String string2 = this.cpool.getUtf8Info(index);
            if (!string2.equals(string = Descriptor.rename(string2, this.classnames))) {
                int n2 = this.cpool.addUtf8Info(string);
                ByteArray.write16bit(n2, this.info, pos);
            }
        }
    }

    static class Walker {
        byte[] info;

        Walker(byte[] attrInfo) {
            this.info = attrInfo;
        }

        final void parameters() throws Exception {
            int n2 = this.info[0] & 0xFF;
            this.parameters(n2, 1);
        }

        void parameters(int numParam, int pos) throws Exception {
            for (int i2 = 0; i2 < numParam; ++i2) {
                pos = this.annotationArray(pos);
            }
        }

        final void annotationArray() throws Exception {
            this.annotationArray(0);
        }

        final int annotationArray(int pos) throws Exception {
            int n2 = ByteArray.readU16bit(this.info, pos);
            return this.annotationArray(pos + 2, n2);
        }

        int annotationArray(int pos, int num) throws Exception {
            for (int i2 = 0; i2 < num; ++i2) {
                pos = this.annotation(pos);
            }
            return pos;
        }

        final int annotation(int pos) throws Exception {
            int n2 = ByteArray.readU16bit(this.info, pos);
            int n3 = ByteArray.readU16bit(this.info, pos + 2);
            return this.annotation(pos + 4, n2, n3);
        }

        int annotation(int pos, int type, int numPairs) throws Exception {
            for (int i2 = 0; i2 < numPairs; ++i2) {
                pos = this.memberValuePair(pos);
            }
            return pos;
        }

        final int memberValuePair(int pos) throws Exception {
            int n2 = ByteArray.readU16bit(this.info, pos);
            return this.memberValuePair(pos + 2, n2);
        }

        int memberValuePair(int pos, int nameIndex) throws Exception {
            return this.memberValue(pos);
        }

        final int memberValue(int pos) throws Exception {
            int n2 = this.info[pos] & 0xFF;
            if (n2 == 101) {
                int n3 = ByteArray.readU16bit(this.info, pos + 1);
                int n4 = ByteArray.readU16bit(this.info, pos + 3);
                this.enumMemberValue(pos, n3, n4);
                return pos + 5;
            }
            if (n2 == 99) {
                int n5 = ByteArray.readU16bit(this.info, pos + 1);
                this.classMemberValue(pos, n5);
                return pos + 3;
            }
            if (n2 == 64) {
                return this.annotationMemberValue(pos + 1);
            }
            if (n2 == 91) {
                int n6 = ByteArray.readU16bit(this.info, pos + 1);
                return this.arrayMemberValue(pos + 3, n6);
            }
            int n7 = ByteArray.readU16bit(this.info, pos + 1);
            this.constValueMember(n2, n7);
            return pos + 3;
        }

        void constValueMember(int tag, int index) throws Exception {
        }

        void enumMemberValue(int pos, int typeNameIndex, int constNameIndex) throws Exception {
        }

        void classMemberValue(int pos, int index) throws Exception {
        }

        int annotationMemberValue(int pos) throws Exception {
            return this.annotation(pos);
        }

        int arrayMemberValue(int pos, int num) throws Exception {
            for (int i2 = 0; i2 < num; ++i2) {
                pos = this.memberValue(pos);
            }
            return pos;
        }
    }
}

