/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import java.io.IOException;
import java.io.OutputStream;

final class ByteStream
extends OutputStream {
    private byte[] buf;
    private int count;

    public ByteStream() {
        this(32);
    }

    public ByteStream(int size) {
        this.buf = new byte[size];
        this.count = 0;
    }

    public final int getPos() {
        return this.count;
    }

    public final int size() {
        return this.count;
    }

    public final void writeBlank(int len) {
        this.enlarge(len);
        this.count += len;
    }

    @Override
    public final void write(byte[] data) {
        this.write(data, 0, data.length);
    }

    @Override
    public final void write(byte[] data, int off, int len) {
        this.enlarge(len);
        System.arraycopy(data, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public final void write(int b2) {
        this.enlarge(1);
        int n2 = this.count;
        this.buf[n2] = (byte)b2;
        this.count = n2 + 1;
    }

    public final void writeShort(int s2) {
        this.enlarge(2);
        int n2 = this.count;
        this.buf[n2] = (byte)(s2 >>> 8);
        this.buf[n2 + 1] = (byte)s2;
        this.count = n2 + 2;
    }

    public final void writeInt(int i2) {
        this.enlarge(4);
        int n2 = this.count;
        this.buf[n2] = (byte)(i2 >>> 24);
        this.buf[n2 + 1] = (byte)(i2 >>> 16);
        this.buf[n2 + 2] = (byte)(i2 >>> 8);
        this.buf[n2 + 3] = (byte)i2;
        this.count = n2 + 4;
    }

    public final void writeLong(long i2) {
        this.enlarge(8);
        int n2 = this.count;
        this.buf[n2] = (byte)(i2 >>> 56);
        this.buf[n2 + 1] = (byte)(i2 >>> 48);
        this.buf[n2 + 2] = (byte)(i2 >>> 40);
        this.buf[n2 + 3] = (byte)(i2 >>> 32);
        this.buf[n2 + 4] = (byte)(i2 >>> 24);
        this.buf[n2 + 5] = (byte)(i2 >>> 16);
        this.buf[n2 + 6] = (byte)(i2 >>> 8);
        this.buf[n2 + 7] = (byte)i2;
        this.count = n2 + 8;
    }

    public final void writeFloat(float v2) {
        this.writeInt(Float.floatToIntBits(v2));
    }

    public final void writeDouble(double v2) {
        this.writeLong(Double.doubleToLongBits(v2));
    }

    public final void writeUTF(String s2) {
        int n2 = s2.length();
        int n3 = this.count;
        this.enlarge(n2 + 2);
        byte[] byArray = this.buf;
        this.buf[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 <= '\u0000' || c2 > '\u007f') {
                this.writeUTF2(s2, n2, i2);
                return;
            }
            byArray[n3++] = (byte)c2;
        }
        this.count = n3;
    }

    private void writeUTF2(String s2, int sLen, int offset) {
        int n2;
        int n3 = sLen;
        for (n2 = offset; n2 < sLen; ++n2) {
            char c2 = s2.charAt(n2);
            if (c2 > '\u07ff') {
                n3 += 2;
                continue;
            }
            if (c2 != '\u0000' && c2 <= '\u007f') continue;
            ++n3;
        }
        if (n3 > 65535) {
            throw new RuntimeException("encoded string too long: " + sLen + n3 + " bytes");
        }
        this.enlarge(n3 + 2);
        n2 = this.count;
        byte[] byArray = this.buf;
        this.buf[n2] = (byte)(n3 >>> 8);
        byArray[n2 + 1] = (byte)n3;
        n2 += offset + 2;
        for (int i2 = offset; i2 < sLen; ++i2) {
            char c3 = s2.charAt(i2);
            if (c3 > '\u0000' && c3 <= '\u007f') {
                byArray[n2++] = (byte)c3;
                continue;
            }
            if (c3 > '\u07ff') {
                byArray[n2] = (byte)(0xE0 | c3 >> 12 & 0xF);
                byArray[n2 + 1] = (byte)(0x80 | c3 >> 6 & 0x3F);
                byArray[n2 + 2] = (byte)(0x80 | c3 & 0x3F);
                n2 += 3;
                continue;
            }
            byArray[n2] = (byte)(0xC0 | c3 >> 6 & 0x1F);
            byArray[n2 + 1] = (byte)(0x80 | c3 & 0x3F);
            n2 += 2;
        }
        this.count = n2;
    }

    public final void write(int pos, int value) {
        this.buf[pos] = (byte)value;
    }

    public final void writeShort(int pos, int value) {
        this.buf[pos] = (byte)(value >>> 8);
        this.buf[pos + 1] = (byte)value;
    }

    public final void writeInt(int pos, int value) {
        this.buf[pos] = (byte)(value >>> 24);
        this.buf[pos + 1] = (byte)(value >>> 16);
        this.buf[pos + 2] = (byte)(value >>> 8);
        this.buf[pos + 3] = (byte)value;
    }

    public final byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public final void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public final void enlarge(int delta) {
        int n2 = this.count + delta;
        if (n2 > this.buf.length) {
            int n3 = this.buf.length << 1;
            byte[] byArray = new byte[n3 > n2 ? n3 : n2];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
    }
}

