/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.bytecode.AttributeInfo;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.CodeAnalyzer;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.ExceptionTable;
import ai.h2o.javassist.bytecode.Opcode;
import ai.h2o.javassist.bytecode.StackMap;
import ai.h2o.javassist.bytecode.StackMapTable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CodeAttribute
extends AttributeInfo
implements Opcode {
    public static final String tag = "Code";
    private int maxStack;
    private int maxLocals;
    private ExceptionTable exceptions;
    private List<AttributeInfo> attributes;

    public CodeAttribute(ConstPool cp, int stack, int locals, byte[] code, ExceptionTable etable) {
        super(cp, tag);
        this.maxStack = stack;
        this.maxLocals = locals;
        this.info = code;
        this.exceptions = etable;
        this.attributes = new ArrayList<AttributeInfo>();
    }

    private CodeAttribute(ConstPool cp, CodeAttribute src, Map<String, String> classnames) throws BadBytecode {
        super(cp, tag);
        this.maxStack = src.getMaxStack();
        this.maxLocals = src.getMaxLocals();
        this.exceptions = src.getExceptionTable().copy(cp, classnames);
        this.attributes = new ArrayList<AttributeInfo>();
        List<AttributeInfo> list = src.getAttributes();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            AttributeInfo attributeInfo = list.get(i2);
            this.attributes.add(attributeInfo.copy(cp, classnames));
        }
        this.info = src.copyCode(cp, classnames, this.exceptions, this);
    }

    CodeAttribute(ConstPool cp, int name_id, DataInputStream in) throws IOException {
        super(cp, name_id, (byte[])null);
        in.readInt();
        this.maxStack = in.readUnsignedShort();
        this.maxLocals = in.readUnsignedShort();
        int n2 = in.readInt();
        this.info = new byte[n2];
        in.readFully(this.info);
        this.exceptions = new ExceptionTable(cp, in);
        this.attributes = new ArrayList<AttributeInfo>();
        int n3 = in.readUnsignedShort();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.attributes.add(AttributeInfo.read(cp, in));
        }
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) throws RuntimeCopyException {
        try {
            return new CodeAttribute(newCp, this, classnames);
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeCopyException("bad bytecode. fatal?");
        }
    }

    @Override
    public int length() {
        return 18 + this.info.length + (this.exceptions.size() << 3) + AttributeInfo.getLength(this.attributes);
    }

    @Override
    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.name);
        out.writeInt(this.length() - 6);
        out.writeShort(this.maxStack);
        out.writeShort(this.maxLocals);
        out.writeInt(this.info.length);
        out.write(this.info);
        this.exceptions.write(out);
        out.writeShort(this.attributes.size());
        AttributeInfo.writeAll(this.attributes, out);
    }

    @Override
    public byte[] get() {
        throw new UnsupportedOperationException("CodeAttribute.get()");
    }

    @Override
    public void set(byte[] newinfo) {
        throw new UnsupportedOperationException("CodeAttribute.set()");
    }

    @Override
    void renameClass(String oldname, String newname) {
        AttributeInfo.renameClass(this.attributes, oldname, newname);
    }

    @Override
    void renameClass(Map<String, String> classnames) {
        AttributeInfo.renameClass(this.attributes, classnames);
    }

    @Override
    void getRefClasses(Map<String, String> classnames) {
        AttributeInfo.getRefClasses(this.attributes, classnames);
    }

    public String getDeclaringClass() {
        ConstPool constPool = this.getConstPool();
        return constPool.getClassName();
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public void setMaxStack(int value) {
        this.maxStack = value;
    }

    public int computeMaxStack() throws BadBytecode {
        this.maxStack = new CodeAnalyzer(this).computeMaxStack();
        return this.maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public void setMaxLocals(int value) {
        this.maxLocals = value;
    }

    public int getCodeLength() {
        return this.info.length;
    }

    public byte[] getCode() {
        return this.info;
    }

    void setCode(byte[] newinfo) {
        super.set(newinfo);
    }

    public CodeIterator iterator() {
        return new CodeIterator(this);
    }

    public ExceptionTable getExceptionTable() {
        return this.exceptions;
    }

    public List<AttributeInfo> getAttributes() {
        return this.attributes;
    }

    public AttributeInfo getAttribute(String name) {
        return AttributeInfo.lookup(this.attributes, name);
    }

    public void setAttribute(StackMapTable smt) {
        AttributeInfo.remove(this.attributes, "StackMapTable");
        if (smt != null) {
            this.attributes.add(smt);
        }
    }

    public void setAttribute(StackMap sm) {
        AttributeInfo.remove(this.attributes, "StackMap");
        if (sm != null) {
            this.attributes.add(sm);
        }
    }

    private byte[] copyCode(ConstPool destCp, Map<String, String> classnames, ExceptionTable etable, CodeAttribute destCa) throws BadBytecode {
        int n2 = this.getCodeLength();
        byte[] byArray = new byte[n2];
        destCa.info = byArray;
        LdcEntry ldcEntry = CodeAttribute.copyCode(this.info, 0, n2, this.getConstPool(), byArray, destCp, classnames);
        return LdcEntry.doit(byArray, ldcEntry, etable, destCa);
    }

    private static LdcEntry copyCode(byte[] code, int beginPos, int endPos, ConstPool srcCp, byte[] newcode, ConstPool destCp, Map<String, String> classnameMap) throws BadBytecode {
        LdcEntry ldcEntry = null;
        int n2 = beginPos;
        while (n2 < endPos) {
            byte by;
            int n3 = CodeIterator.nextOpcode(code, n2);
            newcode[n2] = by = code[n2];
            switch (by & 0xFF) {
                case 19: 
                case 20: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    CodeAttribute.copyConstPoolInfo(n2 + 1, code, srcCp, newcode, destCp, classnameMap);
                    break;
                }
                case 18: {
                    int n4 = code[n2 + 1] & 0xFF;
                    n4 = srcCp.copy(n4, destCp, classnameMap);
                    if (n4 < 256) {
                        newcode[n2 + 1] = (byte)n4;
                        break;
                    }
                    newcode[n2] = 0;
                    newcode[n2 + 1] = 0;
                    LdcEntry ldcEntry2 = new LdcEntry();
                    new LdcEntry().where = n2;
                    ldcEntry2.index = n4;
                    ldcEntry2.next = ldcEntry;
                    ldcEntry = ldcEntry2;
                    break;
                }
                case 185: {
                    CodeAttribute.copyConstPoolInfo(n2 + 1, code, srcCp, newcode, destCp, classnameMap);
                    newcode[n2 + 3] = code[n2 + 3];
                    newcode[n2 + 4] = code[n2 + 4];
                    break;
                }
                case 186: {
                    CodeAttribute.copyConstPoolInfo(n2 + 1, code, srcCp, newcode, destCp, classnameMap);
                    newcode[n2 + 3] = 0;
                    newcode[n2 + 4] = 0;
                    break;
                }
                case 197: {
                    CodeAttribute.copyConstPoolInfo(n2 + 1, code, srcCp, newcode, destCp, classnameMap);
                    newcode[n2 + 3] = code[n2 + 3];
                    break;
                }
                default: {
                    while (++n2 < n3) {
                        newcode[n2] = code[n2];
                    }
                    break block0;
                }
            }
            n2 = n3;
        }
        return ldcEntry;
    }

    private static void copyConstPoolInfo(int i2, byte[] code, ConstPool srcCp, byte[] newcode, ConstPool destCp, Map<String, String> classnameMap) {
        int n2 = (code[i2] & 0xFF) << 8 | code[i2 + 1] & 0xFF;
        n2 = srcCp.copy(n2, destCp, classnameMap);
        newcode[i2] = (byte)(n2 >> 8);
        newcode[i2 + 1] = (byte)n2;
    }

    public void insertLocalVar(int where, int size) throws BadBytecode {
        CodeIterator codeIterator = this.iterator();
        while (codeIterator.hasNext()) {
            CodeAttribute.shiftIndex(codeIterator, where, size);
        }
        CodeAttribute codeAttribute = this;
        codeAttribute.setMaxLocals(codeAttribute.getMaxLocals() + size);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void shiftIndex(CodeIterator ci, int lessThan, int delta) throws BadBytecode {
        int n2 = ci.next();
        int n3 = ci.byteAt(n2);
        if (n3 < 21) {
            return;
        }
        if (n3 < 79) {
            if (n3 < 26) {
                CodeAttribute.shiftIndex8(ci, n2, n3, lessThan, delta);
                return;
            }
            if (n3 < 46) {
                CodeAttribute.shiftIndex0(ci, n2, n3, lessThan, delta, 26, 21);
                return;
            }
            if (n3 < 54) {
                return;
            }
            if (n3 < 59) {
                CodeAttribute.shiftIndex8(ci, n2, n3, lessThan, delta);
                return;
            }
            CodeAttribute.shiftIndex0(ci, n2, n3, lessThan, delta, 59, 54);
            return;
        }
        if (n3 == 132) {
            int n4 = ci.byteAt(n2 + 1);
            if (n4 < lessThan) {
                return;
            }
            if ((n4 += delta) < 256) {
                ci.writeByte(n4, n2 + 1);
                return;
            }
            byte by = (byte)ci.byteAt(n2 + 2);
            int n5 = ci.insertExGap(3);
            ci.writeByte(196, n5 - 3);
            ci.writeByte(132, n5 - 2);
            ci.write16bit(n4, n5 - 1);
            ci.write16bit(by, n5 + 1);
            return;
        }
        if (n3 == 169) {
            CodeAttribute.shiftIndex8(ci, n2, n3, lessThan, delta);
            return;
        }
        if (n3 != 196) return;
        int n6 = ci.u16bitAt(n2 + 2);
        if (n6 < lessThan) {
            return;
        }
        ci.write16bit(n6 += delta, n2 + 2);
    }

    private static void shiftIndex8(CodeIterator ci, int index, int opcode, int lessThan, int delta) throws BadBytecode {
        int n2 = ci.byteAt(index + 1);
        if (n2 < lessThan) {
            return;
        }
        if ((n2 += delta) < 256) {
            ci.writeByte(n2, index + 1);
            return;
        }
        int n3 = ci.insertExGap(2);
        ci.writeByte(196, n3 - 2);
        ci.writeByte(opcode, n3 - 1);
        ci.write16bit(n2, n3);
    }

    private static void shiftIndex0(CodeIterator ci, int index, int opcode, int lessThan, int delta, int opcode_i_0, int opcode_i) throws BadBytecode {
        int n2 = (opcode - opcode_i_0) % 4;
        if (n2 < lessThan) {
            return;
        }
        if ((n2 += delta) < 4) {
            ci.writeByte(opcode + delta, index);
            return;
        }
        opcode = (opcode - opcode_i_0) / 4 + opcode_i;
        if (n2 < 256) {
            int n3 = ci.insertExGap(1);
            ci.writeByte(opcode, n3 - 1);
            ci.writeByte(n2, n3);
            return;
        }
        int n4 = ci.insertExGap(3);
        ci.writeByte(196, n4 - 1);
        ci.writeByte(opcode, n4);
        ci.write16bit(n2, n4 + 1);
    }

    static class LdcEntry {
        LdcEntry next;
        int where;
        int index;

        LdcEntry() {
        }

        static byte[] doit(byte[] code, LdcEntry ldc, ExceptionTable etable, CodeAttribute ca) throws BadBytecode {
            if (ldc != null) {
                code = CodeIterator.changeLdcToLdcW(code, etable, ca, ldc);
            }
            return code;
        }
    }

    public static class RuntimeCopyException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public RuntimeCopyException(String s2) {
            super(s2);
        }
    }
}

