/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.bytecode.AttributeInfo;
import ai.h2o.javassist.bytecode.ByteArray;
import ai.h2o.javassist.bytecode.ConstPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;

public class EnclosingMethodAttribute
extends AttributeInfo {
    public static final String tag = "EnclosingMethod";

    EnclosingMethodAttribute(ConstPool cp, int n2, DataInputStream in) throws IOException {
        super(cp, n2, in);
    }

    public EnclosingMethodAttribute(ConstPool cp, String className, String methodName, String methodDesc) {
        super(cp, tag);
        int n2 = cp.addClassInfo(className);
        int n3 = cp.addNameAndTypeInfo(methodName, methodDesc);
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)(n2 >>> 8);
        byArray2[1] = (byte)n2;
        byArray2[2] = (byte)(n3 >>> 8);
        byArray2[3] = (byte)n3;
        this.set(byArray2);
    }

    public EnclosingMethodAttribute(ConstPool cp, String className) {
        super(cp, tag);
        int n2 = cp.addClassInfo(className);
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)(n2 >>> 8);
        byArray2[1] = (byte)n2;
        byArray2[2] = 0;
        byArray2[3] = 0;
        this.set(byArray2);
    }

    public int classIndex() {
        return ByteArray.readU16bit(this.get(), 0);
    }

    public int methodIndex() {
        return ByteArray.readU16bit(this.get(), 2);
    }

    public String className() {
        return this.getConstPool().getClassInfo(this.classIndex());
    }

    public String methodName() {
        ConstPool constPool = this.getConstPool();
        int n2 = this.methodIndex();
        if (n2 == 0) {
            return "<clinit>";
        }
        int n3 = constPool.getNameAndTypeName(n2);
        return constPool.getUtf8Info(n3);
    }

    public String methodDescriptor() {
        ConstPool constPool = this.getConstPool();
        int n2 = this.methodIndex();
        int n3 = constPool.getNameAndTypeDescriptor(n2);
        return constPool.getUtf8Info(n3);
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        if (this.methodIndex() == 0) {
            return new EnclosingMethodAttribute(newCp, this.className());
        }
        return new EnclosingMethodAttribute(newCp, this.className(), this.methodName(), this.methodDescriptor());
    }
}

