/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode.analysis;

import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.Modifier;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.InstructionPrinter;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.analysis.Analyzer;
import ai.h2o.javassist.bytecode.analysis.Frame;
import ai.h2o.javassist.bytecode.analysis.Type;
import java.io.PrintStream;

public final class FramePrinter {
    private final PrintStream stream;

    public FramePrinter(PrintStream stream) {
        this.stream = stream;
    }

    public static void print(CtClass clazz, PrintStream stream) {
        new FramePrinter(stream).print(clazz);
    }

    public final void print(CtClass clazz) {
        CtMethod[] ctMethodArray = clazz.getDeclaredMethods();
        for (int i2 = 0; i2 < ctMethodArray.length; ++i2) {
            this.print(ctMethodArray[i2]);
        }
    }

    private String getMethodString(CtMethod method) {
        try {
            return Modifier.toString(method.getModifiers()) + " " + method.getReturnType().getName() + " " + method.getName() + Descriptor.toString(method.getSignature()) + ";";
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
    }

    public final void print(CtMethod method) {
        Frame[] frameArray;
        this.stream.println("\n" + this.getMethodString(method));
        MethodInfo methodInfo = method.getMethodInfo2();
        ConstPool constPool = methodInfo.getConstPool();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            return;
        }
        try {
            frameArray = new Analyzer().analyze(method.getDeclaringClass(), methodInfo);
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException(badBytecode);
        }
        int n2 = String.valueOf(codeAttribute.getCodeLength()).length();
        CodeIterator codeIterator = codeAttribute.iterator();
        while (codeIterator.hasNext()) {
            int n3;
            try {
                n3 = codeIterator.next();
            }
            catch (BadBytecode badBytecode) {
                throw new RuntimeException(badBytecode);
            }
            this.stream.println(n3 + ": " + InstructionPrinter.instructionString(codeIterator, n3, constPool));
            this.addSpacing(n2 + 3);
            Frame frame = frameArray[n3];
            if (frame == null) {
                this.stream.println("--DEAD CODE--");
                continue;
            }
            this.printStack(frame);
            this.addSpacing(n2 + 3);
            this.printLocals(frame);
        }
    }

    private void printStack(Frame frame) {
        this.stream.print("stack [");
        int n2 = frame.getTopIndex();
        for (int i2 = 0; i2 <= n2; ++i2) {
            if (i2 > 0) {
                this.stream.print(", ");
            }
            Type type = frame.getStack(i2);
            this.stream.print(type);
        }
        this.stream.println("]");
    }

    private void printLocals(Frame frame) {
        this.stream.print("locals [");
        int n2 = frame.localsLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Type type;
            if (i2 > 0) {
                this.stream.print(", ");
            }
            this.stream.print((type = frame.getLocal(i2)) == null ? "empty" : type.toString());
        }
        this.stream.println("]");
    }

    private void addSpacing(int count) {
        while (count-- > 0) {
            this.stream.print(' ');
        }
    }
}

