/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode.annotation;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.annotation.AnnotationsWriter;
import ai.h2o.javassist.bytecode.annotation.MemberValueVisitor;
import ai.h2o.javassist.bytecode.annotation.NoSuchClassError;
import java.io.IOException;
import java.lang.reflect.Method;

public abstract class MemberValue {
    ConstPool cp;
    char tag;

    MemberValue(char tag, ConstPool cp) {
        this.cp = cp;
        this.tag = tag;
    }

    abstract Object getValue(ClassLoader var1, ClassPool var2, Method var3) throws ClassNotFoundException;

    abstract Class<?> getType(ClassLoader var1) throws ClassNotFoundException;

    static Class<?> loadClass(ClassLoader cl, String classname) throws ClassNotFoundException, NoSuchClassError {
        try {
            return Class.forName(MemberValue.convertFromArray(classname), true, cl);
        }
        catch (LinkageError linkageError) {
            throw new NoSuchClassError(classname, linkageError);
        }
    }

    private static String convertFromArray(String classname) {
        int n2 = classname.indexOf("[]");
        if (n2 != -1) {
            String string = classname.substring(0, n2);
            StringBuffer stringBuffer = new StringBuffer(Descriptor.of(string));
            while (n2 != -1) {
                stringBuffer.insert(0, "[");
                n2 = classname.indexOf("[]", n2 + 1);
            }
            return stringBuffer.toString().replace('/', '.');
        }
        return classname;
    }

    public abstract void accept(MemberValueVisitor var1);

    public abstract void write(AnnotationsWriter var1) throws IOException;
}

