/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode.stackmap;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.ByteArray;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.Opcode;
import ai.h2o.javassist.bytecode.stackmap.TypeData;
import ai.h2o.javassist.bytecode.stackmap.TypeTag;

public abstract class Tracer
implements TypeTag {
    protected ClassPool classPool;
    protected ConstPool cpool;
    protected String returnType;
    protected int stackTop;
    protected TypeData[] stackTypes;
    protected TypeData[] localsTypes;

    public Tracer(ClassPool classes, ConstPool cp, int maxStack, int maxLocals, String retType) {
        this.classPool = classes;
        this.cpool = cp;
        this.returnType = retType;
        this.stackTop = 0;
        this.stackTypes = TypeData.make(maxStack);
        this.localsTypes = TypeData.make(maxLocals);
    }

    public Tracer(Tracer t2) {
        this.classPool = t2.classPool;
        this.cpool = t2.cpool;
        this.returnType = t2.returnType;
        this.stackTop = t2.stackTop;
        this.stackTypes = TypeData.make(t2.stackTypes.length);
        this.localsTypes = TypeData.make(t2.localsTypes.length);
    }

    protected int doOpcode(int pos, byte[] code) throws BadBytecode {
        try {
            int n2 = code[pos] & 0xFF;
            if (n2 < 54) {
                return this.doOpcode0_53(pos, code, n2);
            }
            if (n2 < 96) {
                return this.doOpcode54_95(pos, code, n2);
            }
            if (n2 < 148) {
                return this.doOpcode96_147(pos, code, n2);
            }
            return this.doOpcode148_201(pos, code, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BadBytecode("inconsistent stack height " + arrayIndexOutOfBoundsException.getMessage(), (Throwable)arrayIndexOutOfBoundsException);
        }
    }

    protected void visitBranch(int pos, byte[] code, int offset) throws BadBytecode {
    }

    protected void visitGoto(int pos, byte[] code, int offset) throws BadBytecode {
    }

    protected void visitReturn(int pos, byte[] code) throws BadBytecode {
    }

    protected void visitThrow(int pos, byte[] code) throws BadBytecode {
    }

    protected void visitTableSwitch(int pos, byte[] code, int n2, int offsetPos, int defaultOffset) throws BadBytecode {
    }

    protected void visitLookupSwitch(int pos, byte[] code, int n2, int pairsPos, int defaultOffset) throws BadBytecode {
    }

    protected void visitJSR(int pos, byte[] code) throws BadBytecode {
    }

    protected void visitRET(int pos, byte[] code) throws BadBytecode {
    }

    private int doOpcode0_53(int pos, byte[] code, int op) throws BadBytecode {
        TypeData[] typeDataArray = this.stackTypes;
        switch (op) {
            case 0: {
                break;
            }
            case 1: {
                typeDataArray[this.stackTop++] = new TypeData.NullType();
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                typeDataArray[this.stackTop++] = INTEGER;
                break;
            }
            case 9: 
            case 10: {
                typeDataArray[this.stackTop++] = LONG;
                typeDataArray[this.stackTop++] = TOP;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                typeDataArray[this.stackTop++] = FLOAT;
                break;
            }
            case 14: 
            case 15: {
                typeDataArray[this.stackTop++] = DOUBLE;
                typeDataArray[this.stackTop++] = TOP;
                break;
            }
            case 16: 
            case 17: {
                typeDataArray[this.stackTop++] = INTEGER;
                if (op == 17) {
                    return 3;
                }
                return 2;
            }
            case 18: {
                this.doLDC(code[pos + 1] & 0xFF);
                return 2;
            }
            case 19: 
            case 20: {
                this.doLDC(ByteArray.readU16bit(code, pos + 1));
                return 3;
            }
            case 21: {
                return this.doXLOAD(INTEGER, code, pos);
            }
            case 22: {
                return this.doXLOAD(LONG, code, pos);
            }
            case 23: {
                return this.doXLOAD(FLOAT, code, pos);
            }
            case 24: {
                return this.doXLOAD(DOUBLE, code, pos);
            }
            case 25: {
                return this.doALOAD(code[pos + 1] & 0xFF);
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                typeDataArray[this.stackTop++] = INTEGER;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                typeDataArray[this.stackTop++] = LONG;
                typeDataArray[this.stackTop++] = TOP;
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                typeDataArray[this.stackTop++] = FLOAT;
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                typeDataArray[this.stackTop++] = DOUBLE;
                typeDataArray[this.stackTop++] = TOP;
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                int n2 = op - 42;
                typeDataArray[this.stackTop++] = this.localsTypes[n2];
                break;
            }
            case 46: {
                typeDataArray[--this.stackTop - 1] = INTEGER;
                break;
            }
            case 47: {
                typeDataArray[this.stackTop - 2] = LONG;
                typeDataArray[this.stackTop - 1] = TOP;
                break;
            }
            case 48: {
                typeDataArray[--this.stackTop - 1] = FLOAT;
                break;
            }
            case 49: {
                typeDataArray[this.stackTop - 2] = DOUBLE;
                typeDataArray[this.stackTop - 1] = TOP;
                break;
            }
            case 50: {
                int n3 = --this.stackTop - 1;
                TypeData typeData = typeDataArray[n3];
                typeDataArray[n3] = TypeData.ArrayElement.make(typeData);
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                typeDataArray[--this.stackTop - 1] = INTEGER;
                break;
            }
            default: {
                throw new RuntimeException("fatal");
            }
        }
        return 1;
    }

    private void doLDC(int index) {
        TypeData[] typeDataArray = this.stackTypes;
        int n2 = this.cpool.getTag(index);
        if (n2 == 8) {
            typeDataArray[this.stackTop++] = new TypeData.ClassName("java.lang.String");
            return;
        }
        if (n2 == 3) {
            typeDataArray[this.stackTop++] = INTEGER;
            return;
        }
        if (n2 == 4) {
            typeDataArray[this.stackTop++] = FLOAT;
            return;
        }
        if (n2 == 5) {
            typeDataArray[this.stackTop++] = LONG;
            typeDataArray[this.stackTop++] = TOP;
            return;
        }
        if (n2 == 6) {
            typeDataArray[this.stackTop++] = DOUBLE;
            typeDataArray[this.stackTop++] = TOP;
            return;
        }
        if (n2 == 7) {
            typeDataArray[this.stackTop++] = new TypeData.ClassName("java.lang.Class");
            return;
        }
        throw new RuntimeException("bad LDC: " + n2);
    }

    private int doXLOAD(TypeData type, byte[] code, int pos) {
        int n2 = code[pos + 1] & 0xFF;
        return this.doXLOAD(n2, type);
    }

    private int doXLOAD(int localVar, TypeData type) {
        this.stackTypes[this.stackTop++] = type;
        if (type.is2WordType()) {
            this.stackTypes[this.stackTop++] = TOP;
        }
        return 2;
    }

    private int doALOAD(int localVar) {
        this.stackTypes[this.stackTop++] = this.localsTypes[localVar];
        return 2;
    }

    private int doOpcode54_95(int pos, byte[] code, int op) throws BadBytecode {
        switch (op) {
            case 54: {
                return this.doXSTORE(pos, code, INTEGER);
            }
            case 55: {
                return this.doXSTORE(pos, code, LONG);
            }
            case 56: {
                return this.doXSTORE(pos, code, FLOAT);
            }
            case 57: {
                return this.doXSTORE(pos, code, DOUBLE);
            }
            case 58: {
                return this.doASTORE(code[pos + 1] & 0xFF);
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                int n2 = op - 59;
                this.localsTypes[n2] = INTEGER;
                --this.stackTop;
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                int n3 = op - 63;
                this.localsTypes[n3] = LONG;
                this.localsTypes[n3 + 1] = TOP;
                this.stackTop -= 2;
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                int n4 = op - 67;
                this.localsTypes[n4] = FLOAT;
                --this.stackTop;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                int n5 = op - 71;
                this.localsTypes[n5] = DOUBLE;
                this.localsTypes[n5 + 1] = TOP;
                this.stackTop -= 2;
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                int n6 = op - 75;
                this.doASTORE(n6);
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                this.stackTop -= op == 80 || op == 82 ? 4 : 3;
                break;
            }
            case 83: {
                TypeData.ArrayElement.aastore(this.stackTypes[this.stackTop - 3], this.stackTypes[this.stackTop - 1], this.classPool);
                this.stackTop -= 3;
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                this.stackTop -= 3;
                break;
            }
            case 87: {
                --this.stackTop;
                break;
            }
            case 88: {
                this.stackTop -= 2;
                break;
            }
            case 89: {
                int n7 = this.stackTop;
                this.stackTypes[n7] = this.stackTypes[n7 - 1];
                this.stackTop = n7 + 1;
                break;
            }
            case 90: 
            case 91: {
                int n8 = op - 90 + 2;
                this.doDUP_XX(1, n8);
                int n9 = this.stackTop;
                this.stackTypes[n9 - n8] = this.stackTypes[n9];
                this.stackTop = n9 + 1;
                break;
            }
            case 92: {
                this.doDUP_XX(2, 2);
                this.stackTop += 2;
                break;
            }
            case 93: 
            case 94: {
                int n10 = op - 93 + 3;
                this.doDUP_XX(2, n10);
                int n11 = this.stackTop;
                this.stackTypes[n11 - n10] = this.stackTypes[n11];
                this.stackTypes[n11 - n10 + 1] = this.stackTypes[n11 + 1];
                this.stackTop = n11 + 2;
                break;
            }
            case 95: {
                int n12 = this.stackTop - 1;
                TypeData typeData = this.stackTypes[n12];
                this.stackTypes[n12] = this.stackTypes[n12 - 1];
                this.stackTypes[n12 - 1] = typeData;
                break;
            }
            default: {
                throw new RuntimeException("fatal");
            }
        }
        return 1;
    }

    private int doXSTORE(int pos, byte[] code, TypeData type) {
        int n2 = code[pos + 1] & 0xFF;
        return this.doXSTORE(n2, type);
    }

    private int doXSTORE(int index, TypeData type) {
        --this.stackTop;
        this.localsTypes[index] = type;
        if (type.is2WordType()) {
            --this.stackTop;
            this.localsTypes[index + 1] = TOP;
        }
        return 2;
    }

    private int doASTORE(int index) {
        --this.stackTop;
        this.localsTypes[index] = this.stackTypes[this.stackTop];
        return 2;
    }

    private void doDUP_XX(int delta, int len) {
        int n2;
        TypeData[] typeDataArray = this.stackTypes;
        int n3 = n2 - len;
        for (n2 = this.stackTop - 1; n2 > n3; --n2) {
            typeDataArray[n2 + delta] = typeDataArray[n2];
        }
    }

    private int doOpcode96_147(int pos, byte[] code, int op) {
        if (op <= 131) {
            this.stackTop += Opcode.STACK_GROW[op];
            return 1;
        }
        switch (op) {
            case 132: {
                return 3;
            }
            case 133: {
                this.stackTypes[this.stackTop - 1] = LONG;
                this.stackTypes[this.stackTop] = TOP;
                ++this.stackTop;
                break;
            }
            case 134: {
                this.stackTypes[this.stackTop - 1] = FLOAT;
                break;
            }
            case 135: {
                this.stackTypes[this.stackTop - 1] = DOUBLE;
                this.stackTypes[this.stackTop] = TOP;
                ++this.stackTop;
                break;
            }
            case 136: {
                this.stackTypes[--this.stackTop - 1] = INTEGER;
                break;
            }
            case 137: {
                this.stackTypes[--this.stackTop - 1] = FLOAT;
                break;
            }
            case 138: {
                this.stackTypes[this.stackTop - 2] = DOUBLE;
                break;
            }
            case 139: {
                this.stackTypes[this.stackTop - 1] = INTEGER;
                break;
            }
            case 140: {
                this.stackTypes[this.stackTop - 1] = LONG;
                this.stackTypes[this.stackTop] = TOP;
                ++this.stackTop;
                break;
            }
            case 141: {
                this.stackTypes[this.stackTop - 1] = DOUBLE;
                this.stackTypes[this.stackTop] = TOP;
                ++this.stackTop;
                break;
            }
            case 142: {
                this.stackTypes[--this.stackTop - 1] = INTEGER;
                break;
            }
            case 143: {
                this.stackTypes[this.stackTop - 2] = LONG;
                break;
            }
            case 144: {
                this.stackTypes[--this.stackTop - 1] = FLOAT;
                break;
            }
            case 145: 
            case 146: 
            case 147: {
                break;
            }
            default: {
                throw new RuntimeException("fatal");
            }
        }
        return 1;
    }

    private int doOpcode148_201(int pos, byte[] code, int op) throws BadBytecode {
        switch (op) {
            case 148: {
                this.stackTypes[this.stackTop - 4] = INTEGER;
                this.stackTop -= 3;
                break;
            }
            case 149: 
            case 150: {
                this.stackTypes[--this.stackTop - 1] = INTEGER;
                break;
            }
            case 151: 
            case 152: {
                this.stackTypes[this.stackTop - 4] = INTEGER;
                this.stackTop -= 3;
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                --this.stackTop;
                this.visitBranch(pos, code, ByteArray.readS16bit(code, pos + 1));
                return 3;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.stackTop -= 2;
                this.visitBranch(pos, code, ByteArray.readS16bit(code, pos + 1));
                return 3;
            }
            case 167: {
                this.visitGoto(pos, code, ByteArray.readS16bit(code, pos + 1));
                return 3;
            }
            case 168: {
                this.visitJSR(pos, code);
                return 3;
            }
            case 169: {
                this.visitRET(pos, code);
                return 2;
            }
            case 170: {
                --this.stackTop;
                int n2 = (pos & 0xFFFFFFFC) + 8;
                int n3 = ByteArray.read32bit(code, n2);
                int n4 = ByteArray.read32bit(code, n2 + 4);
                int n5 = n4 - n3 + 1;
                this.visitTableSwitch(pos, code, n5, n2 + 8, ByteArray.read32bit(code, n2 - 4));
                return (n5 << 2) + 16 - (pos & 3);
            }
            case 171: {
                --this.stackTop;
                int n6 = (pos & 0xFFFFFFFC) + 8;
                int n7 = ByteArray.read32bit(code, n6);
                this.visitLookupSwitch(pos, code, n7, n6 + 4, ByteArray.read32bit(code, n6 - 4));
                return (n7 << 3) + 12 - (pos & 3);
            }
            case 172: {
                --this.stackTop;
                this.visitReturn(pos, code);
                break;
            }
            case 173: {
                this.stackTop -= 2;
                this.visitReturn(pos, code);
                break;
            }
            case 174: {
                --this.stackTop;
                this.visitReturn(pos, code);
                break;
            }
            case 175: {
                this.stackTop -= 2;
                this.visitReturn(pos, code);
                break;
            }
            case 176: {
                this.stackTypes[--this.stackTop].setType(this.returnType, this.classPool);
                this.visitReturn(pos, code);
                break;
            }
            case 177: {
                this.visitReturn(pos, code);
                break;
            }
            case 178: {
                return this.doGetField(pos, code, false);
            }
            case 179: {
                return this.doPutField(pos, code, false);
            }
            case 180: {
                return this.doGetField(pos, code, true);
            }
            case 181: {
                return this.doPutField(pos, code, true);
            }
            case 182: 
            case 183: {
                return this.doInvokeMethod(pos, code, true);
            }
            case 184: {
                return this.doInvokeMethod(pos, code, false);
            }
            case 185: {
                return this.doInvokeIntfMethod(pos, code);
            }
            case 186: {
                return this.doInvokeDynamic(pos, code);
            }
            case 187: {
                int n8 = ByteArray.readU16bit(code, pos + 1);
                this.stackTypes[this.stackTop++] = new TypeData.UninitData(pos, this.cpool.getClassInfo(n8));
                return 3;
            }
            case 188: {
                return this.doNEWARRAY(pos, code);
            }
            case 189: {
                int n9 = ByteArray.readU16bit(code, pos + 1);
                String string = this.cpool.getClassInfo(n9).replace('.', '/');
                string = string.charAt(0) == '[' ? "[" + string : "[L" + string + ";";
                this.stackTypes[this.stackTop - 1] = new TypeData.ClassName(string);
                return 3;
            }
            case 190: {
                this.stackTypes[this.stackTop - 1].setType("[Ljava.lang.Object;", this.classPool);
                this.stackTypes[this.stackTop - 1] = INTEGER;
                break;
            }
            case 191: {
                this.stackTypes[--this.stackTop].setType("java.lang.Throwable", this.classPool);
                this.visitThrow(pos, code);
                break;
            }
            case 192: {
                int n10 = ByteArray.readU16bit(code, pos + 1);
                String string = this.cpool.getClassInfo(n10);
                if (string.charAt(0) == '[') {
                    string = string.replace('.', '/');
                }
                this.stackTypes[this.stackTop - 1] = new TypeData.ClassName(string);
                return 3;
            }
            case 193: {
                this.stackTypes[this.stackTop - 1] = INTEGER;
                return 3;
            }
            case 194: 
            case 195: {
                --this.stackTop;
                break;
            }
            case 196: {
                return this.doWIDE(pos, code);
            }
            case 197: {
                return this.doMultiANewArray(pos, code);
            }
            case 198: 
            case 199: {
                --this.stackTop;
                this.visitBranch(pos, code, ByteArray.readS16bit(code, pos + 1));
                return 3;
            }
            case 200: {
                this.visitGoto(pos, code, ByteArray.read32bit(code, pos + 1));
                return 5;
            }
            case 201: {
                this.visitJSR(pos, code);
                return 5;
            }
        }
        return 1;
    }

    private int doWIDE(int pos, byte[] code) throws BadBytecode {
        int n2 = code[pos + 1] & 0xFF;
        switch (n2) {
            case 21: {
                this.doWIDE_XLOAD(pos, code, INTEGER);
                break;
            }
            case 22: {
                this.doWIDE_XLOAD(pos, code, LONG);
                break;
            }
            case 23: {
                this.doWIDE_XLOAD(pos, code, FLOAT);
                break;
            }
            case 24: {
                this.doWIDE_XLOAD(pos, code, DOUBLE);
                break;
            }
            case 25: {
                int n3 = ByteArray.readU16bit(code, pos + 2);
                this.doALOAD(n3);
                break;
            }
            case 54: {
                this.doWIDE_STORE(pos, code, INTEGER);
                break;
            }
            case 55: {
                this.doWIDE_STORE(pos, code, LONG);
                break;
            }
            case 56: {
                this.doWIDE_STORE(pos, code, FLOAT);
                break;
            }
            case 57: {
                this.doWIDE_STORE(pos, code, DOUBLE);
                break;
            }
            case 58: {
                int n4 = ByteArray.readU16bit(code, pos + 2);
                this.doASTORE(n4);
                break;
            }
            case 132: {
                return 6;
            }
            case 169: {
                this.visitRET(pos, code);
                break;
            }
            default: {
                throw new RuntimeException("bad WIDE instruction: " + n2);
            }
        }
        return 4;
    }

    private void doWIDE_XLOAD(int pos, byte[] code, TypeData type) {
        int n2 = ByteArray.readU16bit(code, pos + 2);
        this.doXLOAD(n2, type);
    }

    private void doWIDE_STORE(int pos, byte[] code, TypeData type) {
        int n2 = ByteArray.readU16bit(code, pos + 2);
        this.doXSTORE(n2, type);
    }

    private int doPutField(int pos, byte[] code, boolean notStatic) throws BadBytecode {
        int n2 = ByteArray.readU16bit(code, pos + 1);
        String string = this.cpool.getFieldrefType(n2);
        this.stackTop -= Descriptor.dataSize(string);
        char c2 = string.charAt(0);
        if (c2 == 'L') {
            this.stackTypes[this.stackTop].setType(Tracer.getFieldClassName(string, 0), this.classPool);
        } else if (c2 == '[') {
            this.stackTypes[this.stackTop].setType(string, this.classPool);
        }
        this.setFieldTarget(notStatic, n2);
        return 3;
    }

    private int doGetField(int pos, byte[] code, boolean notStatic) throws BadBytecode {
        int n2 = ByteArray.readU16bit(code, pos + 1);
        this.setFieldTarget(notStatic, n2);
        String string = this.cpool.getFieldrefType(n2);
        this.pushMemberType(string);
        return 3;
    }

    private void setFieldTarget(boolean notStatic, int index) throws BadBytecode {
        if (notStatic) {
            String string = this.cpool.getFieldrefClassName(index);
            this.stackTypes[--this.stackTop].setType(string, this.classPool);
        }
    }

    private int doNEWARRAY(int pos, byte[] code) {
        String string;
        int n2 = this.stackTop - 1;
        switch (code[pos + 1] & 0xFF) {
            case 4: {
                string = "[Z";
                break;
            }
            case 5: {
                string = "[C";
                break;
            }
            case 6: {
                string = "[F";
                break;
            }
            case 7: {
                string = "[D";
                break;
            }
            case 8: {
                string = "[B";
                break;
            }
            case 9: {
                string = "[S";
                break;
            }
            case 10: {
                string = "[I";
                break;
            }
            case 11: {
                string = "[J";
                break;
            }
            default: {
                throw new RuntimeException("bad newarray");
            }
        }
        this.stackTypes[n2] = new TypeData.ClassName(string);
        return 2;
    }

    private int doMultiANewArray(int pos, byte[] code) {
        int n2 = ByteArray.readU16bit(code, pos + 1);
        int n3 = code[pos + 3] & 0xFF;
        this.stackTop -= n3 - 1;
        String string = this.cpool.getClassInfo(n2).replace('.', '/');
        this.stackTypes[this.stackTop - 1] = new TypeData.ClassName(string);
        return 4;
    }

    private int doInvokeMethod(int pos, byte[] code, boolean notStatic) throws BadBytecode {
        int n2 = ByteArray.readU16bit(code, pos + 1);
        String string = this.cpool.getMethodrefType(n2);
        this.checkParamTypes(string, 1);
        if (notStatic) {
            TypeData typeData;
            String string2 = this.cpool.getMethodrefClassName(n2);
            if ((typeData = this.stackTypes[--this.stackTop]) instanceof TypeData.UninitTypeVar && typeData.isUninit()) {
                TypeData typeData2 = typeData;
                this.constructorCalled(typeData2, ((TypeData.UninitTypeVar)typeData2).offset());
            } else if (typeData instanceof TypeData.UninitData) {
                TypeData typeData3 = typeData;
                this.constructorCalled(typeData3, ((TypeData.UninitData)typeData3).offset());
            }
            typeData.setType(string2, this.classPool);
        }
        this.pushMemberType(string);
        return 3;
    }

    private void constructorCalled(TypeData target, int offset) {
        int n2;
        target.constructorCalled(offset);
        for (n2 = 0; n2 < this.stackTop; ++n2) {
            this.stackTypes[n2].constructorCalled(offset);
        }
        for (n2 = 0; n2 < this.localsTypes.length; ++n2) {
            this.localsTypes[n2].constructorCalled(offset);
        }
    }

    private int doInvokeIntfMethod(int pos, byte[] code) throws BadBytecode {
        int n2 = ByteArray.readU16bit(code, pos + 1);
        String string = this.cpool.getInterfaceMethodrefType(n2);
        this.checkParamTypes(string, 1);
        String string2 = this.cpool.getInterfaceMethodrefClassName(n2);
        this.stackTypes[--this.stackTop].setType(string2, this.classPool);
        this.pushMemberType(string);
        return 5;
    }

    private int doInvokeDynamic(int pos, byte[] code) throws BadBytecode {
        int n2 = ByteArray.readU16bit(code, pos + 1);
        String string = this.cpool.getInvokeDynamicType(n2);
        this.checkParamTypes(string, 1);
        this.pushMemberType(string);
        return 5;
    }

    private void pushMemberType(String descriptor) {
        int n2 = 0;
        if (descriptor.charAt(0) == '(' && (n2 = descriptor.indexOf(41) + 1) <= 0) {
            throw new IndexOutOfBoundsException("bad descriptor: " + descriptor);
        }
        TypeData[] typeDataArray = this.stackTypes;
        int n3 = this.stackTop;
        switch (descriptor.charAt(n2)) {
            case '[': {
                typeDataArray[n3] = new TypeData.ClassName(descriptor.substring(n2));
                break;
            }
            case 'L': {
                typeDataArray[n3] = new TypeData.ClassName(Tracer.getFieldClassName(descriptor, n2));
                break;
            }
            case 'J': {
                typeDataArray[n3] = LONG;
                typeDataArray[n3 + 1] = TOP;
                this.stackTop += 2;
                return;
            }
            case 'F': {
                typeDataArray[n3] = FLOAT;
                break;
            }
            case 'D': {
                typeDataArray[n3] = DOUBLE;
                typeDataArray[n3 + 1] = TOP;
                this.stackTop += 2;
                return;
            }
            case 'V': {
                return;
            }
            default: {
                typeDataArray[n3] = INTEGER;
            }
        }
        ++this.stackTop;
    }

    private static String getFieldClassName(String desc, int index) {
        return desc.substring(index + 1, desc.length() - 1).replace('/', '.');
    }

    private void checkParamTypes(String desc, int i2) throws BadBytecode {
        char c2 = desc.charAt(i2);
        if (c2 == ')') {
            return;
        }
        int n2 = i2;
        boolean bl = false;
        while (c2 == '[') {
            bl = true;
            c2 = desc.charAt(++n2);
        }
        if (c2 == 'L') {
            if ((n2 = desc.indexOf(59, n2) + 1) <= 0) {
                throw new IndexOutOfBoundsException("bad descriptor");
            }
        } else {
            ++n2;
        }
        this.checkParamTypes(desc, n2);
        this.stackTop = !(bl || c2 != 'J' && c2 != 'D') ? (this.stackTop -= 2) : --this.stackTop;
        if (bl) {
            this.stackTypes[this.stackTop].setType(desc.substring(i2, n2), this.classPool);
            return;
        }
        if (c2 == 'L') {
            this.stackTypes[this.stackTop].setType(desc.substring(i2 + 1, n2 - 1).replace('/', '.'), this.classPool);
        }
    }
}

