/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.compiler;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtPrimitiveType;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.Bytecode;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.JvstTypeChecker;
import ai.h2o.javassist.compiler.MemberCodeGen;
import ai.h2o.javassist.compiler.MemberResolver;
import ai.h2o.javassist.compiler.ProceedHandler;
import ai.h2o.javassist.compiler.SymbolTable;
import ai.h2o.javassist.compiler.ast.ASTList;
import ai.h2o.javassist.compiler.ast.ASTree;
import ai.h2o.javassist.compiler.ast.CallExpr;
import ai.h2o.javassist.compiler.ast.CastExpr;
import ai.h2o.javassist.compiler.ast.Declarator;
import ai.h2o.javassist.compiler.ast.Expr;
import ai.h2o.javassist.compiler.ast.Member;
import ai.h2o.javassist.compiler.ast.Stmnt;
import ai.h2o.javassist.compiler.ast.Symbol;

public class JvstCodeGen
extends MemberCodeGen {
    String paramArrayName = null;
    String paramListName = null;
    CtClass[] paramTypeList = null;
    private int paramVarBase = 0;
    private boolean useParam0 = false;
    private String param0Type = null;
    public static final String sigName = "$sig";
    public static final String dollarTypeName = "$type";
    public static final String clazzName = "$class";
    private CtClass dollarType = null;
    CtClass returnType = null;
    String returnCastName = null;
    private String returnVarName = null;
    public static final String wrapperCastName = "$w";
    String proceedName = null;
    public static final String cflowName = "$cflow";
    ProceedHandler procHandler = null;

    public JvstCodeGen(Bytecode b2, CtClass cc, ClassPool cp) {
        super(b2, cc, cp);
        this.setTypeChecker(new JvstTypeChecker(cc, cp, this));
    }

    private int indexOfParam1() {
        return this.paramVarBase + (this.useParam0 ? 1 : 0);
    }

    public void setProceedHandler(ProceedHandler h2, String name) {
        this.proceedName = name;
        this.procHandler = h2;
    }

    public void addNullIfVoid() {
        if (this.exprType == 344) {
            this.bytecode.addOpcode(1);
            this.exprType = 307;
            this.arrayDim = 0;
            this.className = "java/lang/Object";
        }
    }

    @Override
    public void atMember(Member mem) throws CompileError {
        String string = mem.get();
        if (string.equals(this.paramArrayName)) {
            JvstCodeGen.compileParameterList(this.bytecode, this.paramTypeList, this.indexOfParam1());
            this.exprType = 307;
            this.arrayDim = 1;
            this.className = "java/lang/Object";
            return;
        }
        if (string.equals(sigName)) {
            this.bytecode.addLdc(Descriptor.ofMethod(this.returnType, this.paramTypeList));
            this.bytecode.addInvokestatic("ai/h2o/javassist/runtime/Desc", "getParams", "(Ljava/lang/String;)[Ljava/lang/Class;");
            this.exprType = 307;
            this.arrayDim = 1;
            this.className = "java/lang/Class";
            return;
        }
        if (string.equals(dollarTypeName)) {
            if (this.dollarType == null) {
                throw new CompileError("$type is not available");
            }
            this.bytecode.addLdc(Descriptor.of(this.dollarType));
            this.callGetType("getType");
            return;
        }
        if (string.equals(clazzName)) {
            if (this.param0Type == null) {
                throw new CompileError("$class is not available");
            }
            this.bytecode.addLdc(this.param0Type);
            this.callGetType("getClazz");
            return;
        }
        super.atMember(mem);
    }

    private void callGetType(String method) {
        this.bytecode.addInvokestatic("ai/h2o/javassist/runtime/Desc", method, "(Ljava/lang/String;)Ljava/lang/Class;");
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = "java/lang/Class";
    }

    @Override
    protected void atFieldAssign(Expr expr, int op, ASTree left, ASTree right, boolean doDup) throws CompileError {
        if (left instanceof Member && ((Member)left).get().equals(this.paramArrayName)) {
            if (op != 61) {
                throw new CompileError("bad operator for " + this.paramArrayName);
            }
            right.accept(this);
            if (this.arrayDim != 1 || this.exprType != 307) {
                throw new CompileError("invalid type for " + this.paramArrayName);
            }
            JvstCodeGen jvstCodeGen = this;
            jvstCodeGen.atAssignParamList(jvstCodeGen.paramTypeList, this.bytecode);
            if (!doDup) {
                this.bytecode.addOpcode(87);
                return;
            }
        } else {
            super.atFieldAssign(expr, op, left, right, doDup);
        }
    }

    protected void atAssignParamList(CtClass[] params, Bytecode code) throws CompileError {
        if (params == null) {
            return;
        }
        int n2 = this.indexOfParam1();
        int n3 = params.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            code.addOpcode(89);
            code.addIconst(i2);
            code.addOpcode(50);
            this.compileUnwrapValue(params[i2], code);
            code.addStore(n2, params[i2]);
            n2 += JvstCodeGen.is2word(this.exprType, this.arrayDim) ? 2 : 1;
        }
    }

    @Override
    public void atCastExpr(CastExpr expr) throws CompileError {
        ASTree aSTree;
        ASTList aSTList = expr.getClassName();
        if (aSTList != null && expr.getArrayDim() == 0 && (aSTree = aSTList.head()) instanceof Symbol && aSTList.tail() == null) {
            String string = ((Symbol)aSTree).get();
            if (string.equals(this.returnCastName)) {
                this.atCastToRtype(expr);
                return;
            }
            if (string.equals(wrapperCastName)) {
                this.atCastToWrapper(expr);
                return;
            }
        }
        super.atCastExpr(expr);
    }

    protected void atCastToRtype(CastExpr expr) throws CompileError {
        expr.getOprand().accept(this);
        if (this.exprType == 344 || JvstCodeGen.isRefType(this.exprType) || this.arrayDim > 0) {
            JvstCodeGen jvstCodeGen = this;
            jvstCodeGen.compileUnwrapValue(jvstCodeGen.returnType, this.bytecode);
            return;
        }
        if (this.returnType instanceof CtPrimitiveType) {
            CtPrimitiveType ctPrimitiveType = (CtPrimitiveType)this.returnType;
            int n2 = MemberResolver.descToType(ctPrimitiveType.getDescriptor());
            JvstCodeGen jvstCodeGen = this;
            jvstCodeGen.atNumCastExpr(jvstCodeGen.exprType, n2);
            this.exprType = n2;
            this.arrayDim = 0;
            this.className = null;
            return;
        }
        throw new CompileError("invalid cast");
    }

    protected void atCastToWrapper(CastExpr expr) throws CompileError {
        expr.getOprand().accept(this);
        if (JvstCodeGen.isRefType(this.exprType) || this.arrayDim > 0) {
            return;
        }
        CtClass ctClass = this.resolver.lookupClass(this.exprType, this.arrayDim, this.className);
        if (ctClass instanceof CtPrimitiveType) {
            CtPrimitiveType ctPrimitiveType = (CtPrimitiveType)ctClass;
            String string = ctPrimitiveType.getWrapperName();
            this.bytecode.addNew(string);
            this.bytecode.addOpcode(89);
            if (ctPrimitiveType.getDataSize() > 1) {
                this.bytecode.addOpcode(94);
            } else {
                this.bytecode.addOpcode(93);
            }
            this.bytecode.addOpcode(88);
            this.bytecode.addInvokespecial(string, "<init>", "(" + ctPrimitiveType.getDescriptor() + ")V");
            this.exprType = 307;
            this.arrayDim = 0;
            this.className = "java/lang/Object";
        }
    }

    @Override
    public void atCallExpr(CallExpr expr) throws CompileError {
        ASTree aSTree = expr.oprand1();
        if (aSTree instanceof Member) {
            String string = ((Member)aSTree).get();
            if (this.procHandler != null && string.equals(this.proceedName)) {
                JvstCodeGen jvstCodeGen = this;
                this.procHandler.doit(jvstCodeGen, jvstCodeGen.bytecode, (ASTList)expr.oprand2());
                return;
            }
            if (string.equals(cflowName)) {
                this.atCflow((ASTList)expr.oprand2());
                return;
            }
        }
        super.atCallExpr(expr);
    }

    protected void atCflow(ASTList cname) throws CompileError {
        StringBuffer stringBuffer = new StringBuffer();
        if (cname == null || cname.tail() != null) {
            throw new CompileError("bad $cflow");
        }
        JvstCodeGen.makeCflowName(stringBuffer, cname.head());
        String string = stringBuffer.toString();
        Object[] objectArray = this.resolver.getClassPool().lookupCflow(string);
        if (objectArray == null) {
            throw new CompileError("no such $cflow: " + string);
        }
        this.bytecode.addGetstatic((String)objectArray[0], (String)objectArray[1], "Lai/h2o/javassist/runtime/Cflow;");
        this.bytecode.addInvokevirtual("ai.h2o.javassist.runtime.Cflow", "value", "()I");
        this.exprType = 324;
        this.arrayDim = 0;
        this.className = null;
    }

    private static void makeCflowName(StringBuffer sbuf, ASTree name) throws CompileError {
        while (true) {
            Expr expr;
            if (name instanceof Symbol) {
                sbuf.append(((Symbol)name).get());
                return;
            }
            if (!(name instanceof Expr) || (expr = (Expr)name).getOperator() != 46) break;
            JvstCodeGen.makeCflowName(sbuf, expr.oprand1());
            sbuf.append('.');
            name = expr.oprand2();
        }
        throw new CompileError("bad $cflow");
    }

    public boolean isParamListName(ASTList args) {
        if (this.paramTypeList != null && args != null && args.tail() == null) {
            ASTree aSTree = args.head();
            return aSTree instanceof Member && ((Member)aSTree).get().equals(this.paramListName);
        }
        return false;
    }

    @Override
    public int getMethodArgsLength(ASTList args) {
        String string = this.paramListName;
        int n2 = 0;
        while (args != null) {
            ASTree aSTree = args.head();
            if (aSTree instanceof Member && ((Member)aSTree).get().equals(string)) {
                if (this.paramTypeList != null) {
                    n2 += this.paramTypeList.length;
                }
            } else {
                ++n2;
            }
            args = args.tail();
        }
        return n2;
    }

    @Override
    public void atMethodArgs(ASTList args, int[] types, int[] dims, String[] cnames) throws CompileError {
        CtClass[] ctClassArray = this.paramTypeList;
        String string = this.paramListName;
        int n2 = 0;
        while (args != null) {
            ASTree aSTree = args.head();
            if (aSTree instanceof Member && ((Member)aSTree).get().equals(string)) {
                if (ctClassArray != null) {
                    int n3 = ctClassArray.length;
                    int n4 = this.indexOfParam1();
                    for (int i2 = 0; i2 < n3; ++i2) {
                        CtClass ctClass = ctClassArray[i2];
                        n4 += this.bytecode.addLoad(n4, ctClass);
                        this.setType(ctClass);
                        types[n2] = this.exprType;
                        dims[n2] = this.arrayDim;
                        cnames[n2] = this.className;
                        ++n2;
                    }
                }
            } else {
                aSTree.accept(this);
                types[n2] = this.exprType;
                dims[n2] = this.arrayDim;
                cnames[n2] = this.className;
                ++n2;
            }
            args = args.tail();
        }
    }

    void compileInvokeSpecial(ASTree target, int methodIndex, String descriptor, ASTList args) throws CompileError {
        target.accept(this);
        int n2 = this.getMethodArgsLength(args);
        this.atMethodArgs(args, new int[n2], new int[n2], new String[n2]);
        this.bytecode.addInvokespecial(methodIndex, descriptor);
        this.setReturnType(descriptor, false, false);
        this.addNullIfVoid();
    }

    @Override
    protected void atReturnStmnt(Stmnt st) throws CompileError {
        ASTree aSTree = st.getLeft();
        if (aSTree != null && this.returnType == CtClass.voidType) {
            this.compileExpr(aSTree);
            if (JvstCodeGen.is2word(this.exprType, this.arrayDim)) {
                this.bytecode.addOpcode(88);
            } else if (this.exprType != 344) {
                this.bytecode.addOpcode(87);
            }
            aSTree = null;
        }
        this.atReturnStmnt2(aSTree);
    }

    public int recordReturnType(CtClass type, String castName, String resultName, SymbolTable tbl) throws CompileError {
        this.returnType = type;
        this.returnCastName = castName;
        this.returnVarName = resultName;
        if (resultName == null) {
            return -1;
        }
        int n2 = this.getMaxLocals();
        int n3 = n2 + this.recordVar(type, resultName, n2, tbl);
        this.setMaxLocals(n3);
        return n2;
    }

    public void recordType(CtClass t2) {
        this.dollarType = t2;
    }

    public int recordParams(CtClass[] params, boolean isStatic, String prefix, String paramVarName, String paramsName, SymbolTable tbl) throws CompileError {
        return this.recordParams(params, isStatic, prefix, paramVarName, paramsName, !isStatic, 0, this.getThisName(), tbl);
    }

    public int recordParams(CtClass[] params, boolean isStatic, String prefix, String paramVarName, String paramsName, boolean use0, int paramBase, String target, SymbolTable tbl) throws CompileError {
        this.paramTypeList = params;
        this.paramArrayName = paramVarName;
        this.paramListName = paramsName;
        this.paramVarBase = paramBase;
        this.useParam0 = use0;
        if (target != null) {
            this.param0Type = MemberResolver.jvmToJavaName(target);
        }
        this.inStaticMethod = isStatic;
        int n2 = paramBase;
        if (use0) {
            String string = prefix + "0";
            ++n2;
            Declarator declarator = new Declarator(307, MemberResolver.javaToJvmName(target), 0, paramBase, new Symbol(string));
            tbl.append(string, declarator);
        }
        for (int i2 = 0; i2 < params.length; ++i2) {
            n2 += this.recordVar(params[i2], prefix + (i2 + 1), n2, tbl);
        }
        if (this.getMaxLocals() < n2) {
            this.setMaxLocals(n2);
        }
        return n2;
    }

    public int recordVariable(CtClass type, String varName, SymbolTable tbl) throws CompileError {
        if (varName == null) {
            return -1;
        }
        int n2 = this.getMaxLocals();
        int n3 = n2 + this.recordVar(type, varName, n2, tbl);
        this.setMaxLocals(n3);
        return n2;
    }

    private int recordVar(CtClass cc, String varName, int varNo, SymbolTable tbl) throws CompileError {
        if (cc == CtClass.voidType) {
            this.exprType = 307;
            this.arrayDim = 0;
            this.className = "java/lang/Object";
        } else {
            this.setType(cc);
        }
        Declarator declarator = new Declarator(this.exprType, this.className, this.arrayDim, varNo, new Symbol(varName));
        tbl.append(varName, declarator);
        if (JvstCodeGen.is2word(this.exprType, this.arrayDim)) {
            return 2;
        }
        return 1;
    }

    public void recordVariable(String typeDesc, String varName, int varNo, SymbolTable tbl) throws CompileError {
        char c2;
        int n2 = 0;
        while ((c2 = typeDesc.charAt(n2)) == '[') {
            ++n2;
        }
        int n3 = MemberResolver.descToType(c2);
        String string = null;
        if (n3 == 307) {
            string = n2 == 0 ? typeDesc.substring(1, typeDesc.length() - 1) : typeDesc.substring(n2 + 1, typeDesc.length() - 1);
        }
        Declarator declarator = new Declarator(n3, string, n2, varNo, new Symbol(varName));
        tbl.append(varName, declarator);
    }

    public static int compileParameterList(Bytecode code, CtClass[] params, int regno) {
        if (params == null) {
            code.addIconst(0);
            code.addAnewarray("java.lang.Object");
            return 1;
        }
        CtClass[] ctClassArray = new CtClass[1];
        int n2 = params.length;
        code.addIconst(n2);
        code.addAnewarray("java.lang.Object");
        for (int i2 = 0; i2 < n2; ++i2) {
            code.addOpcode(89);
            code.addIconst(i2);
            if (params[i2].isPrimitive()) {
                CtPrimitiveType ctPrimitiveType = (CtPrimitiveType)params[i2];
                String string = ctPrimitiveType.getWrapperName();
                code.addNew(string);
                code.addOpcode(89);
                int n3 = code.addLoad(regno, ctPrimitiveType);
                regno += n3;
                ctClassArray[0] = ctPrimitiveType;
                code.addInvokespecial(string, "<init>", Descriptor.ofMethod(CtClass.voidType, ctClassArray));
            } else {
                code.addAload(regno);
                ++regno;
            }
            code.addOpcode(83);
        }
        return 8;
    }

    protected void compileUnwrapValue(CtClass type, Bytecode code) throws CompileError {
        if (type == CtClass.voidType) {
            this.addNullIfVoid();
            return;
        }
        if (this.exprType == 344) {
            throw new CompileError("invalid type for " + this.returnCastName);
        }
        if (type instanceof CtPrimitiveType) {
            CtPrimitiveType ctPrimitiveType = (CtPrimitiveType)type;
            String string = ctPrimitiveType.getWrapperName();
            code.addCheckcast(string);
            code.addInvokevirtual(string, ctPrimitiveType.getGetMethodName(), ctPrimitiveType.getGetMethodDescriptor());
            this.setType(type);
            return;
        }
        code.addCheckcast(type);
        this.setType(type);
    }

    public void setType(CtClass type) throws CompileError {
        this.setType(type, 0);
    }

    private void setType(CtClass type, int dim) throws CompileError {
        if (type.isPrimitive()) {
            CtPrimitiveType ctPrimitiveType = (CtPrimitiveType)type;
            this.exprType = MemberResolver.descToType(ctPrimitiveType.getDescriptor());
            this.arrayDim = dim;
            this.className = null;
            return;
        }
        if (type.isArray()) {
            try {
                this.setType(type.getComponentType(), dim + 1);
                return;
            }
            catch (NotFoundException notFoundException) {
                throw new CompileError("undefined type: " + type.getName());
            }
        }
        this.exprType = 307;
        this.arrayDim = dim;
        this.className = MemberResolver.javaToJvmName(type.getName());
    }

    public void doNumCast(CtClass type) throws CompileError {
        if (this.arrayDim == 0 && !JvstCodeGen.isRefType(this.exprType)) {
            if (type instanceof CtPrimitiveType) {
                CtPrimitiveType ctPrimitiveType = (CtPrimitiveType)type;
                JvstCodeGen jvstCodeGen = this;
                jvstCodeGen.atNumCastExpr(jvstCodeGen.exprType, MemberResolver.descToType(ctPrimitiveType.getDescriptor()));
                return;
            }
            throw new CompileError("type mismatch");
        }
    }
}

