/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.compiler;

import ai.h2o.javassist.compiler.KeywordTable;
import ai.h2o.javassist.compiler.Token;
import ai.h2o.javassist.compiler.TokenId;

public class Lex
implements TokenId {
    private int lastChar = -1;
    private StringBuffer textBuffer = new StringBuffer();
    private Token currentToken = new Token();
    private Token lookAheadTokens = null;
    private String input;
    private int position;
    private int maxlen;
    private int lineNumber;
    private static final int[] equalOps = new int[]{350, 0, 0, 0, 351, 352, 0, 0, 0, 353, 354, 0, 355, 0, 356, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 357, 358, 359, 0};
    private static final KeywordTable ktable = new KeywordTable();

    public Lex(String s2) {
        this.input = s2;
        this.position = 0;
        this.maxlen = s2.length();
        this.lineNumber = 0;
    }

    public int get() {
        Token token;
        if (this.lookAheadTokens == null) {
            Lex lex = this;
            return lex.get(lex.currentToken);
        }
        this.currentToken = token = this.lookAheadTokens;
        this.lookAheadTokens = this.lookAheadTokens.next;
        return token.tokenId;
    }

    public int lookAhead() {
        return this.lookAhead(0);
    }

    public int lookAhead(int i2) {
        Token token = this.lookAheadTokens;
        if (token == null) {
            this.lookAheadTokens = token = this.currentToken;
            token.next = null;
            this.get(token);
        }
        while (i2-- > 0) {
            if (token.next == null) {
                Token token2;
                token.next = token2 = new Token();
                this.get(token2);
            }
            token = token.next;
        }
        this.currentToken = token;
        return token.tokenId;
    }

    public String getString() {
        return this.currentToken.textValue;
    }

    public long getLong() {
        return this.currentToken.longValue;
    }

    public double getDouble() {
        return this.currentToken.doubleValue;
    }

    private int get(Token token) {
        int n2;
        while ((n2 = this.readLine(token)) == 10) {
        }
        token.tokenId = n2;
        return n2;
    }

    private int readLine(Token token) {
        int n2 = this.getNextNonWhiteChar();
        if (n2 < 0) {
            return n2;
        }
        if (n2 == 10) {
            ++this.lineNumber;
            return 10;
        }
        if (n2 == 39) {
            return this.readCharConst(token);
        }
        if (n2 == 34) {
            return this.readStringL(token);
        }
        if (48 <= n2 && n2 <= 57) {
            return this.readNumber(n2, token);
        }
        if (n2 == 46) {
            n2 = this.getc();
            if (48 <= n2 && n2 <= 57) {
                StringBuffer stringBuffer = this.textBuffer;
                stringBuffer.setLength(0);
                stringBuffer.append('.');
                return this.readDouble(stringBuffer, n2, token);
            }
            this.ungetc(n2);
            return this.readSeparator(46);
        }
        if (Character.isJavaIdentifierStart((char)n2)) {
            return this.readIdentifier(n2, token);
        }
        return this.readSeparator(n2);
    }

    private int getNextNonWhiteChar() {
        int n2;
        block0: do {
            if ((n2 = this.getc()) != 47) continue;
            n2 = this.getc();
            if (n2 == 47) {
                while ((n2 = this.getc()) != 10 && n2 != 13 && n2 != -1) {
                }
                continue;
            }
            if (n2 == 42) {
                while ((n2 = this.getc()) != -1) {
                    if (n2 != 42) continue;
                    n2 = this.getc();
                    if (n2 == 47) {
                        n2 = 32;
                        continue block0;
                    }
                    this.ungetc(n2);
                }
            } else {
                this.ungetc(n2);
                n2 = 47;
            }
        } while (Lex.isBlank(n2));
        return n2;
    }

    private int readCharConst(Token token) {
        int n2;
        int n3 = 0;
        while ((n2 = this.getc()) != 39) {
            if (n2 == 92) {
                n3 = this.readEscapeChar();
                continue;
            }
            if (n2 < 32) {
                if (n2 == 10) {
                    ++this.lineNumber;
                }
                return 500;
            }
            n3 = n2;
        }
        token.longValue = n3;
        return 401;
    }

    private int readEscapeChar() {
        int n2 = this.getc();
        if (n2 == 110) {
            n2 = 10;
        } else if (n2 == 116) {
            n2 = 9;
        } else if (n2 == 114) {
            n2 = 13;
        } else if (n2 == 102) {
            n2 = 12;
        } else if (n2 == 10) {
            ++this.lineNumber;
        }
        return n2;
    }

    private int readStringL(Token token) {
        int n2;
        StringBuffer stringBuffer = this.textBuffer;
        stringBuffer.setLength(0);
        while (true) {
            if ((n2 = this.getc()) != 34) {
                if (n2 == 92) {
                    n2 = this.readEscapeChar();
                } else if (n2 == 10 || n2 < 0) {
                    ++this.lineNumber;
                    return 500;
                }
                stringBuffer.append((char)n2);
                continue;
            }
            while (true) {
                if ((n2 = this.getc()) == 10) {
                    ++this.lineNumber;
                    continue;
                }
                if (!Lex.isBlank(n2)) break;
            }
            if (n2 != 34) break;
        }
        this.ungetc(n2);
        token.textValue = stringBuffer.toString();
        return 406;
    }

    private int readNumber(int c2, Token token) {
        long l2 = 0L;
        int n2 = this.getc();
        if (c2 == 48) {
            if (n2 == 88 || n2 == 120) {
                while (true) {
                    if (48 <= (c2 = this.getc()) && c2 <= 57) {
                        l2 = (l2 << 4) + (long)(c2 - 48);
                        continue;
                    }
                    if (65 <= c2 && c2 <= 70) {
                        l2 = (l2 << 4) + (long)(c2 - 65 + 10);
                        continue;
                    }
                    if (97 > c2 || c2 > 102) break;
                    l2 = (l2 << 4) + (long)(c2 - 97 + 10);
                }
                token.longValue = l2;
                if (c2 == 76 || c2 == 108) {
                    return 403;
                }
                this.ungetc(c2);
                return 402;
            }
            if (48 <= n2 && n2 <= 55) {
                l2 = n2 - 48;
                while (48 <= (c2 = this.getc()) && c2 <= 55) {
                    l2 = (l2 << 3) + (long)(c2 - 48);
                }
                token.longValue = l2;
                if (c2 == 76 || c2 == 108) {
                    return 403;
                }
                this.ungetc(c2);
                return 402;
            }
        }
        l2 = c2 - 48;
        while (48 <= n2 && n2 <= 57) {
            l2 = l2 * 10L + (long)n2 - 48L;
            n2 = this.getc();
        }
        token.longValue = l2;
        if (n2 == 70 || n2 == 102) {
            token.doubleValue = l2;
            return 404;
        }
        if (n2 == 69 || n2 == 101 || n2 == 68 || n2 == 100 || n2 == 46) {
            StringBuffer stringBuffer = this.textBuffer;
            stringBuffer.setLength(0);
            stringBuffer.append(l2);
            return this.readDouble(stringBuffer, n2, token);
        }
        if (n2 == 76 || n2 == 108) {
            return 403;
        }
        this.ungetc(n2);
        return 402;
    }

    private int readDouble(StringBuffer sbuf, int c2, Token token) {
        if (c2 != 69 && c2 != 101 && c2 != 68 && c2 != 100) {
            sbuf.append((char)c2);
            while (48 <= (c2 = this.getc()) && c2 <= 57) {
                sbuf.append((char)c2);
            }
        }
        if (c2 == 69 || c2 == 101) {
            sbuf.append((char)c2);
            c2 = this.getc();
            if (c2 == 43 || c2 == 45) {
                sbuf.append((char)c2);
                c2 = this.getc();
            }
            while (48 <= c2 && c2 <= 57) {
                sbuf.append((char)c2);
                c2 = this.getc();
            }
        }
        try {
            token.doubleValue = Double.parseDouble(sbuf.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return 500;
        }
        if (c2 == 70 || c2 == 102) {
            return 404;
        }
        if (c2 != 68 && c2 != 100) {
            this.ungetc(c2);
        }
        return 405;
    }

    private int readSeparator(int c2) {
        int n2;
        if (33 <= c2 && c2 <= 63) {
            int n3 = equalOps[c2 - 33];
            if (n3 == 0) {
                return c2;
            }
            n2 = this.getc();
            if (c2 == n2) {
                switch (c2) {
                    case 61: {
                        return 358;
                    }
                    case 43: {
                        return 362;
                    }
                    case 45: {
                        return 363;
                    }
                    case 38: {
                        return 369;
                    }
                    case 60: {
                        int n4 = this.getc();
                        if (n4 == 61) {
                            return 365;
                        }
                        this.ungetc(n4);
                        return 364;
                    }
                    case 62: {
                        int n5 = this.getc();
                        if (n5 == 61) {
                            return 367;
                        }
                        if (n5 == 62) {
                            n5 = this.getc();
                            if (n5 == 61) {
                                return 371;
                            }
                            this.ungetc(n5);
                            return 370;
                        }
                        this.ungetc(n5);
                        return 366;
                    }
                }
            } else if (n2 == 61) {
                return n3;
            }
        } else if (c2 == 94) {
            n2 = this.getc();
            if (n2 == 61) {
                return 360;
            }
        } else if (c2 == 124) {
            n2 = this.getc();
            if (n2 == 61) {
                return 361;
            }
            if (n2 == 124) {
                return 368;
            }
        } else {
            return c2;
        }
        this.ungetc(n2);
        return c2;
    }

    private int readIdentifier(int c2, Token token) {
        StringBuffer stringBuffer = this.textBuffer;
        stringBuffer.setLength(0);
        do {
            stringBuffer.append((char)c2);
        } while (Character.isJavaIdentifierPart((char)(c2 = this.getc())));
        this.ungetc(c2);
        String string = stringBuffer.toString();
        int n2 = ktable.lookup(string);
        if (n2 >= 0) {
            return n2;
        }
        token.textValue = string;
        return 400;
    }

    private static boolean isBlank(int c2) {
        return c2 == 32 || c2 == 9 || c2 == 12 || c2 == 13 || c2 == 10;
    }

    private static boolean isDigit(int c2) {
        return 48 <= c2 && c2 <= 57;
    }

    private void ungetc(int c2) {
        this.lastChar = c2;
    }

    public String getTextAround() {
        int n2;
        int n3 = this.position - 10;
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = this.position + 10) > this.maxlen) {
            n2 = this.maxlen;
        }
        return this.input.substring(n3, n2);
    }

    private int getc() {
        if (this.lastChar < 0) {
            if (this.position < this.maxlen) {
                return this.input.charAt(this.position++);
            }
            return -1;
        }
        int n2 = this.lastChar;
        this.lastChar = -1;
        return n2;
    }

    static {
        ktable.append("abstract", 300);
        ktable.append("boolean", 301);
        ktable.append("break", 302);
        ktable.append("byte", 303);
        ktable.append("case", 304);
        ktable.append("catch", 305);
        ktable.append("char", 306);
        ktable.append("class", 307);
        ktable.append("const", 308);
        ktable.append("continue", 309);
        ktable.append("default", 310);
        ktable.append("do", 311);
        ktable.append("double", 312);
        ktable.append("else", 313);
        ktable.append("extends", 314);
        ktable.append("false", 411);
        ktable.append("final", 315);
        ktable.append("finally", 316);
        ktable.append("float", 317);
        ktable.append("for", 318);
        ktable.append("goto", 319);
        ktable.append("if", 320);
        ktable.append("implements", 321);
        ktable.append("import", 322);
        ktable.append("instanceof", 323);
        ktable.append("int", 324);
        ktable.append("interface", 325);
        ktable.append("long", 326);
        ktable.append("native", 327);
        ktable.append("new", 328);
        ktable.append("null", 412);
        ktable.append("package", 329);
        ktable.append("private", 330);
        ktable.append("protected", 331);
        ktable.append("public", 332);
        ktable.append("return", 333);
        ktable.append("short", 334);
        ktable.append("static", 335);
        ktable.append("strictfp", 347);
        ktable.append("super", 336);
        ktable.append("switch", 337);
        ktable.append("synchronized", 338);
        ktable.append("this", 339);
        ktable.append("throw", 340);
        ktable.append("throws", 341);
        ktable.append("transient", 342);
        ktable.append("true", 410);
        ktable.append("try", 343);
        ktable.append("void", 344);
        ktable.append("volatile", 345);
        ktable.append("while", 346);
    }
}

