/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.runtime;

public class Desc {
    public static boolean useContextClassLoader = false;
    private static final ThreadLocal<Boolean> USE_CONTEXT_CLASS_LOADER_LOCALLY = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public static void setUseContextClassLoaderLocally() {
        USE_CONTEXT_CLASS_LOADER_LOCALLY.set(Boolean.TRUE);
    }

    public static void resetUseContextClassLoaderLocally() {
        USE_CONTEXT_CLASS_LOADER_LOCALLY.remove();
    }

    private static Class<?> getClassObject(String name) throws ClassNotFoundException {
        if (useContextClassLoader || USE_CONTEXT_CLASS_LOADER_LOCALLY.get().booleanValue()) {
            return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        }
        return Class.forName(name);
    }

    public static Class<?> getClazz(String name) {
        try {
            return Desc.getClassObject(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("$class: internal error, could not find class '" + name + "' (Desc.useContextClassLoader: " + Boolean.toString(useContextClassLoader) + ")", classNotFoundException);
        }
    }

    public static Class<?>[] getParams(String desc) {
        if (desc.charAt(0) != '(') {
            throw new RuntimeException("$sig: internal error");
        }
        String string = desc;
        return Desc.getType(string, string.length(), 1, 0);
    }

    public static Class<?> getType(String desc) {
        String string = desc;
        Class<?>[] classArray = Desc.getType(string, string.length(), 0, 0);
        if (classArray == null || classArray.length != 1) {
            throw new RuntimeException("$type: internal error");
        }
        return classArray[0];
    }

    private static Class<?>[] getType(String desc, int descLen, int start, int num) {
        Class<Object> clazz;
        if (start >= descLen) {
            return new Class[num];
        }
        char c2 = desc.charAt(start);
        switch (c2) {
            case 'Z': {
                clazz = Boolean.TYPE;
                break;
            }
            case 'C': {
                clazz = Character.TYPE;
                break;
            }
            case 'B': {
                clazz = Byte.TYPE;
                break;
            }
            case 'S': {
                clazz = Short.TYPE;
                break;
            }
            case 'I': {
                clazz = Integer.TYPE;
                break;
            }
            case 'J': {
                clazz = Long.TYPE;
                break;
            }
            case 'F': {
                clazz = Float.TYPE;
                break;
            }
            case 'D': {
                clazz = Double.TYPE;
                break;
            }
            case 'V': {
                clazz = Void.TYPE;
                break;
            }
            case 'L': 
            case '[': {
                return Desc.getClassType(desc, descLen, start, num);
            }
            default: {
                return new Class[num];
            }
        }
        Class<?>[] classArray = Desc.getType(desc, descLen, start + 1, num + 1);
        Class<?>[] classArray2 = classArray;
        classArray[num] = clazz;
        return classArray2;
    }

    private static Class<?>[] getClassType(String desc, int descLen, int start, int num) {
        int n2 = start;
        while (desc.charAt(n2) == '[') {
            ++n2;
        }
        if (desc.charAt(n2) == 'L' && (n2 = desc.indexOf(59, n2)) < 0) {
            throw new IndexOutOfBoundsException("bad descriptor");
        }
        String string = desc.charAt(start) == 'L' ? desc.substring(start + 1, n2) : desc.substring(start, n2 + 1);
        Class<?>[] classArray = Desc.getType(desc, descLen, n2 + 1, num + 1);
        try {
            classArray[num] = Desc.getClassObject(string.replace('/', '.'));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException.getMessage());
        }
        return classArray;
    }
}

