/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.tools.reflect;

import ai.h2o.javassist.tools.reflect.CannotCreateException;
import ai.h2o.javassist.tools.reflect.CannotInvokeException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class ClassMetaobject
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String methodPrefix = "_m_";
    static final int methodPrefixLen = 3;
    private Class<?> javaClass;
    private Constructor<?>[] constructors;
    private Method[] methods;
    public static boolean useContextClassLoader = false;

    public ClassMetaobject(String[] params) {
        try {
            this.javaClass = this.getClassObject(params[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("not found: " + params[0] + ", useContextClassLoader: " + Boolean.toString(useContextClassLoader), classNotFoundException);
        }
        this.constructors = this.javaClass.getConstructors();
        this.methods = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.javaClass.getName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.javaClass = this.getClassObject(in.readUTF());
        this.constructors = this.javaClass.getConstructors();
        this.methods = null;
    }

    private Class<?> getClassObject(String name) throws ClassNotFoundException {
        if (useContextClassLoader) {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        return Class.forName(name);
    }

    public final Class<?> getJavaClass() {
        return this.javaClass;
    }

    public final String getName() {
        return this.javaClass.getName();
    }

    public final boolean isInstance(Object obj) {
        return this.javaClass.isInstance(obj);
    }

    public final Object newInstance(Object[] args) throws CannotCreateException {
        int n2 = this.constructors.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                return this.constructors[i2].newInstance(args);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                throw new CannotCreateException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new CannotCreateException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new CannotCreateException(invocationTargetException);
            }
        }
        throw new CannotCreateException("no constructor matches");
    }

    public Object trapFieldRead(String name) {
        Class<?> clazz = this.getJavaClass();
        try {
            return clazz.getField(name).get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.toString());
        }
    }

    public void trapFieldWrite(String name, Object value) {
        Class<?> clazz = this.getJavaClass();
        try {
            clazz.getField(name).set(null, value);
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.toString());
        }
    }

    public static Object invoke(Object target, int identifier, Object[] args) throws Throwable {
        Method[] methodArray = target.getClass().getMethods();
        int n2 = methodArray.length;
        String string = methodPrefix + identifier;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!methodArray[i2].getName().startsWith(string)) continue;
            try {
                return methodArray[i2].invoke(target, args);
            }
            catch (InvocationTargetException invocationTargetException) {
                InvocationTargetException invocationTargetException2 = invocationTargetException;
                throw invocationTargetException.getTargetException();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new CannotInvokeException(illegalAccessException);
            }
        }
        throw new CannotInvokeException("cannot find a method");
    }

    public Object trapMethodcall(int identifier, Object[] args) throws Throwable {
        try {
            Method[] methodArray = this.getReflectiveMethods();
            return methodArray[identifier].invoke(null, args);
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            throw invocationTargetException.getTargetException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CannotInvokeException(illegalAccessException);
        }
    }

    public final Method[] getReflectiveMethods() {
        int n2;
        if (this.methods != null) {
            return this.methods;
        }
        Class<?> clazz = this.getJavaClass();
        Method[] methodArray = clazz.getDeclaredMethods();
        int n3 = methodArray.length;
        int[] nArray = new int[n3];
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            char c2;
            Method method = methodArray[n2];
            String string = method.getName();
            if (!string.startsWith(methodPrefix)) continue;
            int n5 = 0;
            int n6 = 3;
            while ('0' <= (c2 = string.charAt(n6)) && c2 <= '9') {
                n5 = n5 * 10 + c2 - 48;
                ++n6;
            }
            nArray[n2] = ++n5;
            if (n5 <= n4) continue;
            n4 = n5;
        }
        this.methods = new Method[n4];
        for (n2 = 0; n2 < n3; ++n2) {
            if (nArray[n2] <= 0) continue;
            this.methods[nArray[n2] - 1] = methodArray[n2];
        }
        return this.methods;
    }

    public final Method getMethod(int identifier) {
        return this.getReflectiveMethods()[identifier];
    }

    public final String getMethodName(int identifier) {
        char c2;
        String string = this.getReflectiveMethods()[identifier].getName();
        int n2 = 3;
        while ((c2 = string.charAt(n2++)) >= '0' && '9' >= c2) {
        }
        return string.substring(n2);
    }

    public final Class<?>[] getParameterTypes(int identifier) {
        return this.getReflectiveMethods()[identifier].getParameterTypes();
    }

    public final Class<?> getReturnType(int identifier) {
        return this.getReflectiveMethods()[identifier].getReturnType();
    }

    public final int getMethodIndex(String originalName, Class<?>[] argTypes) throws NoSuchMethodException {
        Method[] methodArray = this.getReflectiveMethods();
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            if (methodArray[i2] == null || !this.getMethodName(i2).equals(originalName) || !Arrays.equals(argTypes, methodArray[i2].getParameterTypes())) continue;
            return i2;
        }
        throw new NoSuchMethodException("Method " + originalName + " not found");
    }
}

