/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.tools.reflect;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CodeConverter;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtField;
import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.CtNewMethod;
import ai.h2o.javassist.Modifier;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.Translator;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.ClassFile;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.tools.reflect.CannotReflectException;

public class Reflection
implements Translator {
    static final String classobjectField = "_classobject";
    static final String classobjectAccessor = "_getClass";
    static final String metaobjectField = "_metaobject";
    static final String metaobjectGetter = "_getMetaobject";
    static final String metaobjectSetter = "_setMetaobject";
    static final String readPrefix = "_r_";
    static final String writePrefix = "_w_";
    static final String metaobjectClassName = "ai.h2o.javassist.tools.reflect.Metaobject";
    static final String classMetaobjectClassName = "ai.h2o.javassist.tools.reflect.ClassMetaobject";
    protected CtMethod trapMethod;
    protected CtMethod trapStaticMethod;
    protected CtMethod trapRead;
    protected CtMethod trapWrite;
    protected CtClass[] readParam;
    protected ClassPool classPool = null;
    protected CodeConverter converter = new CodeConverter();

    private boolean isExcluded(String name) {
        return name.startsWith("_m_") || name.equals(classobjectAccessor) || name.equals(metaobjectSetter) || name.equals(metaobjectGetter) || name.startsWith(readPrefix) || name.startsWith(writePrefix);
    }

    @Override
    public void start(ClassPool pool) throws NotFoundException {
        this.classPool = pool;
        try {
            CtClass ctClass = this.classPool.get("ai.h2o.javassist.tools.reflect.Sample");
            this.rebuildClassFile(ctClass.getClassFile());
            this.trapMethod = ctClass.getDeclaredMethod("trap");
            this.trapStaticMethod = ctClass.getDeclaredMethod("trapStatic");
            this.trapRead = ctClass.getDeclaredMethod("trapRead");
            this.trapWrite = ctClass.getDeclaredMethod("trapWrite");
            this.readParam = new CtClass[]{this.classPool.get("java.lang.Object")};
            return;
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException("ai.h2o.javassist.tools.reflect.Sample is not found or broken.");
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException("ai.h2o.javassist.tools.reflect.Sample is not found or broken.");
        }
    }

    @Override
    public void onLoad(ClassPool pool, String classname) throws CannotCompileException, NotFoundException {
        CtClass ctClass = pool.get(classname);
        ctClass.instrument(this.converter);
    }

    public boolean makeReflective(String classname, String metaobject, String metaclass) throws CannotCompileException, NotFoundException {
        Reflection reflection = this;
        return reflection.makeReflective(reflection.classPool.get(classname), this.classPool.get(metaobject), this.classPool.get(metaclass));
    }

    public boolean makeReflective(Class<?> clazz, Class<?> metaobject, Class<?> metaclass) throws CannotCompileException, NotFoundException {
        return this.makeReflective(clazz.getName(), metaobject.getName(), metaclass.getName());
    }

    public boolean makeReflective(CtClass clazz, CtClass metaobject, CtClass metaclass) throws CannotCompileException, CannotReflectException, NotFoundException {
        if (clazz.isInterface()) {
            throw new CannotReflectException("Cannot reflect an interface: " + clazz.getName());
        }
        if (clazz.subclassOf(this.classPool.get(classMetaobjectClassName))) {
            throw new CannotReflectException("Cannot reflect a subclass of ClassMetaobject: " + clazz.getName());
        }
        if (clazz.subclassOf(this.classPool.get(metaobjectClassName))) {
            throw new CannotReflectException("Cannot reflect a subclass of Metaobject: " + clazz.getName());
        }
        this.registerReflectiveClass(clazz);
        return this.modifyClassfile(clazz, metaobject, metaclass);
    }

    private void registerReflectiveClass(CtClass clazz) {
        CtField[] ctFieldArray = clazz.getDeclaredFields();
        for (int i2 = 0; i2 < ctFieldArray.length; ++i2) {
            CtField ctField = ctFieldArray[i2];
            int n2 = ctField.getModifiers();
            if ((n2 & 1) == 0 || (n2 & 0x10) != 0) continue;
            String string = ctField.getName();
            this.converter.replaceFieldRead(ctField, clazz, readPrefix + string);
            this.converter.replaceFieldWrite(ctField, clazz, writePrefix + string);
        }
    }

    private boolean modifyClassfile(CtClass clazz, CtClass metaobject, CtClass metaclass) throws CannotCompileException, NotFoundException {
        CtField ctField;
        if (clazz.getAttribute("Reflective") != null) {
            return false;
        }
        clazz.setAttribute("Reflective", new byte[0]);
        CtClass ctClass = this.classPool.get("ai.h2o.javassist.tools.reflect.Metalevel");
        boolean bl = !clazz.subtypeOf(ctClass);
        if (bl) {
            clazz.addInterface(ctClass);
        }
        this.processMethods(clazz, bl);
        this.processFields(clazz);
        if (bl) {
            ctField = new CtField(this.classPool.get(metaobjectClassName), metaobjectField, clazz);
            ctField.setModifiers(4);
            clazz.addField(ctField, CtField.Initializer.byNewWithParams(metaobject));
            clazz.addMethod(CtNewMethod.getter(metaobjectGetter, ctField));
            clazz.addMethod(CtNewMethod.setter(metaobjectSetter, ctField));
        }
        ctField = new CtField(this.classPool.get(classMetaobjectClassName), classobjectField, clazz);
        ctField.setModifiers(10);
        clazz.addField(ctField, CtField.Initializer.byNew(metaclass, new String[]{clazz.getName()}));
        clazz.addMethod(CtNewMethod.getter(classobjectAccessor, ctField));
        return true;
    }

    private void processMethods(CtClass clazz, boolean dontSearch) throws CannotCompileException, NotFoundException {
        CtMethod[] ctMethodArray = clazz.getMethods();
        for (int i2 = 0; i2 < ctMethodArray.length; ++i2) {
            CtMethod ctMethod = ctMethodArray[i2];
            int n2 = ctMethod.getModifiers();
            if (!Modifier.isPublic(n2) || Modifier.isAbstract(n2)) continue;
            this.processMethods0(n2, clazz, ctMethod, i2, dontSearch);
        }
    }

    private void processMethods0(int mod, CtClass clazz, CtMethod m2, int identifier, boolean dontSearch) throws CannotCompileException, NotFoundException {
        CtMethod ctMethod;
        String string = m2.getName();
        if (this.isExcluded(string)) {
            return;
        }
        if (m2.getDeclaringClass() == clazz) {
            if (Modifier.isNative(mod)) {
                return;
            }
            ctMethod = m2;
            if (Modifier.isFinal(mod)) {
                ctMethod.setModifiers(mod &= 0xFFFFFFEF);
            }
        } else {
            if (Modifier.isFinal(mod)) {
                return;
            }
            ctMethod = CtNewMethod.delegator(this.findOriginal(m2, dontSearch), clazz);
            ctMethod.setModifiers(mod &= 0xFFFFFEFF);
            clazz.addMethod(ctMethod);
        }
        ctMethod.setName("_m_" + identifier + "_" + string);
        CtMethod ctMethod2 = Modifier.isStatic(mod) ? this.trapStaticMethod : this.trapMethod;
        CtMethod ctMethod3 = CtNewMethod.wrapped(m2.getReturnType(), string, m2.getParameterTypes(), m2.getExceptionTypes(), ctMethod2, CtMethod.ConstParameter.integer(identifier), clazz);
        ctMethod3.setModifiers(mod);
        clazz.addMethod(ctMethod3);
    }

    private CtMethod findOriginal(CtMethod m2, boolean dontSearch) throws NotFoundException {
        if (dontSearch) {
            return m2;
        }
        String string = m2.getName();
        CtMethod[] ctMethodArray = m2.getDeclaringClass().getDeclaredMethods();
        for (int i2 = 0; i2 < ctMethodArray.length; ++i2) {
            String string2 = ctMethodArray[i2].getName();
            if (!string2.endsWith(string) || !string2.startsWith("_m_") || !ctMethodArray[i2].getSignature().equals(m2.getSignature())) continue;
            return ctMethodArray[i2];
        }
        return m2;
    }

    private void processFields(CtClass clazz) throws CannotCompileException, NotFoundException {
        CtField[] ctFieldArray = clazz.getDeclaredFields();
        for (int i2 = 0; i2 < ctFieldArray.length; ++i2) {
            CtField ctField = ctFieldArray[i2];
            int n2 = ctField.getModifiers();
            if ((n2 & 1) == 0 || (n2 & 0x10) != 0) continue;
            String string = ctField.getName();
            CtClass ctClass = ctField.getType();
            CtMethod ctMethod = CtNewMethod.wrapped(ctClass, readPrefix + string, this.readParam, null, this.trapRead, CtMethod.ConstParameter.string(string), clazz);
            ctMethod.setModifiers(n2 |= 8);
            clazz.addMethod(ctMethod);
            CtClass[] ctClassArray = new CtClass[2];
            CtClass[] ctClassArray2 = ctClassArray;
            ctClassArray[0] = this.classPool.get("java.lang.Object");
            ctClassArray2[1] = ctClass;
            ctMethod = CtNewMethod.wrapped(CtClass.voidType, writePrefix + string, ctClassArray2, null, this.trapWrite, CtMethod.ConstParameter.string(string), clazz);
            ctMethod.setModifiers(n2);
            clazz.addMethod(ctMethod);
        }
    }

    public void rebuildClassFile(ClassFile cf) throws BadBytecode {
        if (ClassFile.MAJOR_VERSION < 50) {
            return;
        }
        for (MethodInfo methodInfo : cf.getMethods()) {
            methodInfo.rebuildStackMap(this.classPool);
        }
    }
}

