/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.tools.rmi;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.tools.rmi.ExportedObject;
import ai.h2o.javassist.tools.rmi.RemoteRef;
import ai.h2o.javassist.tools.rmi.StubGenerator;
import ai.h2o.javassist.tools.web.BadHttpRequest;
import ai.h2o.javassist.tools.web.Webserver;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class AppletServer
extends Webserver {
    private StubGenerator stubGen;
    private Map<String, ExportedObject> exportedNames = new Hashtable<String, ExportedObject>();
    private List<ExportedObject> exportedObjects = new Vector<ExportedObject>();
    private static final byte[] okHeader = "HTTP/1.0 200 OK\r\n\r\n".getBytes();

    public AppletServer(String port) throws IOException, NotFoundException, CannotCompileException {
        this(Integer.parseInt(port));
    }

    public AppletServer(int port) throws IOException, NotFoundException, CannotCompileException {
        this(ClassPool.getDefault(), new StubGenerator(), port);
    }

    public AppletServer(int port, ClassPool src) throws IOException, NotFoundException, CannotCompileException {
        this(new ClassPool(src), new StubGenerator(), port);
    }

    private AppletServer(ClassPool loader, StubGenerator gen, int port) throws IOException, NotFoundException, CannotCompileException {
        super(port);
        this.stubGen = gen;
        this.addTranslator(loader, gen);
    }

    @Override
    public void run() {
        super.run();
    }

    public synchronized int exportObject(String name, Object obj) throws CannotCompileException {
        Class<?> clazz = obj.getClass();
        ExportedObject exportedObject = new ExportedObject();
        new ExportedObject().object = obj;
        exportedObject.methods = clazz.getMethods();
        this.exportedObjects.add(exportedObject);
        exportedObject.identifier = this.exportedObjects.size() - 1;
        if (name != null) {
            this.exportedNames.put(name, exportedObject);
        }
        try {
            this.stubGen.makeProxyClass(clazz);
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        return exportedObject.identifier;
    }

    @Override
    public void doReply(InputStream in, OutputStream out, String cmd) throws IOException, BadHttpRequest {
        if (cmd.startsWith("POST /rmi ")) {
            this.processRMI(in, out);
            return;
        }
        if (cmd.startsWith("POST /lookup ")) {
            this.lookupName(cmd, in, out);
            return;
        }
        super.doReply(in, out, cmd);
    }

    private void processRMI(InputStream ins, OutputStream outs) throws IOException {
        Object object;
        ObjectInputStream objectInputStream = new ObjectInputStream(ins);
        int n2 = objectInputStream.readInt();
        int n3 = objectInputStream.readInt();
        Exception exception = null;
        Object object2 = null;
        try {
            object = this.exportedObjects.get(n2);
            Object[] objectArray = this.readParameters(objectInputStream);
            object2 = this.convertRvalue(((ExportedObject)object).methods[n3].invoke(((ExportedObject)object).object, objectArray));
        }
        catch (Exception exception2) {
            object = exception2;
            exception = exception2;
            this.logging2(((Throwable)object).toString());
        }
        outs.write(okHeader);
        object = new ObjectOutputStream(outs);
        if (exception != null) {
            ((ObjectOutputStream)object).writeBoolean(false);
            ((ObjectOutputStream)object).writeUTF(exception.toString());
        } else {
            try {
                ((ObjectOutputStream)object).writeBoolean(true);
                ((ObjectOutputStream)object).writeObject(object2);
            }
            catch (NotSerializableException notSerializableException) {
                this.logging2(notSerializableException.toString());
            }
            catch (InvalidClassException invalidClassException) {
                this.logging2(invalidClassException.toString());
            }
        }
        ((ObjectOutputStream)object).flush();
        ((ObjectOutputStream)object).close();
        objectInputStream.close();
    }

    private Object[] readParameters(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int n2 = in.readInt();
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = in.readObject();
            if (object instanceof RemoteRef) {
                RemoteRef remoteRef = (RemoteRef)object;
                ExportedObject exportedObject = this.exportedObjects.get(remoteRef.oid);
                object = exportedObject.object;
            }
            objectArray[i2] = object;
        }
        return objectArray;
    }

    private Object convertRvalue(Object rvalue) throws CannotCompileException {
        if (rvalue == null) {
            return null;
        }
        String string = rvalue.getClass().getName();
        if (this.stubGen.isProxyClass(string)) {
            return new RemoteRef(this.exportObject(null, rvalue), string);
        }
        return rvalue;
    }

    private void lookupName(String cmd, InputStream ins, OutputStream outs) throws IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(ins);
        String string = DataInputStream.readUTF(objectInputStream);
        ExportedObject exportedObject = this.exportedNames.get(string);
        outs.write(okHeader);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outs);
        if (exportedObject == null) {
            this.logging2(string + "not found.");
            objectOutputStream.writeInt(-1);
            objectOutputStream.writeUTF("error");
        } else {
            this.logging2(string);
            objectOutputStream.writeInt(exportedObject.identifier);
            objectOutputStream.writeUTF(exportedObject.object.getClass().getName());
        }
        objectOutputStream.flush();
        objectOutputStream.close();
        objectInputStream.close();
    }
}

