/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.tools.rmi;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtConstructor;
import ai.h2o.javassist.CtField;
import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.CtNewConstructor;
import ai.h2o.javassist.CtNewMethod;
import ai.h2o.javassist.Modifier;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.Translator;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;

public class StubGenerator
implements Translator {
    private static final String fieldImporter = "importer";
    private static final String fieldObjectId = "objectId";
    private static final String accessorObjectId = "_getObjectId";
    private static final String sampleClass = "ai.h2o.javassist.tools.rmi.Sample";
    private ClassPool classPool;
    private Map<String, CtClass> proxyClasses = new Hashtable<String, CtClass>();
    private CtMethod forwardMethod;
    private CtMethod forwardStaticMethod;
    private CtClass[] proxyConstructorParamTypes;
    private CtClass[] interfacesForProxy;
    private CtClass[] exceptionForProxy;

    @Override
    public void start(ClassPool pool) throws NotFoundException {
        this.classPool = pool;
        CtClass ctClass = pool.get(sampleClass);
        this.forwardMethod = ctClass.getDeclaredMethod("forward");
        this.forwardStaticMethod = ctClass.getDeclaredMethod("forwardStatic");
        this.proxyConstructorParamTypes = pool.get(new String[]{"ai.h2o.javassist.tools.rmi.ObjectImporter", "int"});
        this.interfacesForProxy = pool.get(new String[]{"java.io.Serializable", "ai.h2o.javassist.tools.rmi.Proxy"});
        this.exceptionForProxy = new CtClass[]{pool.get("ai.h2o.javassist.tools.rmi.RemoteException")};
    }

    @Override
    public void onLoad(ClassPool pool, String classname) {
    }

    public boolean isProxyClass(String name) {
        return this.proxyClasses.get(name) != null;
    }

    public synchronized boolean makeProxyClass(Class<?> clazz) throws CannotCompileException, NotFoundException {
        String string = clazz.getName();
        if (this.proxyClasses.get(string) != null) {
            return false;
        }
        StubGenerator stubGenerator = this;
        CtClass ctClass = stubGenerator.produceProxyClass(stubGenerator.classPool.get(string), clazz);
        this.proxyClasses.put(string, ctClass);
        this.modifySuperclass(ctClass);
        return true;
    }

    private CtClass produceProxyClass(CtClass orgclass, Class<?> orgRtClass) throws CannotCompileException, NotFoundException {
        int n2 = orgclass.getModifiers();
        if (Modifier.isAbstract(n2) || Modifier.isNative(n2) || !Modifier.isPublic(n2)) {
            throw new CannotCompileException(orgclass.getName() + " must be public, non-native, and non-abstract.");
        }
        CtClass ctClass = this.classPool.makeClass(orgclass.getName(), orgclass.getSuperclass());
        ctClass.setInterfaces(this.interfacesForProxy);
        CtField ctField = new CtField(this.classPool.get("ai.h2o.javassist.tools.rmi.ObjectImporter"), fieldImporter, ctClass);
        ctField.setModifiers(2);
        ctClass.addField(ctField, CtField.Initializer.byParameter(0));
        ctField = new CtField(CtClass.intType, fieldObjectId, ctClass);
        ctField.setModifiers(2);
        ctClass.addField(ctField, CtField.Initializer.byParameter(1));
        ctClass.addMethod(CtNewMethod.getter(accessorObjectId, ctField));
        CtClass ctClass2 = ctClass;
        ctClass2.addConstructor(CtNewConstructor.defaultConstructor(ctClass2));
        CtConstructor ctConstructor = CtNewConstructor.skeleton(this.proxyConstructorParamTypes, null, ctClass);
        ctClass.addConstructor(ctConstructor);
        try {
            this.addMethods(ctClass, orgRtClass.getMethods());
            return ctClass;
        }
        catch (SecurityException securityException) {
            throw new CannotCompileException(securityException);
        }
    }

    private CtClass toCtClass(Class<?> rtclass) throws NotFoundException {
        String string;
        if (!rtclass.isArray()) {
            string = rtclass.getName();
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            do {
                stringBuffer.append("[]");
            } while ((rtclass = rtclass.getComponentType()).isArray());
            stringBuffer.insert(0, rtclass.getName());
            string = stringBuffer.toString();
        }
        return this.classPool.get(string);
    }

    private CtClass[] toCtClass(Class<?>[] rtclasses) throws NotFoundException {
        int n2 = rtclasses.length;
        CtClass[] ctClassArray = new CtClass[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ctClassArray[i2] = this.toCtClass(rtclasses[i2]);
        }
        return ctClassArray;
    }

    private void addMethods(CtClass proxy, Method[] ms) throws CannotCompileException, NotFoundException {
        for (int i2 = 0; i2 < ms.length; ++i2) {
            Method method = ms[i2];
            int n2 = method.getModifiers();
            if (method.getDeclaringClass() == Object.class || Modifier.isFinal(n2)) continue;
            if (Modifier.isPublic(n2)) {
                CtMethod ctMethod = Modifier.isStatic(n2) ? this.forwardStaticMethod : this.forwardMethod;
                CtMethod ctMethod2 = CtNewMethod.wrapped(this.toCtClass(method.getReturnType()), method.getName(), this.toCtClass(method.getParameterTypes()), this.exceptionForProxy, ctMethod, CtMethod.ConstParameter.integer(i2), proxy);
                ctMethod2.setModifiers(n2);
                proxy.addMethod(ctMethod2);
                continue;
            }
            if (Modifier.isProtected(n2) || Modifier.isPrivate(n2)) continue;
            throw new CannotCompileException("the methods must be public, protected, or private.");
        }
    }

    private void modifySuperclass(CtClass orgclass) throws CannotCompileException, NotFoundException {
        CtClass ctClass;
        while ((ctClass = orgclass.getSuperclass()) != null) {
            try {
                ctClass.getDeclaredConstructor(null);
                return;
            }
            catch (NotFoundException notFoundException) {
                CtClass ctClass2 = ctClass;
                ctClass2.addConstructor(CtNewConstructor.defaultConstructor(ctClass2));
                orgclass = ctClass;
            }
        }
    }
}

