/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.tools.web;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.Translator;
import ai.h2o.javassist.tools.web.BadHttpRequest;
import ai.h2o.javassist.tools.web.ServiceThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;

public class Webserver {
    private ServerSocket socket;
    private ClassPool classPool;
    protected Translator translator;
    private static final byte[] endofline = new byte[]{13, 10};
    private static final int typeHtml = 1;
    private static final int typeClass = 2;
    private static final int typeGif = 3;
    private static final int typeJpeg = 4;
    private static final int typeText = 5;
    public String debugDir = null;
    public String htmlfileBase = null;

    public static void main(String[] args) throws IOException {
        if (args.length == 1) {
            Webserver webserver = new Webserver(args[0]);
            webserver.run();
            return;
        }
        System.err.println("Usage: java javassist.tools.web.Webserver <port number>");
    }

    public Webserver(String port) throws IOException {
        this(Integer.parseInt(port));
    }

    public Webserver(int port) throws IOException {
        this.socket = new ServerSocket(port);
        this.classPool = null;
        this.translator = null;
    }

    public void setClassPool(ClassPool loader) {
        this.classPool = loader;
    }

    public void addTranslator(ClassPool cp, Translator t2) throws NotFoundException, CannotCompileException {
        this.classPool = cp;
        this.translator = t2;
        t2.start(this.classPool);
    }

    public void end() throws IOException {
        this.socket.close();
    }

    public void logging(String msg) {
        System.out.println(msg);
    }

    public void logging(String msg1, String msg2) {
        System.out.print(msg1);
        System.out.print(" ");
        System.out.println(msg2);
    }

    public void logging(String msg1, String msg2, String msg3) {
        System.out.print(msg1);
        System.out.print(" ");
        System.out.print(msg2);
        System.out.print(" ");
        System.out.println(msg3);
    }

    public void logging2(String msg) {
        System.out.print("    ");
        System.out.println(msg);
    }

    public void run() {
        System.err.println("ready to service...");
        while (true) {
            try {
                while (true) {
                    Webserver webserver = this;
                    ServiceThread serviceThread = new ServiceThread(webserver, webserver.socket.accept());
                    serviceThread.start();
                }
            }
            catch (IOException iOException) {
                this.logging(iOException.toString());
                continue;
            }
            break;
        }
    }

    final void process(Socket clnt) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(clnt.getInputStream());
        String string = this.readLine(bufferedInputStream);
        this.logging(clnt.getInetAddress().getHostName(), new Date().toString(), string);
        while (this.skipLine(bufferedInputStream) > 0) {
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(clnt.getOutputStream());
        try {
            this.doReply(bufferedInputStream, bufferedOutputStream, string);
        }
        catch (BadHttpRequest badHttpRequest) {
            this.replyError(bufferedOutputStream, badHttpRequest);
        }
        ((OutputStream)bufferedOutputStream).flush();
        ((InputStream)bufferedInputStream).close();
        ((OutputStream)bufferedOutputStream).close();
        clnt.close();
    }

    private String readLine(InputStream in) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = in.read()) >= 0 && n2 != 13) {
            stringBuffer.append((char)n2);
        }
        in.read();
        return stringBuffer.toString();
    }

    private int skipLine(InputStream in) throws IOException {
        int n2;
        int n3 = 0;
        while ((n2 = in.read()) >= 0 && n2 != 13) {
            ++n3;
        }
        in.read();
        return n3;
    }

    public void doReply(InputStream in, OutputStream out, String cmd) throws IOException, BadHttpRequest {
        InputStream inputStream;
        File file;
        String string;
        if (!cmd.startsWith("GET /")) {
            throw new BadHttpRequest();
        }
        String string2 = string = cmd.substring(5, cmd.indexOf(32, 5));
        int n2 = string2.endsWith(".class") ? 2 : (string2.endsWith(".html") || string2.endsWith(".htm") ? 1 : (string2.endsWith(".gif") ? 3 : (string2.endsWith(".jpg") ? 4 : 5)));
        int n3 = string2.length();
        if (n2 == 2 && this.letUsersSendClassfile(out, string2, n3)) {
            return;
        }
        this.checkFilename(string2, n3);
        if (this.htmlfileBase != null) {
            string2 = this.htmlfileBase + string2;
        }
        if (File.separatorChar != '/') {
            string2 = string2.replace('/', File.separatorChar);
        }
        if ((file = new File(string2)).canRead()) {
            this.sendHeader(out, file.length(), n2);
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[4096];
            while ((n3 = fileInputStream.read(byArray)) > 0) {
                out.write(byArray, 0, n3);
            }
            fileInputStream.close();
            return;
        }
        if (n2 == 2 && (inputStream = this.getClass().getResourceAsStream("/" + string)) != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[4096];
            while ((n3 = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n3);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            this.sendHeader(out, byArray2.length, 2);
            out.write(byArray2);
            inputStream.close();
            return;
        }
        throw new BadHttpRequest();
    }

    private void checkFilename(String filename, int len) throws BadHttpRequest {
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = filename.charAt(i2);
            if (Character.isJavaIdentifierPart(c2) || c2 == '.' || c2 == '/') continue;
            throw new BadHttpRequest();
        }
        if (filename.indexOf("..") >= 0) {
            throw new BadHttpRequest();
        }
    }

    private boolean letUsersSendClassfile(OutputStream out, String filename, int length) throws IOException, BadHttpRequest {
        byte[] byArray;
        if (this.classPool == null) {
            return false;
        }
        String string = filename.substring(0, length - 6).replace('/', '.');
        try {
            if (this.translator != null) {
                this.translator.onLoad(this.classPool, string);
            }
            CtClass ctClass = this.classPool.get(string);
            byArray = ctClass.toBytecode();
            if (this.debugDir != null) {
                ctClass.writeFile(this.debugDir);
            }
        }
        catch (Exception exception) {
            throw new BadHttpRequest(exception);
        }
        this.sendHeader(out, byArray.length, 2);
        out.write(byArray);
        return true;
    }

    private void sendHeader(OutputStream out, long dataLength, int filetype) throws IOException {
        out.write("HTTP/1.0 200 OK".getBytes());
        out.write(endofline);
        out.write("Content-Length: ".getBytes());
        out.write(Long.toString(dataLength).getBytes());
        out.write(endofline);
        if (filetype == 2) {
            out.write("Content-Type: application/octet-stream".getBytes());
        } else if (filetype == 1) {
            out.write("Content-Type: text/html".getBytes());
        } else if (filetype == 3) {
            out.write("Content-Type: image/gif".getBytes());
        } else if (filetype == 4) {
            out.write("Content-Type: image/jpg".getBytes());
        } else if (filetype == 5) {
            out.write("Content-Type: text/plain".getBytes());
        }
        out.write(endofline);
        out.write(endofline);
    }

    private void replyError(OutputStream out, BadHttpRequest e2) throws IOException {
        this.logging2("bad request: " + e2.toString());
        out.write("HTTP/1.0 400 Bad Request".getBytes());
        out.write(endofline);
        out.write(endofline);
        out.write("<H1>Bad Request</H1>".getBytes());
    }
}

