/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos;

import ai.h2o.mojos.runtime.BuildInfo;
import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.RowPipelineListener;
import ai.h2o.mojos.runtime.api.MojoPipelineService;
import ai.h2o.mojos.runtime.lic.LicenseException;
import ai.h2o.mojos.runtime.utils.BatchedCsvMojoProcessor;
import ai.h2o.mojos.runtime.utils.Consts;
import ai.h2o.mojos.runtime.utils.CsvProcessingConfig;
import ai.h2o.mojos.runtime.utils.CsvWritingBatchHandler;
import ai.h2o.mojos.runtime.utils.StopWatch;
import ai.h2o.mojos.runtime.utils.StopWatchSeconds;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="executeMojo", mixinStandardHelpOptions=true, sortOptions=false, description={"Score a given dataset using a given MOJO2 pipeline."}, versionProvider=BuildInfo.class, footer={"", "Examples:", "  java -cp mojo2-runtime.jar ai.h2o.mojos.ExecuteMojo pipeline.mojo example.csv", "    * Transforms data from the file example.csv using MOJO stored in the file pipeline.mojo", "", "  cat example.csv | java -cp mojo2-runtime.jar ai.h2o.mojos.ExecuteMojo pipeline.mojo -", "    * Transforms data from the pipe using MOJO stored in the file pipeline.mojo", ""})
public class ExecuteMojo
implements Callable<Integer> {
    private static final String STDIN_FILENAME = "-";
    private static final String STDOUT_FILENAME = "-";
    @CommandLine.Option(names={"--track"}, description={"Track transformations on first row"})
    boolean track = false;
    @CommandLine.Option(names={"-s"}, description={"Set logger to level ERROR (default is WARN)"})
    boolean loglevelError = false;
    @CommandLine.Option(names={"-v"}, description={"Set logger to level INFO (default is WARN)"})
    boolean loglevelInfo = false;
    @CommandLine.Option(names={"-vv"}, description={"Set logger to level DEBUG (default is WARN)"})
    boolean loglevelDebug = false;
    @CommandLine.Option(names={"-vvv"}, description={"Set logger to level TRACE (default is WARN)"})
    boolean loglevelTrace = false;
    @CommandLine.Option(names={"--show-predictions"}, negatable=true, description={"Show model predictions (default: ${DEFAULT-VALUE})."})
    boolean showPredictions = true;
    @CommandLine.Option(names={"--show-contributions"}, negatable=true, description={"Show model contributions (default: ${DEFAULT-VALUE})."})
    boolean showContributionsTransformed = false;
    @CommandLine.Option(names={"--show-contributions-original"}, negatable=true, description={"Show model contributions (default: ${DEFAULT-VALUE}) transformed to original input features."})
    boolean showContributionsOriginal = false;
    @CommandLine.Parameters(index="0", description={"MOJO2 pipeline file."})
    String mojoFilename;
    @CommandLine.Parameters(index="1", description={"Dataset file to score in CSV format or '-' for read from standard input."})
    String inputCsvFilename;
    @CommandLine.Parameters(index="2", defaultValue="-", description={"Output file name or stdout by default."})
    String outputCsvFilename;

    public static void main(String ... args) {
        System.exit(new CommandLine(new ExecuteMojo()).execute(args));
    }

    @Override
    public Integer call() throws Exception {
        String string = "warn";
        if (this.loglevelTrace) {
            string = "trace";
        } else if (this.loglevelDebug) {
            string = "debug";
        } else if (this.loglevelInfo) {
            string = "info";
        } else if (this.loglevelError) {
            string = "error";
        }
        System.err.println("setting log level to " + string);
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", string);
        try {
            Object object;
            boolean bl = Consts.getSysProp("execute.mojo.watchUnitSeconds", false);
            StopWatch stopWatch = bl ? StopWatchSeconds.start() : StopWatch.start();
            MojoPipeline mojoPipeline = MojoPipelineService.loadPipeline(new File(this.mojoFilename));
            if (this.track) {
                mojoPipeline.setListener(new RowPipelineListener(0));
            }
            if (this.showContributionsOriginal && this.showContributionsTransformed) {
                throw new IllegalArgumentException("Cannot show both transformed and original contributions.");
            }
            if (this.showContributionsTransformed) {
                mojoPipeline.setShapPredictContrib(true);
            } else if (this.showContributionsOriginal) {
                mojoPipeline.setShapPredictContribOriginal(true);
            }
            long l2 = stopWatch.lap();
            OutputStreamWriter outputStreamWriter = this.outputCsvFilename.equals("-") ? new OutputStreamWriter(System.out) : new FileWriter(this.outputCsvFilename);
            CsvProcessingConfig csvProcessingConfig = new CsvProcessingConfig();
            csvProcessingConfig.setHeadersIgnoreCase(Consts.getSysProp("parser.csv.headers.ignorecase", false));
            csvProcessingConfig.setHeadersMissing(Consts.getSysProp("parser.csv.headers.missing", false));
            String string2 = Consts.getSysProp("parser.csv.headers.map", null);
            if (string2 != null) {
                for (String object22 : string2.split(",")) {
                    int n2 = object22.indexOf(61);
                    if (n2 < 0) {
                        throw new IllegalArgumentException("Invalid header mapping (missing '='): " + object22);
                    }
                    object = object22.substring(0, n2).trim();
                    String string3 = object22.substring(n2 + 1).trim();
                    csvProcessingConfig.map((String)object, string3);
                }
            }
            BatchedCsvMojoProcessor batchedCsvMojoProcessor = new BatchedCsvMojoProcessor(mojoPipeline, csvProcessingConfig);
            InputStreamReader inputStreamReader = this.inputCsvFilename.equals("-") ? new InputStreamReader(System.in) : new FileReader(this.inputCsvFilename);
            Throwable throwable = null;
            try {
                CsvWritingBatchHandler csvWritingBatchHandler;
                block37: {
                    csvWritingBatchHandler = new CsvWritingBatchHandler(outputStreamWriter);
                    Throwable throwable2 = null;
                    try {
                        object = Consts.getSysProp("exposedInputs", null);
                        if (object != null) {
                            if (((String)object).equals("ALL")) {
                                csvWritingBatchHandler.setExposeAllInputs(true);
                            } else {
                                csvWritingBatchHandler.setExposedInputs(((String)object).split(","));
                            }
                        }
                        long l3 = batchedCsvMojoProcessor.processCsv((Reader)inputStreamReader, csvWritingBatchHandler);
                        long l4 = stopWatch.lap();
                        if (!bl) {
                            System.err.println("Mojo load time: " + stopWatch.toString(l2) + ", Mojo scoring/output time: " + stopWatch.toString(l4) + ", Per row time: " + stopWatch.toString(l4, l3) + ", Number of rows: " + l3 + ", Total time: " + stopWatch.toString(l2 + l4));
                            break block37;
                        }
                        System.err.println("@" + l3 + "," + stopWatch.toString(l2) + "," + stopWatch.toString(l4) + "," + stopWatch.toString(l4, l3) + "," + stopWatch.toString(l2 + l4));
                    }
                    catch (Throwable throwable3) {
                        try {
                            object = throwable3;
                            throwable2 = throwable3;
                            throw object;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 != null) {
                                try {
                                    csvWritingBatchHandler.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                            } else {
                                csvWritingBatchHandler.close();
                            }
                            throw throwable4;
                        }
                    }
                }
                csvWritingBatchHandler.close();
            }
            catch (Throwable throwable6) {
                try {
                    Throwable throwable7 = throwable6;
                    throwable = throwable6;
                    throw throwable7;
                }
                catch (Throwable throwable8) {
                    if (throwable != null) {
                        try {
                            ((Reader)inputStreamReader).close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        ((Reader)inputStreamReader).close();
                    }
                    throw throwable8;
                }
            }
            ((Reader)inputStreamReader).close();
        }
        catch (LicenseException licenseException) {
            System.err.println(licenseException.getMessage());
            return -1;
        }
        return 0;
    }
}

