/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.api.backend;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.api.backend.ReaderBackendUtils;
import ai.h2o.mojos.runtime.api.backend.ResourceInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryReaderBackend
implements ReaderBackend {
    private static final Logger log = LoggerFactory.getLogger(MemoryReaderBackend.class);
    private final Map<String, byte[]> files;
    private final ResourceInfo.Cache cache = new ResourceInfo.Cache();

    private MemoryReaderBackend(Map<String, byte[]> files) {
        this.files = files;
    }

    public static ReaderBackend open(Map<String, byte[]> files) {
        return new MemoryReaderBackend(files);
    }

    public static ReaderBackend fromZipStream(InputStream is) throws IOException {
        log.info("Opening mojo stream: {}", (Object)is);
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        ZipInputStream zipInputStream = new ZipInputStream(is);
        Throwable throwable = null;
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.getSize() > Integer.MAX_VALUE) {
                    throw new IOException("File is too large: " + zipEntry.getName());
                }
                if (!zipEntry.isDirectory()) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ReaderBackendUtils.copy(zipInputStream, byteArrayOutputStream, 8192);
                    hashMap.put(zipEntry.getName(), byteArrayOutputStream.toByteArray());
                }
                zipInputStream.closeEntry();
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (throwable != null) {
                    try {
                        zipInputStream.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    zipInputStream.close();
                }
                throw throwable4;
            }
        }
        zipInputStream.close();
        return MemoryReaderBackend.open(hashMap);
    }

    public void put(String resourceName, byte[] bytes) {
        this.files.put(resourceName, bytes);
    }

    @Override
    public ResourceInfo getResourceInfo(String resourceName) throws IOException {
        ResourceInfo resourceInfo = (ResourceInfo)this.cache.get(resourceName);
        if (resourceInfo == null) {
            byte[] byArray = this.files.get(resourceName);
            if (byArray == null) {
                throw new FileNotFoundException(resourceName);
            }
            try {
                String string = ResourceInfo.computeMD5(byArray);
                resourceInfo = new ResourceInfo(byArray.length, "MD5:" + string);
                this.cache.put(resourceName, resourceInfo);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IOException(noSuchAlgorithmException);
            }
        }
        return resourceInfo;
    }

    @Override
    public InputStream getInputStream(String resourceName) throws FileNotFoundException {
        byte[] byArray = this.files.get(resourceName);
        if (byArray == null) {
            throw new FileNotFoundException(resourceName);
        }
        return new ByteArrayInputStream(byArray);
    }

    @Override
    public boolean exists(String resourceName) {
        return this.files.containsKey(resourceName);
    }

    @Override
    public Collection<String> list() {
        return this.files.keySet();
    }

    @Override
    public void close() {
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.files.size());
    }
}

