/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import java.lang.reflect.Method;

public class Base64Utils {
    private static final Base64Iface DELEGATE;

    private Base64Utils() {
    }

    public static byte[] encode(byte[] src) {
        return DELEGATE.encode(src);
    }

    public static byte[] decode(byte[] src) {
        return DELEGATE.decode(src);
    }

    public static byte[] encodeUrl(byte[] src) {
        return DELEGATE.encodeUrl(src);
    }

    public static byte[] decodeUrl(byte[] src) {
        return DELEGATE.decodeUrl(src);
    }

    public static byte[] decodeUrl(String src) {
        if (!Base64Utils.isEmpty(src)) {
            return DELEGATE.decodeUrl(src.getBytes());
        }
        return null;
    }

    static Class<?> tryLoadFirst(String klazzName, ClassLoader ... classLoaders) {
        ClassLoader[] classLoaderArray = classLoaders;
        int n2 = classLoaders.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ClassLoader classLoader = classLoaderArray[i2];
            try {
                return classLoader.loadClass(klazzName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        return null;
    }

    static boolean allNotNull(Object ... objs) {
        Object[] objectArray = objs;
        int n2 = objs.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            if (object != null) continue;
            return false;
        }
        return true;
    }

    static Object scall(Class<?> klazz, String name) {
        try {
            Method method = klazz.getMethod(name, new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isEmpty(String s2) {
        return s2 == null || s2.isEmpty();
    }

    static {
        Class<?> clazz = Base64Utils.tryLoadFirst("java.util.Base64", Base64Utils.class.getClassLoader());
        Base64Iface base64Iface = null;
        if (clazz != null) {
            base64Iface = Base64Java8.create(clazz);
        } else {
            Class<?> clazz2 = Base64Utils.tryLoadFirst("javax.xml.bind.DatatypeConverter", Base64Utils.class.getClassLoader());
            if (clazz2 != null) {
                base64Iface = Base64Java7.create(clazz2);
            }
        }
        if (base64Iface == null) {
            throw new LinkageError("Cannot find suitable implementation for Base64 utilities!");
        }
        DELEGATE = base64Iface;
    }

    private static class Base64Java7
    implements Base64Iface {
        private final Method encoder;
        private final Method decoder;

        private Base64Java7(Method encoder, Method decoder) {
            this.encoder = encoder;
            this.decoder = decoder;
        }

        @Override
        public byte[] encode(byte[] src) {
            try {
                return ((String)this.encoder.invoke(null, new Object[]{src})).getBytes();
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public byte[] decode(byte[] src) {
            return this.decode(new String(src));
        }

        @Override
        public byte[] encodeUrl(byte[] src) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public byte[] decodeUrl(byte[] src) {
            return this.decodeUrl(new String(src));
        }

        private byte[] decode(String in) {
            if (in != null) {
                try {
                    return (byte[])this.decoder.invoke(null, in);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return null;
        }

        private byte[] decodeUrl(String in) {
            if (in != null) {
                String string = in.replace('-', '+').replace('_', '/');
                return this.decode(string);
            }
            return null;
        }

        static Base64Java7 create(Class<?> datatypeConvertorKlazz) {
            Method method = Base64Java7.getMethod(datatypeConvertorKlazz, "printBase64Binary", byte[].class);
            Method method2 = Base64Java7.getMethod(datatypeConvertorKlazz, "parseBase64Binary", String.class);
            if (Base64Utils.allNotNull(method, method2)) {
                return new Base64Java7(method, method2);
            }
            return null;
        }

        static Method getMethod(Class<?> klazz, String methodName, Class<?> paramType) {
            try {
                return klazz.getMethod(methodName, paramType);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
    }

    private static class Base64Java8
    implements Base64Iface {
        private final Object encoder;
        private final Method encoderEncode;
        private final Object encoderUrl;
        private final Method encoderUrlEncode;
        private final Object decoder;
        private final Method decoderDecode;
        private final Object decoderUrl;
        private final Method decoderUrlDecode;

        private Base64Java8(Object encoder, Method encoderEncode, Object encoderUrl, Method encoderUrlEncode, Object decoder, Method decoderDecode, Object decoderUrl, Method decoderUrlDecode) {
            this.encoder = encoder;
            this.encoderEncode = encoderEncode;
            this.encoderUrl = encoderUrl;
            this.encoderUrlEncode = encoderUrlEncode;
            this.decoder = decoder;
            this.decoderDecode = decoderDecode;
            this.decoderUrl = decoderUrl;
            this.decoderUrlDecode = decoderUrlDecode;
        }

        @Override
        public byte[] encode(byte[] src) {
            Base64Java8 base64Java8 = this;
            return base64Java8.call(base64Java8.encoder, this.encoderEncode, src);
        }

        @Override
        public byte[] decode(byte[] src) {
            Base64Java8 base64Java8 = this;
            return base64Java8.call(base64Java8.decoder, this.decoderDecode, src);
        }

        @Override
        public byte[] encodeUrl(byte[] src) {
            Base64Java8 base64Java8 = this;
            return base64Java8.call(base64Java8.encoderUrl, this.encoderUrlEncode, src);
        }

        @Override
        public byte[] decodeUrl(byte[] src) {
            Base64Java8 base64Java8 = this;
            return base64Java8.call(base64Java8.decoderUrl, this.decoderUrlDecode, src);
        }

        private byte[] call(Object o2, Method m2, byte[] src) {
            try {
                return (byte[])m2.invoke(o2, new Object[]{src});
            }
            catch (Exception exception) {
                return null;
            }
        }

        static Base64Java8 create(Class<?> base64Class) {
            Object object = Base64Utils.scall(base64Class, "getEncoder");
            Method method = Base64Java8.getMethodBA(object, "encode");
            Object object2 = Base64Utils.scall(base64Class, "getUrlEncoder");
            Method method2 = Base64Java8.getMethodBA(object2, "encode");
            Object object3 = Base64Utils.scall(base64Class, "getDecoder");
            Method method3 = Base64Java8.getMethodBA(object3, "decode");
            Object object4 = Base64Utils.scall(base64Class, "getUrlDecoder");
            Method method4 = Base64Java8.getMethodBA(object4, "decode");
            if (Base64Utils.allNotNull(object, method, object2, method2, object3, method3, object4, method4)) {
                return new Base64Java8(object, method, object2, method2, object3, method3, object4, method4);
            }
            return null;
        }

        private static Method getMethodBA(Object o2, String name) {
            try {
                return o2.getClass().getMethod(name, byte[].class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
    }

    private static interface Base64Iface {
        public byte[] encode(byte[] var1);

        public byte[] decode(byte[] var1);

        public byte[] encodeUrl(byte[] var1);

        public byte[] decodeUrl(byte[] var1);
    }
}

