/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.ResultSetHelper;
import com.opencsv.ResultSetHelperService;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class CSVWriter
implements Closeable,
Flushable {
    public static final int INITIAL_STRING_SIZE = 1024;
    public static final char DEFAULT_ESCAPE_CHARACTER = '\"';
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char NO_QUOTE_CHARACTER = '\u0000';
    public static final char NO_ESCAPE_CHARACTER = '\u0000';
    public static final String DEFAULT_LINE_END = "\n";
    public static final String RFC4180_LINE_END = "\r\n";
    protected final Writer writer;
    protected final char separator;
    protected final char quotechar;
    protected final char escapechar;
    protected String lineEnd;
    protected ResultSetHelper resultService;
    protected volatile IOException exception;

    public CSVWriter(Writer writer) {
        this(writer, ',');
    }

    @Deprecated
    public CSVWriter(Writer writer, char separator) {
        this(writer, separator, '\"');
    }

    @Deprecated
    public CSVWriter(Writer writer, char separator, char quotechar) {
        this(writer, separator, quotechar, '\"');
    }

    @Deprecated
    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar) {
        this(writer, separator, quotechar, escapechar, DEFAULT_LINE_END);
    }

    @Deprecated
    public CSVWriter(Writer writer, char separator, char quotechar, String lineEnd) {
        this(writer, separator, quotechar, '\"', lineEnd);
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar, String lineEnd) {
        this.writer = writer;
        this.separator = separator;
        this.quotechar = quotechar;
        this.escapechar = escapechar;
        this.lineEnd = lineEnd;
    }

    public void writeAll(Iterable<String[]> allLines, boolean applyQuotesToAll) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        try {
            for (String[] stringArray : allLines) {
                this.writeNext(stringArray, applyQuotesToAll, stringBuilder);
                stringBuilder.setLength(0);
            }
            return;
        }
        catch (IOException iOException) {
            this.exception = iOException;
            return;
        }
    }

    public void writeAll(List<String[]> allLines, boolean applyQuotesToAll) {
        this.writeAll((Iterable<String[]>)allLines, applyQuotesToAll);
    }

    public void writeAll(Iterable<String[]> allLines) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        try {
            for (String[] stringArray : allLines) {
                this.writeNext(stringArray, true, stringBuilder);
                stringBuilder.setLength(0);
            }
            return;
        }
        catch (IOException iOException) {
            this.exception = iOException;
            return;
        }
    }

    public void writeAll(List<String[]> allLines) {
        this.writeAll((Iterable<String[]>)allLines);
    }

    protected void writeColumnNames(ResultSet rs, boolean applyQuotesToAll) throws SQLException {
        CSVWriter cSVWriter = this;
        cSVWriter.writeNext(cSVWriter.resultService().getColumnNames(rs), applyQuotesToAll);
    }

    public int writeAll(ResultSet rs, boolean includeColumnNames) throws SQLException, IOException {
        return this.writeAll(rs, includeColumnNames, false, true);
    }

    public int writeAll(ResultSet rs, boolean includeColumnNames, boolean trim) throws SQLException, IOException {
        return this.writeAll(rs, includeColumnNames, trim, true);
    }

    public int writeAll(ResultSet rs, boolean includeColumnNames, boolean trim, boolean applyQuotesToAll) throws SQLException, IOException {
        int n2 = 0;
        if (includeColumnNames) {
            this.writeColumnNames(rs, applyQuotesToAll);
            ++n2;
        }
        while (rs.next()) {
            CSVWriter cSVWriter = this;
            cSVWriter.writeNext(cSVWriter.resultService().getColumnValues(rs, trim), applyQuotesToAll);
            ++n2;
        }
        return n2;
    }

    public void writeNext(String[] nextLine, boolean applyQuotesToAll) {
        try {
            this.writeNext(nextLine, applyQuotesToAll, new StringBuilder(1024));
            return;
        }
        catch (IOException iOException) {
            this.exception = iOException;
            return;
        }
    }

    protected void writeNext(String[] nextLine, boolean applyQuotesToAll, Appendable appendable) throws IOException {
        if (nextLine == null) {
            return;
        }
        for (int i2 = 0; i2 < nextLine.length; ++i2) {
            String string;
            if (i2 != 0) {
                appendable.append(this.separator);
            }
            if ((string = nextLine[i2]) == null) continue;
            Boolean bl = this.stringContainsSpecialCharacters(string);
            this.appendQuoteCharacterIfNeeded(applyQuotesToAll, appendable, bl);
            if (bl.booleanValue()) {
                this.processLine(string, appendable);
            } else {
                appendable.append(string);
            }
            this.appendQuoteCharacterIfNeeded(applyQuotesToAll, appendable, bl);
        }
        appendable.append(this.lineEnd);
        this.writer.write(appendable.toString());
    }

    private void appendQuoteCharacterIfNeeded(boolean applyQuotesToAll, Appendable appendable, Boolean stringContainsSpecialCharacters) throws IOException {
        if ((applyQuotesToAll || stringContainsSpecialCharacters.booleanValue()) && this.quotechar != '\u0000') {
            appendable.append(this.quotechar);
        }
    }

    public void writeNext(String[] nextLine) {
        this.writeNext(nextLine, true);
    }

    protected boolean stringContainsSpecialCharacters(String line) {
        return line.indexOf(this.quotechar) != -1 || line.indexOf(this.escapechar) != -1 || line.indexOf(this.separator) != -1 || line.contains(DEFAULT_LINE_END) || line.contains("\r");
    }

    protected void processLine(String nextElement, Appendable appendable) throws IOException {
        for (int i2 = 0; i2 < nextElement.length(); ++i2) {
            char c2 = nextElement.charAt(i2);
            this.processCharacter(appendable, c2);
        }
    }

    protected void processCharacter(Appendable appendable, char nextChar) throws IOException {
        if (this.escapechar != '\u0000' && this.checkCharactersToEscape(nextChar)) {
            appendable.append(this.escapechar);
        }
        appendable.append(nextChar);
    }

    protected boolean checkCharactersToEscape(char nextChar) {
        if (this.quotechar == '\u0000') {
            return nextChar == this.quotechar || nextChar == this.escapechar || nextChar == this.separator || nextChar == '\n';
        }
        return nextChar == this.quotechar || nextChar == this.escapechar;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.writer.close();
    }

    public boolean checkError() {
        if (this.writer instanceof PrintWriter) {
            PrintWriter printWriter = (PrintWriter)this.writer;
            return printWriter.checkError();
        }
        this.flushQuietly();
        return this.exception != null;
    }

    public void setResultService(ResultSetHelper resultService) {
        this.resultService = resultService;
    }

    protected ResultSetHelper resultService() {
        if (this.resultService == null) {
            this.resultService = new ResultSetHelperService();
        }
        return this.resultService;
    }

    public void flushQuietly() {
        try {
            this.flush();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }
}

