/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.BeanField;
import com.opencsv.exceptions.CsvBeanIntrospectionException;
import com.opencsv.exceptions.CsvConstraintViolationException;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public abstract class AbstractBeanField<T>
implements BeanField<T> {
    protected Field field;
    private PropertyUtilsBean propUtils;
    protected boolean required;
    protected Locale errorLocale;

    public AbstractBeanField() {
        this.required = false;
        this.errorLocale = Locale.getDefault();
    }

    public AbstractBeanField(Field field) {
        this(field, false, Locale.getDefault());
    }

    public AbstractBeanField(Field field, boolean required) {
        this(field, required, Locale.getDefault());
    }

    public AbstractBeanField(Field field, boolean required, Locale errorLocale) {
        this.field = field;
        this.required = required;
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
    }

    @Override
    public void setField(Field field) {
        this.field = field;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public void setErrorLocale(Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
    }

    @Override
    public final <T> void setFieldValue(T bean, String value) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException {
        if (this.required && StringUtils.isBlank(value)) {
            throw new CsvRequiredFieldEmptyException(bean.getClass(), this.field, String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("required.field.empty"), this.field.getName()));
        }
        this.assignValueToField(bean, this.convert(value));
    }

    private <T> void assignValueToField(T bean, Object obj) throws CsvDataTypeMismatchException {
        if (obj != null) {
            Class<?> clazz = this.field.getType();
            String string = "set" + Character.toUpperCase(this.field.getName().charAt(0)) + this.field.getName().substring(1);
            try {
                Method method = bean.getClass().getMethod(string, clazz);
                try {
                    method.invoke(bean, obj);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    CsvDataTypeMismatchException csvDataTypeMismatchException = new CsvDataTypeMismatchException(obj, clazz, invocationTargetException.getLocalizedMessage());
                    csvDataTypeMismatchException.initCause(invocationTargetException);
                    throw csvDataTypeMismatchException;
                }
            }
            catch (NoSuchMethodException | SecurityException exception) {
                this.writeWithoutSetter(bean, obj);
            }
        }
    }

    private <T> void writeWithoutSetter(T bean, Object obj) throws CsvDataTypeMismatchException {
        try {
            FieldUtils.writeField(this.field, bean, obj, true);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            CsvDataTypeMismatchException csvDataTypeMismatchException = new CsvDataTypeMismatchException(obj, this.field.getType());
            csvDataTypeMismatchException.initCause(illegalArgumentException);
            throw csvDataTypeMismatchException;
        }
    }

    protected abstract Object convert(String var1) throws CsvDataTypeMismatchException, CsvConstraintViolationException;

    @Override
    public final String write(T bean) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        String string = null;
        if (bean != null && this.field != null) {
            Object object;
            if (this.propUtils == null) {
                this.propUtils = new PropertyUtilsBean();
            }
            try {
                object = this.propUtils.getSimpleProperty(bean, this.field.getName());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                CsvBeanIntrospectionException csvBeanIntrospectionException = new CsvBeanIntrospectionException(bean, this.field);
                csvBeanIntrospectionException.initCause(reflectiveOperationException);
                throw csvBeanIntrospectionException;
            }
            if (object == null && this.required) {
                throw new CsvRequiredFieldEmptyException(bean.getClass(), this.field, String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("required.field.empty"), this.field.getName()));
            }
            try {
                string = this.convertToWrite(object);
            }
            catch (CsvDataTypeMismatchException csvDataTypeMismatchException) {
                CsvDataTypeMismatchException csvDataTypeMismatchException2 = new CsvDataTypeMismatchException(bean, this.field.getType(), csvDataTypeMismatchException.getMessage());
                csvDataTypeMismatchException2.initCause(csvDataTypeMismatchException.getCause());
                throw csvDataTypeMismatchException2;
            }
        }
        return string;
    }

    protected String convertToWrite(Object value) throws CsvDataTypeMismatchException {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

