/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.AbstractCSVToBean;
import com.opencsv.bean.CsvToBeanFilter;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ObjectUtils;

@Deprecated
public class IterableCSVToBean<T>
extends AbstractCSVToBean
implements Iterable<T> {
    private final MappingStrategy<T> strategy;
    private final CSVReader csvReader;
    private final CsvToBeanFilter filter;
    private boolean hasHeader;
    private Locale errorLocale = Locale.getDefault();

    public IterableCSVToBean(CSVReader csvReader, MappingStrategy<T> strategy, CsvToBeanFilter filter) {
        this.csvReader = csvReader;
        this.strategy = strategy;
        this.filter = filter;
        this.hasHeader = false;
    }

    protected MappingStrategy<T> getStrategy() {
        return this.strategy;
    }

    protected CSVReader getCSVReader() {
        return this.csvReader;
    }

    protected CsvToBeanFilter getFilter() {
        return this.filter;
    }

    public T nextLine() throws IllegalAccessException, InstantiationException, IOException, IntrospectionException, InvocationTargetException, CsvRequiredFieldEmptyException {
        String[] stringArray;
        if (!this.hasHeader) {
            this.strategy.captureHeader(this.csvReader);
            this.hasHeader = true;
        }
        T t2 = null;
        while ((stringArray = this.csvReader.readNext()) != null && this.filter != null && !this.filter.allowLine(stringArray)) {
        }
        if (stringArray != null) {
            this.strategy.verifyLineLength(stringArray.length);
            t2 = this.strategy.createBean();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                PropertyDescriptor propertyDescriptor = this.strategy.findDescriptor(i2);
                if (propertyDescriptor == null) continue;
                String string = this.checkForTrim(stringArray[i2], propertyDescriptor);
                Object object = this.convertValue(string, propertyDescriptor);
                propertyDescriptor.getWriteMethod().invoke(t2, object);
            }
        }
        return t2;
    }

    @Override
    protected PropertyEditor getPropertyEditor(PropertyDescriptor desc) throws InstantiationException, IllegalAccessException {
        Class<?> clazz = desc.getPropertyEditorClass();
        if (clazz != null) {
            return (PropertyEditor)clazz.newInstance();
        }
        return this.getPropertyEditorValue(desc.getPropertyType());
    }

    public void setErrorLocale(Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
    }

    @Override
    public Iterator<T> iterator() {
        IterableCSVToBean iterableCSVToBean = this;
        return iterableCSVToBean.iterator(iterableCSVToBean);
    }

    private Iterator<T> iterator(final IterableCSVToBean<T> bean) {
        return new Iterator<T>(){
            private T nextBean;

            @Override
            public boolean hasNext() {
                if (this.nextBean != null) {
                    return true;
                }
                try {
                    this.nextBean = bean.nextLine();
                }
                catch (CsvRequiredFieldEmptyException | IntrospectionException | IOException | IllegalAccessException | InstantiationException | InvocationTargetException exception) {
                    Exception exception2 = exception;
                    exception.printStackTrace();
                }
                return this.nextBean != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object t2 = this.nextBean;
                this.nextBean = null;
                return t2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException(ResourceBundle.getBundle("opencsv", IterableCSVToBean.this.errorLocale).getString("read.only.iterator"));
            }
        };
    }
}

