/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.genmodel.easy.RowData;
import java.io.Serializable;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenMunger
implements Serializable {
    public Step[] _steps;

    public String[] inTypes() {
        return this._steps[0].types();
    }

    public String[] inNames() {
        return this._steps[0].names();
    }

    public String[] outNames() {
        return this._steps[this._steps.length - 1].outNames();
    }

    public RowData fit(RowData row) {
        if (row == null) {
            return null;
        }
        Step[] stepArray = this._steps;
        int n2 = this._steps.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Step step = stepArray[i2];
            row = step.transform(row);
        }
        return row;
    }

    public RowData fillDefault(String[] vals) {
        RowData rowData = new RowData();
        String[] stringArray = this.inTypes();
        String[] stringArray2 = this.inNames();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            rowData.put(stringArray2[i2], vals == null ? null : GenMunger.valueOf(stringArray[i2], vals[i2]));
        }
        return rowData;
    }

    private static Double parseNum(String n2) {
        if (n2 == null || n2.equals("") || n2.isEmpty()) {
            return Double.NaN;
        }
        return Double.valueOf(n2);
    }

    private static Object valueOf(String type, String val) {
        val = val.replaceAll("^\"|\"$", "");
        if (type.equals("Numeric")) {
            return GenMunger.parseNum(val);
        }
        return val;
    }

    public static void scaleInPlace(double[] means, double[] mults, double[] in) {
        for (int i2 = 0; i2 < in.length; ++i2) {
            in[i2] = (in[i2] - means[i2]) * mults[i2];
        }
    }

    public static double cos(double r2, HashMap<String, String[]> parameters) {
        return Math.cos(r2);
    }

    public static double sin(double r2, HashMap<String, String[]> parameters) {
        return Math.sin(r2);
    }

    public static double countmatches(String s2, HashMap<String, String[]> parameters) {
        String[] stringArray = parameters.get("pattern");
        return GenMunger.countMatches(s2, stringArray);
    }

    private static int countMatches(String s2, String[] pattern) {
        int n2 = 0;
        String[] stringArray = pattern;
        int n3 = pattern.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            String string = stringArray[i2];
            Pattern pattern2 = Pattern.compile(string);
            Matcher matcher = pattern2.matcher(s2);
            while (matcher.find()) {
                ++n2;
            }
        }
        return n2;
    }

    public static double add(double d2, HashMap<String, String[]> parameters) {
        String[] stringArray = parameters.get("leftArg");
        String[] stringArray2 = parameters.get("rightArg");
        if (stringArray == null) {
            return d2 + GenMunger.parseNum(stringArray2[0]);
        }
        return GenMunger.parseNum(stringArray[0]) + d2;
    }

    public static double minus(double d2, HashMap<String, String[]> parameters) {
        String[] stringArray = parameters.get("leftArg");
        String[] stringArray2 = parameters.get("rightArg");
        if (stringArray == null) {
            return d2 - GenMunger.parseNum(stringArray2[0]);
        }
        return GenMunger.parseNum(stringArray[0]) - d2;
    }

    public static double multiply(double d2, HashMap<String, String[]> parameters) {
        String[] stringArray = parameters.get("leftArg");
        String[] stringArray2 = parameters.get("rightArg");
        if (stringArray == null) {
            return d2 * GenMunger.parseNum(stringArray2[0]);
        }
        return GenMunger.parseNum(stringArray[0]) * d2;
    }

    public static double divide(double d2, HashMap<String, String[]> parameters) {
        String[] stringArray = parameters.get("leftArg");
        String[] stringArray2 = parameters.get("rightArg");
        if (stringArray == null) {
            return d2 / GenMunger.parseNum(stringArray2[0]);
        }
        return GenMunger.parseNum(stringArray[0]) / d2;
    }

    public static double mod(double d2, HashMap<String, String[]> parameters) {
        String string = parameters.get("leftArg")[0];
        String string2 = parameters.get("rightArg")[0];
        if (string == null) {
            return d2 % GenMunger.parseNum(string2);
        }
        return GenMunger.parseNum(string) % d2;
    }

    public static double pow(double d2, HashMap<String, String[]> parameters) {
        String string = parameters.get("leftArg")[0];
        String string2 = parameters.get("rightArg")[0];
        if (string == null) {
            return Math.pow(d2, GenMunger.parseNum(string2));
        }
        return Math.pow(GenMunger.parseNum(string), d2);
    }

    public static String[] strsplit(String s2, HashMap<String, String[]> parameters) {
        String string = parameters.get("split")[0];
        return s2.split(string);
    }

    public static double asnumeric(String s2, HashMap<String, String[]> parameters) {
        return GenMunger.parseNum(s2);
    }

    public static String trim(String s2, HashMap<String, String[]> parameters) {
        return s2.trim();
    }

    public static String replaceall(String s2, HashMap<String, String[]> parameters) {
        String string = parameters.get("pattern")[0];
        String string2 = parameters.get("replacement")[0];
        boolean bl = parameters.get("ignore_case")[0].equals("TRUE");
        if (bl) {
            return s2.replaceAll("(?i)" + Pattern.quote(string), string2);
        }
        return s2.replaceAll(string, string2);
    }

    public static String toupper(String s2, HashMap<String, String[]> parameters) {
        return s2.toUpperCase();
    }

    public static String tolower(String s2, HashMap<String, String[]> parameters) {
        return s2.toLowerCase();
    }

    public static String cut(double d2, HashMap<String, String[]> parameters) {
        String[] stringArray = parameters.get("breaks");
        String[] stringArray2 = parameters.get("labels");
        boolean bl = parameters.get("include_lowest")[0].equals("TRUE");
        boolean bl2 = parameters.get("right")[0].equals("TRUE");
        if (Double.isNaN(d2) || bl && d2 < GenMunger.parseNum(stringArray[0]) || !bl && d2 <= GenMunger.parseNum(stringArray[0]) || bl2 && d2 > GenMunger.parseNum(stringArray[stringArray.length - 1]) || !bl2 && d2 >= GenMunger.parseNum(stringArray[stringArray.length - 1])) {
            return "";
        }
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            if (!bl2) continue;
            if (d2 <= GenMunger.parseNum(stringArray[i2])) {
                return stringArray2[i2 - 1];
            }
            if (!(d2 < GenMunger.parseNum(stringArray[i2]))) continue;
            return stringArray2[i2 - 1];
        }
        return "";
    }

    public static double nchar(String s2, HashMap<String, String[]> parameters) {
        return s2.length();
    }

    public abstract class Step<T>
    implements Serializable {
        private final String[] _names;
        private final String[] _types;
        private final String[] _outNames;
        protected HashMap<String, String[]> _params;

        public abstract RowData transform(RowData var1);

        public Step(String[] inNames, String[] inTypes, String[] outNames) {
            this._names = inNames;
            this._types = inTypes;
            this._outNames = outNames;
            this._params = new HashMap();
        }

        public String[] outNames() {
            return this._outNames;
        }

        public String[] names() {
            return this._names;
        }

        public String[] types() {
            return this._types;
        }

        public HashMap<String, String[]> params() {
            return this._params;
        }
    }
}

