/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.genmodel.MojoReaderBackend;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InMemoryMojoReaderBackend
implements MojoReaderBackend,
Closeable {
    private static final Map<String, byte[]> CLOSED = Collections.unmodifiableMap(new HashMap());
    private Map<String, byte[]> _mojoContent;

    public InMemoryMojoReaderBackend(Map<String, byte[]> mojoContent) {
        this._mojoContent = mojoContent;
    }

    @Override
    public BufferedReader getTextFile(String filename) throws IOException {
        this.checkOpen();
        byte[] byArray = this._mojoContent.get(filename);
        if (byArray == null) {
            throw new IOException("MOJO doesn't contain resource " + filename);
        }
        return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
    }

    @Override
    public byte[] getBinaryFile(String filename) throws IOException {
        this.checkOpen();
        return this._mojoContent.get(filename);
    }

    @Override
    public boolean exists(String filename) {
        this.checkOpen();
        return this._mojoContent.containsKey(filename);
    }

    @Override
    public void close() throws IOException {
        this._mojoContent = CLOSED;
    }

    private void checkOpen() {
        if (this._mojoContent == CLOSED) {
            throw new IllegalStateException("ReaderBackend was already closed");
        }
    }
}

