/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.deeplearning;

import hex.genmodel.algos.deeplearning.ActivationUtils;
import hex.genmodel.algos.deeplearning.DeeplearningMojoModel;
import java.util.Arrays;
import java.util.List;

public class NeuralNetwork {
    public String _activation;
    double _drop_out_ratio;
    public DeeplearningMojoModel.StoreWeightsBias _weightsAndBias;
    public double[] _inputs;
    public double[] _outputs;
    public int _outSize;
    public int _inSize;
    public int _maxK = 1;
    List<String> _validActivation = Arrays.asList("Linear", "Softmax", "ExpRectifierWithDropout", "ExpRectifier", "Rectifier", "RectifierWithDropout", "MaxoutWithDropout", "Maxout", "TanhWithDropout", "Tanh");

    public NeuralNetwork(String activation, double drop_out_ratio, DeeplearningMojoModel.StoreWeightsBias weightsAndBias, double[] inputs, int outSize) {
        this.validateInputs(activation, drop_out_ratio, weightsAndBias._wValues.length, weightsAndBias._bValues.length, inputs.length, outSize);
        this._activation = activation;
        this._drop_out_ratio = drop_out_ratio;
        this._weightsAndBias = weightsAndBias;
        this._inputs = inputs;
        this._outSize = outSize;
        this._inSize = this._inputs.length;
        this._outputs = new double[this._outSize];
        if ("Maxout".equals(this._activation) || "MaxoutWithDropout".equals(this._activation)) {
            this._maxK = weightsAndBias._bValues.length / outSize;
        }
    }

    public double[] fprop1Layer() {
        double[] dArray = this._maxK == 1 ? this.formNNInputs() : this.formNNInputsMaxOut();
        NeuralNetwork neuralNetwork = this;
        ActivationUtils.ActivationFunctions activationFunctions = neuralNetwork.createActFuns(neuralNetwork._activation);
        return activationFunctions.eval(dArray, this._drop_out_ratio, this._maxK);
    }

    public double[] formNNInputs() {
        double[] dArray = new double[this._outSize];
        int n2 = this._inputs.length;
        int n3 = dArray.length;
        int n4 = n2;
        int n5 = n4 - n4 % 8;
        int n6 = (n2 / 8 << 3) - 1;
        int n7 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n8;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            for (n8 = 0; n8 < n6; n8 += 8) {
                int n9 = n7 + n8;
                d2 += (double)this._weightsAndBias._wValues[n9] * this._inputs[n8];
                d3 += (double)this._weightsAndBias._wValues[n9 + 1] * this._inputs[n8 + 1];
                d4 += (double)this._weightsAndBias._wValues[n9 + 2] * this._inputs[n8 + 2];
                d5 += (double)this._weightsAndBias._wValues[n9 + 3] * this._inputs[n8 + 3];
                d6 += (double)this._weightsAndBias._wValues[n9 + 4] * this._inputs[n8 + 4];
                d7 += (double)this._weightsAndBias._wValues[n9 + 5] * this._inputs[n8 + 5];
                d8 += (double)this._weightsAndBias._wValues[n9 + 6] * this._inputs[n8 + 6];
                d9 += (double)this._weightsAndBias._wValues[n9 + 7] * this._inputs[n8 + 7];
            }
            int n10 = i2;
            dArray[n10] = dArray[n10] + (d2 + d3 + d4 + d5);
            int n11 = i2;
            dArray[n11] = dArray[n11] + (d6 + d7 + d8 + d9);
            for (n8 = n5; n8 < n2; ++n8) {
                int n12 = i2;
                dArray[n12] = dArray[n12] + (double)this._weightsAndBias._wValues[n7 + n8] * this._inputs[n8];
            }
            int n13 = i2;
            dArray[n13] = dArray[n13] + this._weightsAndBias._bValues[i2];
            n7 += n2;
        }
        return dArray;
    }

    public double[] formNNInputsMaxOut() {
        double[] dArray = new double[this._outSize * this._maxK];
        for (int i2 = 0; i2 < this._maxK; ++i2) {
            for (int i3 = 0; i3 < this._outSize; ++i3) {
                int n2 = this._maxK * i3 + i2;
                for (int i4 = 0; i4 < this._inSize; ++i4) {
                    int n3 = n2;
                    dArray[n3] = dArray[n3] + this._inputs[i4] * (double)this._weightsAndBias._wValues[this._maxK * (i3 * this._inSize + i4) + i2];
                }
                int n4 = n2;
                dArray[n4] = dArray[n4] + this._weightsAndBias._bValues[n2];
            }
        }
        return dArray;
    }

    public void validateInputs(String activation, double drop_out_ratio, int weightLen, int biasLen, int inSize, int outSize) {
        assert (this._validActivation.contains(activation)) : "activation must be one of \"Linear\", \"Softmax\", \"ExpRectifierWithDropout\", \"ExpRectifier\", \"Rectifier\", \"RectifierWithDropout\", \"MaxoutWithDropout\", \"Maxout\", \"TanhWithDropout\", \"Tanh\"";
        assert (weightLen % (inSize * outSize) == 0) : "Your neural network layer number of input * number of outputs should equal length of your weight vector";
        assert (biasLen % outSize == 0) : "Number of bias should equal number of nodes in your nerual network layer.";
        assert (drop_out_ratio >= 0.0 && drop_out_ratio < 1.0) : "drop_out_ratio must be >=0 and < 1.";
        assert (outSize > 0) : "number of nodes in neural network must exceed 0.";
    }

    public ActivationUtils.ActivationFunctions createActFuns(String activation) {
        switch (activation) {
            case "Linear": {
                return new ActivationUtils.LinearOut();
            }
            case "Softmax": {
                return new ActivationUtils.SoftmaxOut();
            }
            case "ExpRectifierWithDropout": {
                return new ActivationUtils.ExpRectifierDropoutOut();
            }
            case "ExpRectifier": {
                return new ActivationUtils.ExpRectifierOut();
            }
            case "Rectifier": {
                return new ActivationUtils.RectifierOut();
            }
            case "RectifierWithDropout": {
                return new ActivationUtils.RectifierDropoutOut();
            }
            case "MaxoutWithDropout": {
                return new ActivationUtils.MaxoutDropoutOut();
            }
            case "Maxout": {
                return new ActivationUtils.MaxoutOut();
            }
            case "TanhWithDropout": {
                return new ActivationUtils.TanhDropoutOut();
            }
            case "Tanh": {
                return new ActivationUtils.TanhOut();
            }
        }
        throw new UnsupportedOperationException("Unexpected activation function: " + activation);
    }
}

