/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

import java.util.Arrays;

public class GamUtilsCubicRegression {
    public static double gen_a_m_j(double xjp1, double x2, double hj) {
        return (xjp1 - x2) / hj;
    }

    public static double gen_a_p_j(double xj, double x2, double hj) {
        return (x2 - xj) / hj;
    }

    public static double gen_c_m_j(double xjp1, double x2, double hj) {
        double d2 = xjp1 - x2;
        double d3 = d2 * d2 * d2;
        return (d3 / hj - d2 * hj) / 6.0;
    }

    public static double gen_c_p_j(double xj, double x2, double hj) {
        double d2 = x2 - xj;
        double d3 = d2 * d2 * d2;
        return (d3 / hj - d2 * hj) / 6.0;
    }

    public static int locateBin(double xval, double[] knots) {
        if (xval <= knots[0]) {
            return 0;
        }
        int n2 = knots.length - 1;
        if (xval >= knots[n2]) {
            return n2 - 1;
        }
        int n3 = -1;
        int n4 = knots.length;
        int n5 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            n3 = (int)Math.floor((double)(n2 + n5) * 0.5);
            if (xval >= knots[n3] && xval < knots[n3 + 1]) {
                return n3;
            }
            if (xval > knots[n3]) {
                n5 = n3;
                continue;
            }
            if (!(xval < knots[n3])) continue;
            n2 = n3;
        }
        return n3;
    }

    public static void updateAFunc(double[] basisVals, double xval, int binIndex, double[] knots, double[] hj) {
        int n2 = binIndex + 1;
        int n3 = binIndex;
        basisVals[n3] = basisVals[n3] + GamUtilsCubicRegression.gen_a_m_j(knots[n2], xval, hj[binIndex]);
        int n4 = n2;
        basisVals[n4] = basisVals[n4] + GamUtilsCubicRegression.gen_a_p_j(knots[binIndex], xval, hj[binIndex]);
    }

    public static void updateFMatrixCFunc(double[] basisVals, double xval, int binIndex, double[] knots, double[] hj, double[][] binvD) {
        int n2 = basisVals.length;
        int n3 = binvD.length;
        int n4 = binIndex + 1;
        double d2 = GamUtilsCubicRegression.gen_c_m_j(knots[n4], xval, hj[binIndex]);
        double d3 = GamUtilsCubicRegression.gen_c_p_j(knots[binIndex], xval, hj[binIndex]);
        int n5 = binIndex - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            basisVals[i2] = binIndex == 0 ? binvD[binIndex][i2] * d3 : (binIndex >= n3 ? binvD[n5][i2] * d2 : binvD[n5][i2] * d2 + binvD[binIndex][i2] * d3);
        }
    }

    public static void expandOneGamCol(double xval, double[][] binvD, double[] basisVals, double[] hj, double[] knots) {
        if (!Double.isNaN(xval)) {
            int n2 = GamUtilsCubicRegression.locateBin(xval, knots);
            GamUtilsCubicRegression.updateFMatrixCFunc(basisVals, xval, n2, knots, hj, binvD);
            GamUtilsCubicRegression.updateAFunc(basisVals, xval, n2, knots, hj);
            return;
        }
        Arrays.fill(basisVals, Double.NaN);
    }
}

