/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glm;

import hex.genmodel.algos.glm.GlmMojoModelBase;

public class GlmMultinomialMojoModel
extends GlmMojoModelBase {
    private int P;
    private int noff;

    GlmMultinomialMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    void init() {
        this.P = this._beta.length / this._nclasses;
        if (this.P * this._nclasses != this._beta.length) {
            throw new IllegalStateException("Incorrect coding of Beta.");
        }
        this.noff = this._catOffsets[this._cats];
    }

    @Override
    double[] glmScore0(double[] data, double[] preds) {
        int n2;
        preds[0] = 0.0;
        for (int i2 = 0; i2 < this._nclasses; ++i2) {
            int n3;
            preds[i2 + 1] = 0.0;
            if (this._cats > 0) {
                if (!this._useAllFactorLevels) {
                    for (n3 = 0; n3 < this._catOffsets.length - 1; ++n3) {
                        if (data[n3] == 0.0) continue;
                        n2 = (int)data[n3] - 1;
                        if ((double)n2 != data[n3] - 1.0) {
                            throw new IllegalArgumentException("categorical value out of range");
                        }
                        if ((n2 += this._catOffsets[n3]) >= this._catOffsets[n3 + 1]) continue;
                        int n4 = i2 + 1;
                        preds[n4] = preds[n4] + this._beta[n2 + i2 * this.P];
                    }
                } else {
                    for (n3 = 0; n3 < this._catOffsets.length - 1; ++n3) {
                        n2 = (int)data[n3];
                        if ((double)n2 != data[n3]) {
                            throw new IllegalArgumentException("categorical value out of range");
                        }
                        if ((n2 += this._catOffsets[n3]) >= this._catOffsets[n3 + 1]) continue;
                        int n5 = i2 + 1;
                        preds[n5] = preds[n5] + this._beta[n2 + i2 * this.P];
                    }
                }
            }
            for (n3 = 0; n3 < this._nums; ++n3) {
                int n6 = i2 + 1;
                preds[n6] = preds[n6] + this._beta[this.noff + n3 + i2 * this.P] * data[n3 + this._cats];
            }
            int n7 = i2 + 1;
            preds[n7] = preds[n7] + this._beta[this.P - 1 + i2 * this.P];
        }
        double d2 = 0.0;
        for (n2 = 1; n2 < preds.length; ++n2) {
            if (!(preds[n2] > d2)) continue;
            d2 = preds[n2];
        }
        double d3 = 0.0;
        for (int i3 = 1; i3 < preds.length; ++i3) {
            preds[i3] = Math.exp(preds[i3] - d2);
            d3 += preds[i3];
        }
        d3 = 1.0 / d3;
        double d4 = 0.0;
        for (int i4 = 1; i4 < preds.length; ++i4) {
            int n8 = i4;
            double d5 = preds[n8] = preds[n8] * d3;
            if (!(d5 > d4)) continue;
            d4 = preds[i4];
            preds[0] = i4 - 1;
        }
        return preds;
    }
}

