/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glm;

import hex.genmodel.algos.glm.GlmMojoModelBase;
import hex.genmodel.utils.ArrayUtils;
import java.util.Arrays;

public class GlmOrdinalMojoModel
extends GlmMojoModelBase {
    private int P;
    private int noff;
    private int lastClass;
    private int[] icptIndices;

    GlmOrdinalMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    void init() {
        this.P = this._beta.length / this._nclasses;
        this.lastClass = this._nclasses - 1;
        this.icptIndices = new int[this.lastClass];
        for (int i2 = 0; i2 < this.lastClass; ++i2) {
            this.icptIndices[i2] = this.P - 1 + i2 * this.P;
        }
        if (this.P * this._nclasses != this._beta.length) {
            throw new IllegalStateException("Incorrect coding of Beta.");
        }
        this.noff = this._catOffsets[this._cats];
    }

    @Override
    double[] glmScore0(double[] data, double[] preds) {
        int n2;
        Arrays.fill(preds, 0.0);
        preds[0] = this.lastClass;
        for (int i2 = 0; i2 < this.lastClass; ++i2) {
            int n3;
            if (this._cats > 0) {
                if (!this._useAllFactorLevels) {
                    for (n3 = 0; n3 < this._catOffsets.length - 1; ++n3) {
                        if (data[n3] == 0.0) continue;
                        n2 = (int)data[n3] - 1;
                        if ((double)n2 != data[n3] - 1.0) {
                            throw new IllegalArgumentException("categorical value out of range");
                        }
                        if ((n2 += this._catOffsets[n3]) >= this._catOffsets[n3 + 1]) continue;
                        int n4 = i2 + 1;
                        preds[n4] = preds[n4] + this._beta[n2 + i2 * this.P];
                    }
                } else {
                    for (n3 = 0; n3 < this._catOffsets.length - 1; ++n3) {
                        n2 = (int)data[n3];
                        if ((double)n2 != data[n3]) {
                            throw new IllegalArgumentException("categorical value out of range");
                        }
                        if ((n2 += this._catOffsets[n3]) >= this._catOffsets[n3 + 1]) continue;
                        int n5 = i2 + 1;
                        preds[n5] = preds[n5] + this._beta[n2 + i2 * this.P];
                    }
                }
            }
            for (n3 = 0; n3 < this._nums; ++n3) {
                int n6 = i2 + 1;
                preds[n6] = preds[n6] + this._beta[n3 + this.noff + i2 * this.P] * data[n3 + this._cats];
            }
            int n7 = i2 + 1;
            preds[n7] = preds[n7] + this._beta[this.icptIndices[i2]];
        }
        double d2 = 0.0;
        for (n2 = 0; n2 < this.lastClass; ++n2) {
            double d3 = preds[n2 + 1];
            double d4 = 1.0 / (1.0 + Math.exp(-d3));
            preds[n2 + 1] = d4 - d2;
            d2 = d4;
        }
        preds[this._nclasses] = 1.0 - d2;
        preds[0] = 0.0;
        preds[0] = ArrayUtils.maxIndex(preds) - 1;
        return preds;
    }
}

