/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.klime;

import hex.ModelCategory;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.glm.GlmMojoModel;
import java.util.EnumSet;

public class KLimeMojoModel
extends MojoModel {
    MojoModel _clusteringModel;
    MojoModel _globalRegressionModel;
    MojoModel[] _clusterRegressionModels;
    int[] _rowSubsetMap;

    @Override
    public EnumSet<ModelCategory> getModelCategories() {
        return EnumSet.of(ModelCategory.Regression, ModelCategory.KLime);
    }

    KLimeMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public double[] score0(double[] row, double[] preds) {
        int n2;
        assert (preds.length == row.length + 2);
        double[] dArray = new double[this._clusteringModel.nfeatures() + 2];
        double[] dArray2 = new double[this._clusteringModel.nfeatures()];
        for (n2 = 0; n2 < this._clusteringModel._names.length; ++n2) {
            dArray2[n2] = row[this._rowSubsetMap[n2]];
        }
        this._clusteringModel.score0(dArray2, dArray);
        n2 = (int)dArray[0];
        GlmMojoModel glmMojoModel = this.getRegressionModel(n2);
        glmMojoModel.score0(row, preds);
        preds[1] = n2;
        for (int i2 = 2; i2 < preds.length; ++i2) {
            preds[i2] = Double.NaN;
        }
        glmMojoModel.applyCoefficients(row, preds, 2);
        return preds;
    }

    public GlmMojoModel getRegressionModel(int cluster) {
        return (GlmMojoModel)(this._clusterRegressionModels[cluster] != null ? this._clusterRegressionModels[cluster] : this._globalRegressionModel);
    }

    @Override
    public int getPredsSize() {
        return this.nfeatures() + 2;
    }
}

