/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import hex.genmodel.PredictContributions;
import hex.genmodel.algos.tree.TreeSHAPPredictor;
import hex.genmodel.utils.ArrayUtils;

public abstract class ContributionsPredictor<E>
implements PredictContributions {
    private final int _ncontribs;
    private final String[] _contribution_names;
    private final TreeSHAPPredictor<E> _treeSHAPPredictor;
    private final int _workspaceSize;
    private static final ThreadLocal<TreeSHAPPredictor.Workspace> _workspace = new ThreadLocal();

    public ContributionsPredictor(int ncontribs, String[] featureContributionNames, TreeSHAPPredictor<E> treeSHAPPredictor) {
        this._ncontribs = ncontribs;
        this._contribution_names = ArrayUtils.append(featureContributionNames, "BiasTerm");
        this._treeSHAPPredictor = treeSHAPPredictor;
        this._workspaceSize = this._treeSHAPPredictor.getWorkspaceSize();
    }

    @Override
    public final String[] getContributionNames() {
        return this._contribution_names;
    }

    @Override
    public final float[] calculateContributions(double[] input) {
        float[] fArray = new float[this._ncontribs];
        this._treeSHAPPredictor.calculateContributions(this.toInputRow(input), fArray, 0, -1, this.getWorkspace());
        return this.getContribs(fArray);
    }

    protected abstract E toInputRow(double[] var1);

    public float[] getContribs(float[] contribs) {
        return contribs;
    }

    private TreeSHAPPredictor.Workspace getWorkspace() {
        TreeSHAPPredictor.Workspace workspace = _workspace.get();
        if (workspace == null || workspace.getSize() != this._workspaceSize) {
            workspace = this._treeSHAPPredictor.makeWorkspace();
            assert (workspace.getSize() == this._workspaceSize);
            _workspace.set(workspace);
        }
        return workspace;
    }
}

