/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import hex.genmodel.algos.tree.SharedTreeNode;
import hex.genmodel.tools.PrintMojo;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SharedTreeSubgraph {
    public final int subgraphNumber;
    public final String name;
    public SharedTreeNode rootNode;
    public int fontSize = 14;
    public boolean setDecimalPlaces = false;
    public int nPlaces = -1;
    public ArrayList<SharedTreeNode> nodesArray;

    SharedTreeSubgraph(int sn, String n2) {
        this.subgraphNumber = sn;
        this.name = n2;
        this.nodesArray = new ArrayList();
    }

    public SharedTreeNode makeRootNode() {
        assert (this.nodesArray.size() == 0);
        SharedTreeNode sharedTreeNode = new SharedTreeNode(0, null, this.subgraphNumber, 0);
        sharedTreeNode.setInclusiveNa(true);
        this.nodesArray.add(sharedTreeNode);
        this.rootNode = sharedTreeNode;
        return sharedTreeNode;
    }

    public void setDecimalPlace(int nplaces) {
        this.setDecimalPlaces = true;
        this.nPlaces = nplaces;
    }

    public void setFontSize(int fontsize) {
        this.fontSize = fontsize;
    }

    public SharedTreeNode makeLeftChildNode(SharedTreeNode parent) {
        SharedTreeNode sharedTreeNode = new SharedTreeNode(this.nodesArray.size(), parent, this.subgraphNumber, parent.getDepth() + 1);
        this.nodesArray.add(sharedTreeNode);
        this.makeLeftEdge(parent, sharedTreeNode);
        return sharedTreeNode;
    }

    public SharedTreeNode makeRightChildNode(SharedTreeNode parent) {
        SharedTreeNode sharedTreeNode = new SharedTreeNode(this.nodesArray.size(), parent, this.subgraphNumber, parent.getDepth() + 1);
        this.nodesArray.add(sharedTreeNode);
        this.makeRightEdge(parent, sharedTreeNode);
        return sharedTreeNode;
    }

    private void makeLeftEdge(SharedTreeNode parent, SharedTreeNode child) {
        parent.setLeftChild(child);
    }

    private void makeRightEdge(SharedTreeNode parent, SharedTreeNode child) {
        parent.setRightChild(child);
    }

    public SharedTreeNode walkNodes(String path) {
        SharedTreeNode sharedTreeNode = this.rootNode;
        block4: for (int i2 = 0; i2 < path.length(); ++i2) {
            if (sharedTreeNode == null) {
                return null;
            }
            switch (path.charAt(i2)) {
                case 'L': {
                    sharedTreeNode = sharedTreeNode.getLeftChild();
                    continue block4;
                }
                case 'R': {
                    sharedTreeNode = sharedTreeNode.getRightChild();
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Invalid path specification '" + path + "'. Paths must only be made of 'L' and 'R' characters.");
                }
            }
        }
        return sharedTreeNode;
    }

    public float scoreTree(double[] data) {
        SharedTreeNode sharedTreeNode = this.rootNode;
        while (!sharedTreeNode.isLeaf()) {
            int n2 = sharedTreeNode.next(data);
            sharedTreeNode = this.nodesArray.get(n2);
        }
        return sharedTreeNode.getPredValue();
    }

    void print() {
        System.out.println("");
        System.out.println("    ----- " + this.name + " -----");
        System.out.println("    Nodes");
        for (SharedTreeNode sharedTreeNode : this.nodesArray) {
            sharedTreeNode.print();
        }
        System.out.println("");
        System.out.println("    Edges");
        this.rootNode.printEdges();
    }

    void printDot(PrintStream os, int maxLevelsToPrintPerEdge, boolean detail, String optionalTitle, PrintMojo.PrintTreeOptions treeOptions) {
        os.println("");
        os.println("subgraph cluster_" + this.subgraphNumber + " {");
        os.println("/* Nodes */");
        int n2 = -1;
        for (SharedTreeNode sharedTreeNode : this.nodesArray) {
            if (sharedTreeNode.getDepth() <= n2) continue;
            n2 = sharedTreeNode.getDepth();
        }
        for (int i2 = 0; i2 <= n2; ++i2) {
            os.println("");
            os.println("/* Level " + i2 + " */");
            os.println("{");
            this.rootNode.printDotNodesAtLevel(os, i2, detail, treeOptions);
            os.println("}");
        }
        os.println("");
        os.println("/* Edges */");
        for (SharedTreeNode sharedTreeNode : this.nodesArray) {
            sharedTreeNode.printDotEdges(os, maxLevelsToPrintPerEdge, this.rootNode.getWeight(), detail, treeOptions);
        }
        os.println("");
        os.println("fontsize=40");
        String string = SharedTreeNode.escapeQuotes(optionalTitle != null ? optionalTitle : this.name);
        os.println("label=\"" + (String)string + "\"");
        os.println("}");
    }

    public void printDot(PrintStream os, int maxLevelsToPrintPerEdge, boolean detail, String optionalTitle, PrintMojo.PrintTreeOptions treeOptions, boolean isDirected) {
        os.println("");
        os.println((isDirected ? "digraph " : "subgraph cluster_") + this.subgraphNumber + " {");
        os.println("/* Nodes */");
        int n2 = -1;
        for (SharedTreeNode sharedTreeNode : this.nodesArray) {
            if (sharedTreeNode.getDepth() <= n2) continue;
            n2 = sharedTreeNode.getDepth();
        }
        for (int i2 = 0; i2 <= n2; ++i2) {
            os.println("");
            os.println("/* Level " + i2 + " */");
            os.println("{");
            this.rootNode.printDotNodesAtLevel(os, i2, detail, treeOptions);
            os.println("}");
        }
        os.println("");
        os.println("/* Edges */");
        for (SharedTreeNode sharedTreeNode : this.nodesArray) {
            sharedTreeNode.printDotEdges(os, maxLevelsToPrintPerEdge, this.rootNode.getWeight(), detail, treeOptions);
        }
        os.println("");
        os.println("fontsize=40");
        String string = SharedTreeNode.escapeQuotes(optionalTitle != null ? optionalTitle : this.name);
        os.println("label=\"" + (String)string + "\"");
        os.println("}");
    }

    Map<String, Object> toJson() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("index", this.subgraphNumber);
        hashMap.put("name", this.name);
        hashMap.put("root", this.rootNode.toJson());
        return hashMap;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SharedTreeSubgraph sharedTreeSubgraph = (SharedTreeSubgraph)o2;
        return this.subgraphNumber == sharedTreeSubgraph.subgraphNumber && Objects.equals(this.name, sharedTreeSubgraph.name) && Objects.equals(this.rootNode, sharedTreeSubgraph.rootNode) && Objects.equals(this.nodesArray, sharedTreeSubgraph.nodesArray);
    }

    public int hashCode() {
        return Objects.hash(this.subgraphNumber);
    }

    public String toString() {
        return "SharedTreeSubgraph{subgraphNumber=" + this.subgraphNumber + ", name='" + this.name + '\'' + '}';
    }
}

