/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy;

import hex.genmodel.easy.CategoricalEncoder;
import java.util.HashMap;
import java.util.Map;

public class EnumEncoder
implements CategoricalEncoder {
    private final String columnName;
    private final int targetIndex;
    private final Map<String, Integer> domainMap;

    public EnumEncoder(String columnName, int targetIndex, String[] domainValues) {
        this.columnName = columnName;
        this.targetIndex = targetIndex;
        this.domainMap = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < domainValues.length; ++i2) {
            this.domainMap.put(domainValues[i2], i2);
        }
    }

    @Override
    public boolean encodeCatValue(String levelName, double[] rawData) {
        Integer n2 = this.domainMap.get(levelName);
        if (n2 == null) {
            n2 = this.domainMap.get(this.columnName + "." + levelName);
        }
        if (n2 == null) {
            return false;
        }
        rawData[this.targetIndex] = n2.intValue();
        return true;
    }

    @Override
    public void encodeNA(double[] rawData) {
        rawData[this.targetIndex] = Double.NaN;
    }
}

