/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.tools;

import com.b.a.e;
import com.b.a.f;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.gbm.GbmMojoModel;
import hex.genmodel.algos.tree.ConvertTreeOptions;
import hex.genmodel.algos.tree.SharedTreeGraph;
import hex.genmodel.algos.tree.SharedTreeGraphConverter;
import hex.genmodel.algos.tree.TreeBackedMojoModel;
import hex.genmodel.tools.MojoPrinter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import water.util.JavaVersionUtils;

public class PrintMojo
implements MojoPrinter {
    protected MojoModel genModel;
    protected MojoPrinter.Format format = MojoPrinter.Format.dot;
    protected int treeToPrint = -1;
    protected int maxLevelsToPrintPerEdge = 10;
    protected boolean detail = false;
    protected String outputFileName = null;
    protected String optionalTitle = null;
    protected PrintTreeOptions pTreeOptions;
    protected boolean internal;
    protected final String tmpOutputFileName = "tmpOutputFileName.gv";

    public static void main(String[] args) {
        Object object;
        MojoPrinter mojoPrinter = null;
        if (JavaVersionUtils.JAVA_VERSION.isKnown() && JavaVersionUtils.JAVA_VERSION.getMajor() > 7) {
            object = ServiceLoader.load(MojoPrinter.class);
            Iterator<MojoPrinter> iterator = ((ServiceLoader)object).iterator();
            while (iterator.hasNext()) {
                MojoPrinter mojoPrinter2 = iterator.next();
                if (!mojoPrinter2.supportsFormat(PrintMojo.getFormat(args))) continue;
                mojoPrinter = mojoPrinter2;
            }
            if (mojoPrinter == null) {
                System.out.println("No supported MojoPrinter for the format required found. Please make sure you are using h2o-genmodel.jar for executing this tool.");
                System.exit(1);
            }
        } else {
            mojoPrinter = new PrintMojo();
        }
        mojoPrinter.parseArgs(args);
        try {
            mojoPrinter.run();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            System.exit(2);
        }
        System.exit(0);
    }

    @Override
    public boolean supportsFormat(MojoPrinter.Format format) {
        return !MojoPrinter.Format.png.equals((Object)format);
    }

    static MojoPrinter.Format getFormat(String[] args) {
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (!args[i2].equals("--format")) continue;
            try {
                return MojoPrinter.Format.valueOf(args[++i2]);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private void loadMojo(String modelName) throws IOException {
        this.genModel = MojoModel.load(modelName);
    }

    protected static void usage() {
        System.out.println("Emit a human-consumable graph of a model for use with dot (graphviz).");
        System.out.println("The currently supported model types are DRF, GBM and XGBoost.");
        System.out.println();
        System.out.println("Usage:  java [...java args...] hex.genmodel.tools.PrintMojo [--tree n] [--levels n] [--title sss] [-o outputFileName]");
        System.out.println();
        System.out.println("    --format        Output format. For .png output at least Java 8 is required.");
        System.out.println("                    dot|json|raw|png [default dot]");
        System.out.println();
        System.out.println("    --tree          Tree number to print.");
        System.out.println("                    [default all]");
        System.out.println();
        System.out.println("    --levels        Number of levels per edge to print.");
        System.out.println("                    [default 10]");
        System.out.println();
        System.out.println("    --title         (Optional) Force title of tree graph.");
        System.out.println();
        System.out.println("    --detail        Specify to print additional detailed information like node numbers.");
        System.out.println();
        System.out.println("    --input | -i    Input mojo file.");
        System.out.println();
        System.out.println("    --output | -o   Output filename. Taken as a directory name in case of .png format and multiple trees to visualize.");
        System.out.println("                    [default stdout]");
        System.out.println("    --decimalplaces | -d    Set decimal places of all numerical values.");
        System.out.println();
        System.out.println("    --fontsize | -f    Set font sizes of strings.");
        System.out.println();
        System.out.println("    --internal    Internal H2O representation of the decision tree (splits etc.) is used for generating the GRAPHVIZ format.");
        System.out.println();
        System.out.println();
        System.out.println("Example:");
        System.out.println();
        System.out.println("    (brew install graphviz)");
        System.out.println("    java -cp h2o.jar hex.genmodel.tools.PrintMojo --tree 0 -i model_mojo.zip -o model.gv -f 20 -d 3");
        System.out.println("    dot -Tpng model.gv -o model.png");
        System.out.println("    open model.png");
        System.out.println();
        System.exit(1);
    }

    @Override
    public void parseArgs(String[] args) {
        int n2 = -1;
        int n3 = 14;
        boolean bl = false;
        try {
            block38: for (int i2 = 0; i2 < args.length; ++i2) {
                String string;
                switch (string = args[i2]) {
                    case "--format": {
                        if (++i2 >= args.length) {
                            PrintMojo.usage();
                        }
                        string = args[i2];
                        try {
                            this.format = MojoPrinter.Format.valueOf(string);
                        }
                        catch (Exception exception) {
                            System.out.println("ERROR: invalid --format argument (" + string + ")");
                            System.exit(1);
                        }
                        continue block38;
                    }
                    case "--tree": {
                        if (++i2 >= args.length) {
                            PrintMojo.usage();
                        }
                        string = args[i2];
                        try {
                            this.treeToPrint = Integer.parseInt(string);
                        }
                        catch (Exception exception) {
                            System.out.println("ERROR: invalid --tree argument (" + string + ")");
                            System.exit(1);
                        }
                        continue block38;
                    }
                    case "--levels": {
                        if (++i2 >= args.length) {
                            PrintMojo.usage();
                        }
                        string = args[i2];
                        try {
                            this.maxLevelsToPrintPerEdge = Integer.parseInt(string);
                        }
                        catch (Exception exception) {
                            System.out.println("ERROR: invalid --levels argument (" + string + ")");
                            System.exit(1);
                        }
                        continue block38;
                    }
                    case "--title": {
                        if (++i2 >= args.length) {
                            PrintMojo.usage();
                        }
                        this.optionalTitle = args[i2];
                        continue block38;
                    }
                    case "--detail": {
                        this.detail = true;
                        continue block38;
                    }
                    case "--input": 
                    case "-i": {
                        if (++i2 >= args.length) {
                            PrintMojo.usage();
                        }
                        string = args[i2];
                        this.loadMojo(string);
                        continue block38;
                    }
                    case "--fontsize": 
                    case "-f": {
                        if (++i2 >= args.length) {
                            PrintMojo.usage();
                        }
                        string = args[i2];
                        n3 = Integer.parseInt(string);
                        continue block38;
                    }
                    case "--decimalplaces": 
                    case "-d": {
                        if (++i2 >= args.length) {
                            PrintMojo.usage();
                        }
                        bl = true;
                        string = args[i2];
                        n2 = Integer.parseInt(string);
                        continue block38;
                    }
                    case "--raw": {
                        this.format = MojoPrinter.Format.raw;
                        continue block38;
                    }
                    case "--internal": {
                        this.internal = true;
                        continue block38;
                    }
                    case "-o": 
                    case "--output": {
                        if (++i2 >= args.length) {
                            PrintMojo.usage();
                        }
                        this.outputFileName = args[i2];
                        continue block38;
                    }
                    default: {
                        System.out.println("ERROR: Unknown command line argument: " + string);
                        PrintMojo.usage();
                    }
                }
            }
            this.pTreeOptions = new PrintTreeOptions(bl, n2, n3, this.internal);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            PrintMojo.usage();
            return;
        }
    }

    protected void validateArgs() {
        if (this.genModel == null) {
            System.out.println("ERROR: Must specify -i");
            PrintMojo.usage();
        }
    }

    @Override
    public void run() throws Exception {
        block7: {
            block6: {
                this.validateArgs();
                PrintStream printStream = this.outputFileName != null ? new PrintStream(new FileOutputStream(new File(this.outputFileName))) : System.out;
                if (!(this.genModel instanceof SharedTreeGraphConverter)) break block6;
                SharedTreeGraphConverter sharedTreeGraphConverter = (SharedTreeGraphConverter)((Object)this.genModel);
                ConvertTreeOptions convertTreeOptions = new ConvertTreeOptions().withTreeConsistencyCheckEnabled();
                SharedTreeGraph sharedTreeGraph = sharedTreeGraphConverter.convert(this.treeToPrint, null, convertTreeOptions);
                switch (this.format) {
                    case raw: {
                        sharedTreeGraph.print();
                        break block7;
                    }
                    case dot: {
                        sharedTreeGraph.printDot(printStream, this.maxLevelsToPrintPerEdge, this.detail, this.optionalTitle, this.pTreeOptions);
                        break block7;
                    }
                    case json: {
                        if (!(sharedTreeGraphConverter instanceof TreeBackedMojoModel)) {
                            System.out.println("ERROR: Printing XGBoost MOJO as JSON not supported");
                            System.exit(1);
                        }
                        this.printJson((TreeBackedMojoModel)sharedTreeGraphConverter, sharedTreeGraph, printStream);
                    }
                    default: {
                        return;
                    }
                }
            }
            System.out.println("ERROR: Unsupported MOJO type");
            System.exit(1);
        }
    }

    private Map<String, Object> getParamsAsJson(TreeBackedMojoModel tree) {
        Object object;
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("h2o_version", this.genModel._h2oVersion);
        linkedHashMap.put("mojo_version", this.genModel._mojo_version);
        linkedHashMap.put("algo", this.genModel._algoName);
        linkedHashMap.put("model_category", this.genModel._category.toString());
        linkedHashMap.put("classifier", this.genModel.isClassifier());
        linkedHashMap.put("supervised", this.genModel._supervised);
        linkedHashMap.put("nfeatures", this.genModel._nfeatures);
        linkedHashMap.put("nclasses", this.genModel._nclasses);
        linkedHashMap.put("balance_classes", this.genModel._balanceClasses);
        linkedHashMap.put("n_tree_groups", tree.getNTreeGroups());
        linkedHashMap.put("n_trees_in_group", tree.getNTreesPerGroup());
        linkedHashMap.put("base_score", tree.getInitF());
        if (this.genModel.isClassifier()) {
            object = this.genModel.getDomainValues(this.genModel.getResponseIdx());
            linkedHashMap.put("class_labels", object);
        }
        if (this.genModel instanceof GbmMojoModel) {
            object = (GbmMojoModel)this.genModel;
            linkedHashMap.put("family", object._family.toString());
            linkedHashMap.put("link_function", object._link_function.toString());
        }
        return linkedHashMap;
    }

    private List<Object> getDomainValuesAsJSON() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String[][] stringArray = this.genModel.getDomainValues();
        for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
            if (stringArray[i2] == null) continue;
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            linkedHashMap.put("colId", i2);
            linkedHashMap.put("colName", this.genModel._names[i2]);
            linkedHashMap.put("values", stringArray[i2]);
            arrayList.add(linkedHashMap);
        }
        return arrayList;
    }

    private void printJson(TreeBackedMojoModel mojo, SharedTreeGraph trees, PrintStream os) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("params", this.getParamsAsJson(mojo));
        linkedHashMap.put("domainValues", this.getDomainValuesAsJSON());
        linkedHashMap.put("trees", trees.toJson());
        if (this.optionalTitle != null) {
            linkedHashMap.put("title", this.optionalTitle);
        }
        e e2 = new f().a().b();
        os.print(e2.a(linkedHashMap));
    }

    public static class PrintTreeOptions {
        public boolean _setDecimalPlace;
        public int _nPlaces;
        public int _fontSize;
        public boolean _internal;

        public PrintTreeOptions(boolean setdecimalplaces, int nplaces, int fontsize, boolean internal) {
            this._setDecimalPlace = setdecimalplaces;
            this._nPlaces = this._setDecimalPlace ? nplaces : this._nPlaces;
            this._fontSize = fontsize;
            this._internal = internal;
        }

        public float roundNPlace(float value) {
            if (this._nPlaces < 0) {
                return value;
            }
            double d2 = Math.pow(10.0, this._nPlaces);
            return (float)((double)Math.round((double)value * d2) / d2);
        }
    }
}

