/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.MutableDynaClass;

public abstract class BaseDynaBeanMapDecorator<K>
implements Map<K, Object> {
    private final DynaBean dynaBean;
    private final boolean readOnly;
    private transient Set<K> keySet;

    public BaseDynaBeanMapDecorator(DynaBean dynaBean) {
        this(dynaBean, true);
    }

    public BaseDynaBeanMapDecorator(DynaBean dynaBean, boolean readOnly) {
        if (dynaBean == null) {
            throw new IllegalArgumentException("DynaBean is null");
        }
        this.dynaBean = dynaBean;
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        DynaClass dynaClass = this.getDynaBean().getDynaClass();
        DynaProperty dynaProperty = dynaClass.getDynaProperty(this.toString(key));
        return dynaProperty != null;
    }

    @Override
    public boolean containsValue(Object value) {
        DynaProperty[] dynaPropertyArray;
        DynaProperty[] dynaPropertyArray2 = dynaPropertyArray = this.getDynaProperties();
        int n2 = dynaPropertyArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            DynaProperty dynaProperty = dynaPropertyArray2[i2];
            String string = dynaProperty.getName();
            Object object = this.getDynaBean().get(string);
            if (!(value == null ? object == null : value.equals(object))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, Object>> entrySet() {
        DynaProperty[] dynaPropertyArray = this.getDynaProperties();
        HashSet<MapEntry<K>> hashSet = new HashSet<MapEntry<K>>(dynaPropertyArray.length);
        DynaProperty[] dynaPropertyArray2 = dynaPropertyArray;
        int n2 = dynaPropertyArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            DynaProperty dynaProperty = dynaPropertyArray2[i2];
            K k2 = this.convertKey(dynaProperty.getName());
            Object object = this.getDynaBean().get(dynaProperty.getName());
            hashSet.add(new MapEntry<K>(k2, object));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Object get(Object key) {
        return this.getDynaBean().get(this.toString(key));
    }

    @Override
    public boolean isEmpty() {
        return this.getDynaProperties().length == 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet != null) {
            return this.keySet;
        }
        DynaProperty[] dynaPropertyArray = this.getDynaProperties();
        Set<K> set = new HashSet(dynaPropertyArray.length);
        Object object = dynaPropertyArray;
        int n2 = dynaPropertyArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            DynaProperty dynaProperty = object[i2];
            set.add(this.convertKey(dynaProperty.getName()));
        }
        set = Collections.unmodifiableSet(set);
        object = this.getDynaBean().getDynaClass();
        if (!(object instanceof MutableDynaClass)) {
            this.keySet = set;
        }
        return set;
    }

    @Override
    public Object put(K key, Object value) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("Map is read only");
        }
        String string = this.toString(key);
        Object object = this.getDynaBean().get(string);
        this.getDynaBean().set(string, value);
        return object;
    }

    @Override
    public void putAll(Map<? extends K, ? extends Object> map) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("Map is read only");
        }
        for (Map.Entry<K, Object> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.getDynaProperties().length;
    }

    @Override
    public Collection<Object> values() {
        DynaProperty[] dynaPropertyArray = this.getDynaProperties();
        ArrayList<Object> arrayList = new ArrayList<Object>(dynaPropertyArray.length);
        DynaProperty[] dynaPropertyArray2 = dynaPropertyArray;
        int n2 = dynaPropertyArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            DynaProperty dynaProperty = dynaPropertyArray2[i2];
            String string = dynaProperty.getName();
            Object object = this.getDynaBean().get(string);
            arrayList.add(object);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public DynaBean getDynaBean() {
        return this.dynaBean;
    }

    protected abstract K convertKey(String var1);

    private DynaProperty[] getDynaProperties() {
        return this.getDynaBean().getDynaClass().getDynaProperties();
    }

    private String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    private static class MapEntry<K>
    implements Map.Entry<K, Object> {
        private final K key;
        private final Object value;

        MapEntry(K key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o2;
            return this.key.equals(entry.getKey()) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() + (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

