/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaBeanPropertyMapDecorator;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

public class BasicDynaBean
implements Serializable,
DynaBean {
    protected DynaClass dynaClass = null;
    protected HashMap<String, Object> values = new HashMap();
    private transient Map<String, Object> mapDecorator;

    public BasicDynaBean(DynaClass dynaClass) {
        this.dynaClass = dynaClass;
    }

    public Map<String, Object> getMap() {
        if (this.mapDecorator == null) {
            this.mapDecorator = new DynaBeanPropertyMapDecorator(this);
        }
        return this.mapDecorator;
    }

    @Override
    public boolean contains(String name, String key) {
        Object object = this.values.get(name);
        if (object == null) {
            throw new NullPointerException("No mapped value for '" + name + "(" + key + ")'");
        }
        if (object instanceof Map) {
            return ((Map)object).containsKey(key);
        }
        throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'");
    }

    @Override
    public Object get(String name) {
        Object object = this.values.get(name);
        if (object != null) {
            return object;
        }
        Class<?> clazz = this.getDynaProperty(name).getType();
        if (!clazz.isPrimitive()) {
            return object;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        return null;
    }

    @Override
    public Object get(String name, int index) {
        Object object = this.values.get(name);
        if (object == null) {
            throw new NullPointerException("No indexed value for '" + name + "[" + index + "]'");
        }
        if (object.getClass().isArray()) {
            return Array.get(object, index);
        }
        if (object instanceof List) {
            return ((List)object).get(index);
        }
        throw new IllegalArgumentException("Non-indexed property for '" + name + "[" + index + "]'");
    }

    @Override
    public Object get(String name, String key) {
        Object object = this.values.get(name);
        if (object == null) {
            throw new NullPointerException("No mapped value for '" + name + "(" + key + ")'");
        }
        if (object instanceof Map) {
            return ((Map)object).get(key);
        }
        throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'");
    }

    @Override
    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    @Override
    public void remove(String name, String key) {
        Object object = this.values.get(name);
        if (object == null) {
            throw new NullPointerException("No mapped value for '" + name + "(" + key + ")'");
        }
        if (object instanceof Map) {
            ((Map)object).remove(key);
            return;
        }
        throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'");
    }

    @Override
    public void set(String name, Object value) {
        DynaProperty dynaProperty = this.getDynaProperty(name);
        if (value == null) {
            if (dynaProperty.getType().isPrimitive()) {
                throw new NullPointerException("Primitive value for '" + name + "'");
            }
        } else if (!this.isAssignable(dynaProperty.getType(), value.getClass())) {
            throw new ConversionException("Cannot assign value of type '" + value.getClass().getName() + "' to property '" + name + "' of type '" + dynaProperty.getType().getName() + "'");
        }
        this.values.put(name, value);
    }

    @Override
    public void set(String name, int index, Object value) {
        Object object = this.values.get(name);
        if (object == null) {
            throw new NullPointerException("No indexed value for '" + name + "[" + index + "]'");
        }
        if (object.getClass().isArray()) {
            Array.set(object, index, value);
            return;
        }
        if (object instanceof List) {
            try {
                List list = (List)object;
                list.set(index, value);
                return;
            }
            catch (ClassCastException classCastException) {
                throw new ConversionException(classCastException.getMessage());
            }
        }
        throw new IllegalArgumentException("Non-indexed property for '" + name + "[" + index + "]'");
    }

    @Override
    public void set(String name, String key, Object value) {
        Object object = this.values.get(name);
        if (object == null) {
            throw new NullPointerException("No mapped value for '" + name + "(" + key + ")'");
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            map.put(key, value);
            return;
        }
        throw new IllegalArgumentException("Non-mapped property for '" + name + "(" + key + ")'");
    }

    protected DynaProperty getDynaProperty(String name) {
        DynaProperty dynaProperty = this.getDynaClass().getDynaProperty(name);
        if (dynaProperty == null) {
            throw new IllegalArgumentException("Invalid property name '" + name + "'");
        }
        return dynaProperty;
    }

    protected boolean isAssignable(Class<?> dest, Class<?> source) {
        return dest.isAssignableFrom(source) || dest == Boolean.TYPE && source == Boolean.class || dest == Byte.TYPE && source == Byte.class || dest == Character.TYPE && source == Character.class || dest == Double.TYPE && source == Double.class || dest == Float.TYPE && source == Float.class || dest == Integer.TYPE && source == Integer.class || dest == Long.TYPE && source == Long.class || dest == Short.TYPE && source == Short.class;
    }
}

