/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.comparators.ComparableComparator;

public class BeanComparator<T>
implements Serializable,
Comparator<T> {
    private String property;
    private final Comparator<?> comparator;

    public BeanComparator() {
        this(null);
    }

    public BeanComparator(String property) {
        this(property, ComparableComparator.getInstance());
    }

    public BeanComparator(String property, Comparator<?> comparator) {
        this.setProperty(property);
        if (comparator != null) {
            this.comparator = comparator;
            return;
        }
        this.comparator = ComparableComparator.getInstance();
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getProperty() {
        return this.property;
    }

    public Comparator<?> getComparator() {
        return this.comparator;
    }

    @Override
    public int compare(T o1, T o2) {
        if (this.property == null) {
            return this.internalCompare(o1, o2);
        }
        try {
            Object object = PropertyUtils.getProperty(o1, this.property);
            Object object2 = PropertyUtils.getProperty(o2, this.property);
            return this.internalCompare(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("IllegalAccessException: " + illegalAccessException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("InvocationTargetException: " + invocationTargetException.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("NoSuchMethodException: " + noSuchMethodException.toString());
        }
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof BeanComparator)) {
            return false;
        }
        BeanComparator beanComparator = (BeanComparator)o2;
        if (!this.comparator.equals(beanComparator.comparator)) {
            return false;
        }
        if (this.property != null) {
            return this.property.equals(beanComparator.property);
        }
        return beanComparator.property == null;
    }

    public int hashCode() {
        int n2 = this.comparator.hashCode();
        return n2;
    }

    private int internalCompare(Object val1, Object val2) {
        Comparator<?> comparator = this.comparator;
        return comparator.compare(val1, val2);
    }
}

