/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanToPropertyValueTransformer
implements Transformer {
    private final Log log = LogFactory.getLog(this.getClass());
    private String propertyName;
    private boolean ignoreNull;

    public BeanToPropertyValueTransformer(String propertyName) {
        this(propertyName, false);
    }

    public BeanToPropertyValueTransformer(String propertyName, boolean ignoreNull) {
        if (propertyName != null && propertyName.length() > 0) {
            this.propertyName = propertyName;
            this.ignoreNull = ignoreNull;
            return;
        }
        throw new IllegalArgumentException("propertyName cannot be null or empty");
    }

    @Override
    public Object transform(Object object) {
        Object object2 = null;
        try {
            object2 = PropertyUtils.getProperty(object, this.propertyName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.ignoreNull) {
                this.log.warn("WARNING: Problem during transformation. Null value encountered in property path..." + illegalArgumentException);
            }
            IllegalArgumentException illegalArgumentException2 = new IllegalArgumentException("Problem during transformation. Null value encountered in property path...");
            if (!BeanUtils.initCause(illegalArgumentException2, illegalArgumentException)) {
                this.log.error("Problem during transformation. Null value encountered in property path...", illegalArgumentException);
            }
            throw illegalArgumentException2;
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unable to access the property provided.");
            if (!BeanUtils.initCause(illegalArgumentException, illegalAccessException)) {
                this.log.error("Unable to access the property provided.", illegalAccessException);
            }
            throw illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Exception occurred in property's getter");
            if (!BeanUtils.initCause(illegalArgumentException, invocationTargetException)) {
                this.log.error("Exception occurred in property's getter", invocationTargetException);
            }
            throw illegalArgumentException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = "No property found for name [" + this.propertyName + "]";
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            if (!BeanUtils.initCause(illegalArgumentException, noSuchMethodException)) {
                this.log.error(string, noSuchMethodException);
            }
            throw illegalArgumentException;
        }
        return object2;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }
}

