/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.util.Map;
import java.util.WeakHashMap;

public class ContextClassLoaderLocal<T> {
    private final Map<ClassLoader, T> valueByClassLoader = new WeakHashMap<ClassLoader, T>();
    private boolean globalValueInitialized = false;
    private T globalValue;

    protected T initialValue() {
        return null;
    }

    public synchronized T get() {
        this.valueByClassLoader.isEmpty();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                T t2 = this.valueByClassLoader.get(classLoader);
                if (t2 == null && !this.valueByClassLoader.containsKey(classLoader)) {
                    t2 = this.initialValue();
                    this.valueByClassLoader.put(classLoader, t2);
                }
                return t2;
            }
        }
        catch (SecurityException securityException) {}
        if (!this.globalValueInitialized) {
            this.globalValue = this.initialValue();
            this.globalValueInitialized = true;
        }
        return this.globalValue;
    }

    public synchronized void set(T value) {
        this.valueByClassLoader.isEmpty();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                this.valueByClassLoader.put(classLoader, value);
                return;
            }
        }
        catch (SecurityException securityException) {}
        this.globalValue = value;
        this.globalValueInitialized = true;
    }

    public synchronized void unset() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            this.unset(classLoader);
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
    }

    public synchronized void unset(ClassLoader classLoader) {
        this.valueByClassLoader.remove(classLoader);
    }
}

