/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Locale;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.IntrospectionContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FluentPropertyBeanIntrospector
implements BeanIntrospector {
    public static final String DEFAULT_WRITE_METHOD_PREFIX = "set";
    private final Log log = LogFactory.getLog(this.getClass());
    private final String writeMethodPrefix;

    public FluentPropertyBeanIntrospector(String writePrefix) {
        if (writePrefix == null) {
            throw new IllegalArgumentException("Prefix for write methods must not be null!");
        }
        this.writeMethodPrefix = writePrefix;
    }

    public FluentPropertyBeanIntrospector() {
        this(DEFAULT_WRITE_METHOD_PREFIX);
    }

    public String getWriteMethodPrefix() {
        return this.writeMethodPrefix;
    }

    @Override
    public void introspect(IntrospectionContext icontext) throws IntrospectionException {
        for (Method method : icontext.getTargetClass().getMethods()) {
            if (!method.getName().startsWith(this.getWriteMethodPrefix())) continue;
            String string = this.propertyName(method);
            PropertyDescriptor propertyDescriptor = icontext.getPropertyDescriptor(string);
            try {
                if (propertyDescriptor == null) {
                    icontext.addPropertyDescriptor(this.createFluentPropertyDescritor(method, string));
                    continue;
                }
                if (propertyDescriptor.getWriteMethod() != null) continue;
                propertyDescriptor.setWriteMethod(method);
            }
            catch (IntrospectionException introspectionException) {
                this.log.info("Error when creating PropertyDescriptor for " + method + "! Ignoring this property.");
                this.log.debug("Exception is:", introspectionException);
            }
        }
    }

    private String propertyName(Method m2) {
        String string = m2.getName().substring(this.getWriteMethodPrefix().length());
        if (string.length() > 1) {
            return Introspector.decapitalize(string);
        }
        return string.toLowerCase(Locale.ENGLISH);
    }

    private PropertyDescriptor createFluentPropertyDescritor(Method m2, String propertyName) throws IntrospectionException {
        return new PropertyDescriptor(this.propertyName(m2), null, m2);
    }
}

