/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.beanutils.ContextClassLoaderLocal;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.WrapDynaBean;

public class WrapDynaClass
implements DynaClass {
    private String beanClassName = null;
    private Reference<Class<?>> beanClassRef = null;
    private final PropertyUtilsBean propertyUtilsBean;
    @Deprecated
    protected Class<?> beanClass = null;
    protected PropertyDescriptor[] descriptors = null;
    protected HashMap<String, PropertyDescriptor> descriptorsMap = new HashMap();
    protected DynaProperty[] properties = null;
    protected HashMap<String, DynaProperty> propertiesMap = new HashMap();
    private static final ContextClassLoaderLocal<Map<CacheKey, WrapDynaClass>> CLASSLOADER_CACHE = new ContextClassLoaderLocal<Map<CacheKey, WrapDynaClass>>(){

        @Override
        protected final Map<CacheKey, WrapDynaClass> initialValue() {
            return new WeakHashMap<CacheKey, WrapDynaClass>();
        }
    };
    @Deprecated
    protected static HashMap<Object, Object> dynaClasses = new HashMap<Object, Object>(){

        @Override
        public final void clear() {
            WrapDynaClass.getDynaClassesMap().clear();
        }

        @Override
        public final boolean containsKey(Object key) {
            return WrapDynaClass.getDynaClassesMap().containsKey(key);
        }

        @Override
        public final boolean containsValue(Object value) {
            return WrapDynaClass.getDynaClassesMap().containsValue(value);
        }

        @Override
        public final Set<Map.Entry<Object, Object>> entrySet() {
            return WrapDynaClass.getDynaClassesMap().entrySet();
        }

        @Override
        public final boolean equals(Object o2) {
            return WrapDynaClass.getDynaClassesMap().equals(o2);
        }

        @Override
        public final Object get(Object key) {
            return WrapDynaClass.getDynaClassesMap().get(key);
        }

        @Override
        public final int hashCode() {
            return WrapDynaClass.getDynaClassesMap().hashCode();
        }

        @Override
        public final boolean isEmpty() {
            return WrapDynaClass.getDynaClassesMap().isEmpty();
        }

        @Override
        public final Set<Object> keySet() {
            HashSet<Object> hashSet = new HashSet<Object>();
            for (CacheKey cacheKey : WrapDynaClass.getClassesCache().keySet()) {
                hashSet.add(cacheKey.beanClass);
            }
            return hashSet;
        }

        @Override
        public final Object put(Object key, Object value) {
            return WrapDynaClass.getClassesCache().put(new CacheKey((Class)key, PropertyUtilsBean.getInstance()), (WrapDynaClass)value);
        }

        @Override
        public final void putAll(Map<? extends Object, ? extends Object> m2) {
            for (Map.Entry<? extends Object, ? extends Object> entry : m2.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public final Object remove(Object key) {
            return WrapDynaClass.getDynaClassesMap().remove(key);
        }

        @Override
        public final int size() {
            return WrapDynaClass.getDynaClassesMap().size();
        }

        @Override
        public final Collection<Object> values() {
            return WrapDynaClass.getDynaClassesMap().values();
        }
    };

    private WrapDynaClass(Class<?> beanClass, PropertyUtilsBean propUtils) {
        this.beanClassRef = new SoftReference(beanClass);
        this.beanClassName = beanClass.getName();
        this.propertyUtilsBean = propUtils;
        this.introspect();
    }

    private static Map<Object, Object> getDynaClassesMap() {
        Map<Object, Object> map = CLASSLOADER_CACHE.get();
        return map;
    }

    private static Map<CacheKey, WrapDynaClass> getClassesCache() {
        return CLASSLOADER_CACHE.get();
    }

    protected Class<?> getBeanClass() {
        return this.beanClassRef.get();
    }

    @Override
    public String getName() {
        return this.beanClassName;
    }

    @Override
    public DynaProperty getDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        return this.propertiesMap.get(name);
    }

    @Override
    public DynaProperty[] getDynaProperties() {
        return this.properties;
    }

    @Override
    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        return new WrapDynaBean(this.getBeanClass().newInstance());
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return this.descriptorsMap.get(name);
    }

    public static void clear() {
        WrapDynaClass.getClassesCache().clear();
    }

    public static WrapDynaClass createDynaClass(Class<?> beanClass) {
        return WrapDynaClass.createDynaClass(beanClass, null);
    }

    public static WrapDynaClass createDynaClass(Class<?> beanClass, PropertyUtilsBean pu) {
        PropertyUtilsBean propertyUtilsBean = pu != null ? pu : PropertyUtilsBean.getInstance();
        CacheKey cacheKey = new CacheKey(beanClass, propertyUtilsBean);
        WrapDynaClass wrapDynaClass = WrapDynaClass.getClassesCache().get(cacheKey);
        if (wrapDynaClass == null) {
            wrapDynaClass = new WrapDynaClass(beanClass, propertyUtilsBean);
            WrapDynaClass.getClassesCache().put(cacheKey, wrapDynaClass);
        }
        return wrapDynaClass;
    }

    protected PropertyUtilsBean getPropertyUtilsBean() {
        return this.propertyUtilsBean;
    }

    protected void introspect() {
        int n2;
        HashMap hashMap;
        Class<?> clazz = this.getBeanClass();
        PropertyDescriptor[] propertyDescriptorArray = this.getPropertyUtilsBean().getPropertyDescriptors(clazz);
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = new PropertyDescriptor[]{};
        }
        if ((hashMap = PropertyUtils.getMappedPropertyDescriptors(clazz)) == null) {
            hashMap = new HashMap();
        }
        this.properties = new DynaProperty[propertyDescriptorArray.length + hashMap.size()];
        for (n2 = 0; n2 < propertyDescriptorArray.length; ++n2) {
            this.descriptorsMap.put(propertyDescriptorArray[n2].getName(), propertyDescriptorArray[n2]);
            this.properties[n2] = new DynaProperty(propertyDescriptorArray[n2].getName(), propertyDescriptorArray[n2].getPropertyType());
            this.propertiesMap.put(this.properties[n2].getName(), this.properties[n2]);
        }
        n2 = propertyDescriptorArray.length;
        for (String string : hashMap.keySet()) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)hashMap.get(string);
            this.properties[n2] = new DynaProperty(propertyDescriptor.getName(), Map.class);
            this.propertiesMap.put(this.properties[n2].getName(), this.properties[n2]);
            ++n2;
        }
    }

    private static class CacheKey {
        private final Class<?> beanClass;
        private final PropertyUtilsBean propUtils;

        public CacheKey(Class<?> beanCls, PropertyUtilsBean pu) {
            this.beanClass = beanCls;
            this.propUtils = pu;
        }

        public int hashCode() {
            int n2 = 31 * this.beanClass.hashCode() + 17;
            n2 = 31 * this.propUtils.hashCode() + n2;
            return n2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)obj;
            return this.beanClass.equals(cacheKey.beanClass) && this.propUtils.equals(cacheKey.propUtils);
        }
    }
}

