/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.AbstractConverter;

public class ArrayConverter
extends AbstractConverter {
    private final Class<?> defaultType;
    private final Converter elementConverter;
    private int defaultSize;
    private char delimiter = (char)44;
    private char[] allowedChars = new char[]{'.', '-'};
    private boolean onlyFirstToString = true;

    public ArrayConverter(Class<?> defaultType, Converter elementConverter) {
        if (defaultType == null) {
            throw new IllegalArgumentException("Default type is missing");
        }
        if (!defaultType.isArray()) {
            throw new IllegalArgumentException("Default type must be an array.");
        }
        if (elementConverter == null) {
            throw new IllegalArgumentException("Component Converter is missing.");
        }
        this.defaultType = defaultType;
        this.elementConverter = elementConverter;
    }

    public ArrayConverter(Class<?> defaultType, Converter elementConverter, int defaultSize) {
        this(defaultType, elementConverter);
        this.defaultSize = defaultSize;
        Object object = null;
        if (defaultSize >= 0) {
            object = Array.newInstance(defaultType.getComponentType(), defaultSize);
        }
        this.setDefaultValue(object);
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public void setAllowedChars(char[] allowedChars) {
        this.allowedChars = allowedChars;
    }

    public void setOnlyFirstToString(boolean onlyFirstToString) {
        this.onlyFirstToString = onlyFirstToString;
    }

    @Override
    protected Class<?> getDefaultType() {
        return this.defaultType;
    }

    @Override
    protected String convertToString(Object value) throws Throwable {
        Object object;
        int size;
        Iterator<?> iterator = null;
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            size = Array.getLength(value);
        } else {
            object = this.convertToCollection(clazz, value);
            size = object.size();
            iterator = object.iterator();
        }
        if (size == 0) {
            return (String)this.getDefault(String.class);
        }
        if (this.onlyFirstToString) {
            size = 1;
        }
        object = new StringBuilder();
        for (int i2 = 0; i2 < size; ++i2) {
            if (i2 > 0) {
                ((StringBuilder)object).append(this.delimiter);
            }
            Object object2 = iterator == null ? Array.get(value, i2) : iterator.next();
            if ((object2 = this.elementConverter.convert(String.class, object2)) == null) continue;
            ((StringBuilder)object).append(object2);
        }
        return ((StringBuilder)object).toString();
    }

    @Override
    protected <T> T convertToType(Class<T> type, Object value) throws Throwable {
        Object object;
        int n2;
        if (!type.isArray()) {
            ArrayConverter arrayConverter = this;
            throw new ConversionException(arrayConverter.toString(arrayConverter.getClass()) + " cannot handle conversion to '" + this.toString(type) + "' (not an array).");
        }
        Iterator iterator = null;
        if (value.getClass().isArray()) {
            n2 = Array.getLength(value);
        } else {
            object = this.convertToCollection(type, value);
            n2 = object.size();
            iterator = object.iterator();
        }
        object = type.getComponentType();
        Object object2 = Array.newInstance(object, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object3 = iterator == null ? Array.get(value, i2) : iterator.next();
            object3 = this.elementConverter.convert(object, object3);
            Array.set(object2, i2, object3);
        }
        Object object4 = object2;
        return (T)object4;
    }

    @Override
    protected Object convertArray(Object value) {
        return value;
    }

    protected Collection<?> convertToCollection(Class<?> type, Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof Number || value instanceof Boolean || value instanceof Date) {
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(value);
            return arrayList;
        }
        return this.parseElements(type, value.toString());
    }

    @Override
    protected Object getDefault(Class<?> type) {
        if (type.equals(String.class)) {
            return null;
        }
        Object object = super.getDefault(type);
        if (object == null) {
            return null;
        }
        if (object.getClass().equals(type)) {
            return object;
        }
        return Array.newInstance(type.getComponentType(), this.defaultSize);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayConverter arrayConverter = this;
        stringBuilder.append(arrayConverter.toString(arrayConverter.getClass()));
        stringBuilder.append("[UseDefault=");
        stringBuilder.append(this.isUseDefault());
        stringBuilder.append(", ");
        stringBuilder.append(this.elementConverter.toString());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private List<String> parseElements(Class<?> type, String value) {
        if (this.log().isDebugEnabled()) {
            this.log().debug("Parsing elements, delimiter=[" + this.delimiter + "], value=[" + value + "]");
        }
        if ((value = value.trim()).startsWith("{") && value.endsWith("}")) {
            value = value.substring(1, value.length() - 1);
        }
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(value));
            streamTokenizer.whitespaceChars(this.delimiter, this.delimiter);
            streamTokenizer.ordinaryChars(48, 57);
            streamTokenizer.wordChars(48, 57);
            Object object = this.allowedChars;
            int n2 = this.allowedChars.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2;
                char c3 = c2 = object[i2];
                streamTokenizer.ordinaryChars(c3, c3);
                char c4 = c2;
                streamTokenizer.wordChars(c4, c4);
            }
            object = null;
            while ((n2 = streamTokenizer.nextToken()) == -3 || n2 > 0) {
                if (streamTokenizer.sval == null) continue;
                if (object == null) {
                    object = new ArrayList();
                }
                object.add(streamTokenizer.sval);
            }
            if (n2 != -1) {
                throw new ConversionException("Encountered token of type " + n2 + " parsing elements to '" + this.toString(type) + ".");
            }
            if (object == null) {
                object = Collections.emptyList();
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug(object.size() + " elements parsed");
            }
            return object;
        }
        catch (IOException iOException) {
            throw new ConversionException("Error converting from String to '" + this.toString(type) + "': " + iOException.getMessage(), iOException);
        }
    }
}

