/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.keyvalue.AbstractMapEntry;
import org.apache.commons.collections.list.UnmodifiableList;
import org.apache.commons.collections.set.UnmodifiableSet;

public class BeanMap
extends AbstractMap
implements Cloneable {
    private transient Object bean;
    private transient HashMap readMethods = new HashMap();
    private transient HashMap writeMethods = new HashMap();
    private transient HashMap types = new HashMap();
    public static final Object[] NULL_ARGUMENTS = new Object[0];
    public static HashMap defaultTransformers = new HashMap<Class<Boolean>, 1>();

    public BeanMap() {
    }

    public BeanMap(Object bean) {
        this.bean = bean;
        this.initialise();
    }

    public String toString() {
        return "BeanMap<" + String.valueOf(this.bean) + ">";
    }

    public Object clone() throws CloneNotSupportedException {
        Object obj;
        BeanMap beanMap = (BeanMap)super.clone();
        if (this.bean == null) {
            return beanMap;
        }
        Class<?> clazz = null;
        try {
            clazz = this.bean.getClass();
            obj = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new CloneNotSupportedException("Unable to instantiate the underlying bean \"" + clazz.getName() + "\": " + exception);
        }
        try {
            beanMap.setBean(obj);
        }
        catch (Exception exception) {
            throw new CloneNotSupportedException("Unable to set bean in the cloned bean map: " + exception);
        }
        try {
            Iterator iterator = this.readMethods.keySet().iterator();
            while (iterator.hasNext()) {
                Object k2 = iterator.next();
                if (this.getWriteMethod(k2) == null) continue;
                beanMap.put(k2, this.get(k2));
            }
        }
        catch (Exception exception) {
            throw new CloneNotSupportedException("Unable to copy bean values to cloned bean map: " + exception);
        }
        return beanMap;
    }

    public void putAllWriteable(BeanMap map) {
        Iterator iterator = map.readMethods.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            if (this.getWriteMethod(k2) == null) continue;
            this.put(k2, map.get(k2));
        }
    }

    public void clear() {
        if (this.bean == null) {
            return;
        }
        Class<?> clazz = null;
        try {
            clazz = this.bean.getClass();
            this.bean = clazz.newInstance();
            return;
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Could not create new instance of class: " + clazz);
        }
    }

    public boolean containsKey(Object name) {
        Method method = this.getReadMethod(name);
        return method != null;
    }

    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    public Object get(Object name) {
        Method method;
        if (this.bean != null && (method = this.getReadMethod(name)) != null) {
            try {
                return method.invoke(this.bean, NULL_ARGUMENTS);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.logWarn(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logWarn(illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.logWarn(invocationTargetException);
            }
            catch (NullPointerException nullPointerException) {
                this.logWarn(nullPointerException);
            }
        }
        return null;
    }

    public Object put(Object name, Object value) throws IllegalArgumentException, ClassCastException {
        if (this.bean != null) {
            Object object = this.get(name);
            Method method = this.getWriteMethod(name);
            if (method == null) {
                throw new IllegalArgumentException("The bean of type: " + this.bean.getClass().getName() + " has no property called: " + name);
            }
            try {
                Object[] objectArray = this.createWriteMethodArguments(method, value);
                method.invoke(this.bean, objectArray);
                Object object2 = this.get(name);
                this.firePropertyChange(name, object, object2);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.logInfo(invocationTargetException);
                throw new IllegalArgumentException(invocationTargetException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                this.logInfo(illegalAccessException);
                throw new IllegalArgumentException(illegalAccessException.getMessage());
            }
            return object;
        }
        return null;
    }

    public int size() {
        return this.readMethods.size();
    }

    public Set keySet() {
        return UnmodifiableSet.decorate(this.readMethods.keySet());
    }

    public Set entrySet() {
        return UnmodifiableSet.decorate(new AbstractSet(this){
            private final BeanMap this$0;
            {
                this.this$0 = beanMap;
            }

            public Iterator iterator() {
                return this.this$0.entryIterator();
            }

            public int size() {
                return BeanMap.access$000(this.this$0).size();
            }
        });
    }

    public Collection values() {
        ArrayList arrayList = new ArrayList(this.readMethods.size());
        Iterator iterator = this.valueIterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return UnmodifiableList.decorate(arrayList);
    }

    public Class getType(String name) {
        return (Class)this.types.get(name);
    }

    public Iterator keyIterator() {
        return this.readMethods.keySet().iterator();
    }

    public Iterator valueIterator() {
        Iterator iterator = this.keyIterator();
        return new Iterator(this, iterator){
            private final Iterator val$iter;
            private final BeanMap this$0;
            {
                this.this$0 = beanMap;
                this.val$iter = iterator;
            }

            public boolean hasNext() {
                return this.val$iter.hasNext();
            }

            public Object next() {
                Object e2 = this.val$iter.next();
                return this.this$0.get(e2);
            }

            public void remove() {
                throw new UnsupportedOperationException("remove() not supported for BeanMap");
            }
        };
    }

    public Iterator entryIterator() {
        Iterator iterator = this.keyIterator();
        return new Iterator(this, iterator){
            private final Iterator val$iter;
            private final BeanMap this$0;
            {
                this.this$0 = beanMap;
                this.val$iter = iterator;
            }

            public boolean hasNext() {
                return this.val$iter.hasNext();
            }

            public Object next() {
                Object e2 = this.val$iter.next();
                Object object = this.this$0.get(e2);
                return new MyMapEntry(this.this$0, e2, object);
            }

            public void remove() {
                throw new UnsupportedOperationException("remove() not supported for BeanMap");
            }
        };
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object newBean) {
        this.bean = newBean;
        this.reinitialise();
    }

    public Method getReadMethod(String name) {
        return (Method)this.readMethods.get(name);
    }

    public Method getWriteMethod(String name) {
        return (Method)this.writeMethods.get(name);
    }

    protected Method getReadMethod(Object name) {
        return (Method)this.readMethods.get(name);
    }

    protected Method getWriteMethod(Object name) {
        return (Method)this.writeMethods.get(name);
    }

    protected void reinitialise() {
        this.readMethods.clear();
        this.writeMethods.clear();
        this.types.clear();
        this.initialise();
    }

    private void initialise() {
        if (this.getBean() == null) {
            return;
        }
        Class<?> clazz = this.getBean().getClass();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            if (propertyDescriptorArray != null) {
                for (int i2 = 0; i2 < propertyDescriptorArray.length; ++i2) {
                    PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i2];
                    if (propertyDescriptor == null) continue;
                    String string = propertyDescriptor.getName();
                    Method method = propertyDescriptor.getReadMethod();
                    Method method2 = propertyDescriptor.getWriteMethod();
                    Class<?> clazz2 = propertyDescriptor.getPropertyType();
                    if (method != null) {
                        this.readMethods.put(string, method);
                    }
                    if (method2 != null) {
                        this.writeMethods.put(string, method2);
                    }
                    this.types.put(string, clazz2);
                }
            }
            return;
        }
        catch (IntrospectionException introspectionException) {
            this.logWarn(introspectionException);
            return;
        }
    }

    protected void firePropertyChange(Object key, Object oldValue, Object newValue) {
    }

    protected Object[] createWriteMethodArguments(Method method, Object value) throws IllegalAccessException, ClassCastException {
        try {
            Object object;
            Object[] objectArray;
            if (value != null && (objectArray = method.getParameterTypes()) != null && objectArray.length > 0 && !((Class)(object = objectArray[0])).isAssignableFrom(value.getClass())) {
                value = this.convertType((Class)object, value);
            }
            objectArray = new Object[]{value};
            return objectArray;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.logInfo(invocationTargetException);
            throw new IllegalArgumentException(invocationTargetException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            this.logInfo(instantiationException);
            throw new IllegalArgumentException(instantiationException.getMessage());
        }
    }

    protected Object convertType(Class newType, Object value) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class[] classArray = new Class[]{value.getClass()};
        try {
            Constructor constructor = newType.getConstructor(classArray);
            Object[] objectArray = new Object[]{value};
            return constructor.newInstance(objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Transformer transformer = this.getTypeTransformer(newType);
            if (transformer != null) {
                return transformer.transform(value);
            }
            return value;
        }
    }

    protected Transformer getTypeTransformer(Class aType) {
        return (Transformer)defaultTransformers.get(aType);
    }

    protected void logInfo(Exception ex) {
        System.out.println("INFO: Exception: " + ex);
    }

    protected void logWarn(Exception ex) {
        System.out.println("WARN: Exception: " + ex);
        ex.printStackTrace();
    }

    static HashMap access$000(BeanMap x0) {
        return x0.readMethods;
    }

    static {
        defaultTransformers.put(Boolean.TYPE, new Transformer(){

            public final Object transform(Object input) {
                return Boolean.valueOf(input.toString());
            }
        });
        defaultTransformers.put(Character.TYPE, new Transformer(){

            public final Object transform(Object input) {
                return new Character(input.toString().charAt(0));
            }
        });
        defaultTransformers.put(Byte.TYPE, new Transformer(){

            public final Object transform(Object input) {
                return Byte.valueOf(input.toString());
            }
        });
        defaultTransformers.put(Short.TYPE, new Transformer(){

            public final Object transform(Object input) {
                return Short.valueOf(input.toString());
            }
        });
        defaultTransformers.put(Integer.TYPE, new Transformer(){

            public final Object transform(Object input) {
                return Integer.valueOf(input.toString());
            }
        });
        defaultTransformers.put(Long.TYPE, new Transformer(){

            public final Object transform(Object input) {
                return Long.valueOf(input.toString());
            }
        });
        defaultTransformers.put(Float.TYPE, new Transformer(){

            public final Object transform(Object input) {
                return Float.valueOf(input.toString());
            }
        });
        defaultTransformers.put(Double.TYPE, new Transformer(){

            public final Object transform(Object input) {
                return Double.valueOf(input.toString());
            }
        });
    }

    protected static class MyMapEntry
    extends AbstractMapEntry {
        private BeanMap owner;

        protected MyMapEntry(BeanMap owner, Object key, Object value) {
            super(key, value);
            this.owner = owner;
        }

        public Object setValue(Object value) {
            Object object = this.getKey();
            Object object2 = this.owner.get(object);
            this.owner.put(object, value);
            Object object3 = this.owner.get(object);
            super.setValue(object3);
            return object2;
        }
    }
}

