/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import org.apache.commons.collections.SequencedHashMap;

public class LRUMap
extends SequencedHashMap
implements Externalizable {
    private int maximumSize = 0;
    private static final long serialVersionUID = 2197433140769957051L;

    public LRUMap() {
        this(100);
    }

    public LRUMap(int i2) {
        super(i2);
        this.maximumSize = i2;
    }

    public Object get(Object key) {
        if (!this.containsKey(key)) {
            return null;
        }
        Object object = this.remove(key);
        super.put(key, object);
        return object;
    }

    public Object put(Object key, Object value) {
        int n2 = this.size();
        if (n2 >= this.maximumSize && !this.containsKey(key)) {
            this.removeLRU();
        }
        Object object = super.put(key, value);
        return object;
    }

    protected void removeLRU() {
        Object object = this.getFirstKey();
        Object object2 = super.get(object);
        this.remove(object);
        this.processRemovedLRU(object, object2);
    }

    protected void processRemovedLRU(Object key, Object value) {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.maximumSize = in.readInt();
        int n2 = in.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = in.readObject();
            Object object2 = in.readObject();
            this.put(object, object2);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.maximumSize);
        out.writeInt(this.size());
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            out.writeObject(e2);
            Object object = super.get(e2);
            out.writeObject(object);
        }
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
        while (this.size() > maximumSize) {
            this.removeLRU();
        }
    }
}

