/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;

public class ReferenceMap
extends AbstractMap {
    private static final long serialVersionUID = -3370601314380922368L;
    public static final int HARD = 0;
    public static final int SOFT = 1;
    public static final int WEAK = 2;
    private int keyType;
    private int valueType;
    private float loadFactor;
    private boolean purgeValues = false;
    private transient ReferenceQueue queue = new ReferenceQueue();
    private transient Entry[] table;
    private transient int size;
    private transient int threshold;
    private volatile transient int modCount;
    private transient Set keySet;
    private transient Set entrySet;
    private transient Collection values;

    public ReferenceMap() {
        this(0, 1);
    }

    public ReferenceMap(int keyType, int valueType, boolean purgeValues) {
        this(keyType, valueType);
        this.purgeValues = purgeValues;
    }

    public ReferenceMap(int keyType, int valueType) {
        this(keyType, valueType, 16, 0.75f);
    }

    public ReferenceMap(int keyType, int valueType, int capacity, float loadFactor, boolean purgeValues) {
        this(keyType, valueType, capacity, loadFactor);
        this.purgeValues = purgeValues;
    }

    public ReferenceMap(int keyType, int valueType, int capacity, float loadFactor) {
        int n2;
        ReferenceMap.verify("keyType", keyType);
        ReferenceMap.verify("valueType", valueType);
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be positive");
        }
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and less than 1.");
        }
        this.keyType = keyType;
        this.valueType = valueType;
        for (n2 = 1; n2 < capacity; n2 <<= 1) {
        }
        this.table = new Entry[n2];
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)n2 * loadFactor);
    }

    private static void verify(String name, int type) {
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException(name + " must be HARD, SOFT, WEAK.");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.table.length);
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeObject(null);
    }

    private void readObject(ObjectInputStream inp) throws IOException, ClassNotFoundException {
        inp.defaultReadObject();
        this.table = new Entry[inp.readInt()];
        this.threshold = (int)((float)this.table.length * this.loadFactor);
        this.queue = new ReferenceQueue();
        Object object = inp.readObject();
        while (object != null) {
            Object object2 = inp.readObject();
            this.put(object, object2);
            object = inp.readObject();
        }
    }

    private Object toReference(int type, Object referent, int hash) {
        switch (type) {
            case 0: {
                return referent;
            }
            case 1: {
                return new SoftRef(hash, referent, this.queue);
            }
            case 2: {
                return new WeakRef(hash, referent, this.queue);
            }
        }
        throw new Error();
    }

    private Entry getEntry(Object key) {
        if (key == null) {
            return null;
        }
        int n2 = key.hashCode();
        int n3 = this.indexFor(n2);
        Entry entry = this.table[n3];
        while (entry != null) {
            if (entry.hash == n2 && key.equals(entry.getKey())) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    private int indexFor(int hash) {
        int n2 = hash;
        hash = n2 + ~(n2 << 15);
        hash ^= hash >>> 10;
        hash += hash << 3;
        hash ^= hash >>> 6;
        hash += ~(hash << 11);
        hash ^= hash >>> 16;
        return hash & this.table.length - 1;
    }

    private void resize() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length << 1];
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            Entry entry = entryArray[i2];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n2 = this.indexFor(entry2.hash);
                entry2.next = this.table[n2];
                this.table[n2] = entry2;
            }
            entryArray[i2] = null;
        }
        this.threshold = (int)((float)this.table.length * this.loadFactor);
    }

    private void purge() {
        Reference reference = this.queue.poll();
        while (reference != null) {
            this.purge(reference);
            reference = this.queue.poll();
        }
    }

    private void purge(Reference ref) {
        int n2 = ref.hashCode();
        int n3 = this.indexFor(n2);
        Entry entry = null;
        Entry entry2 = this.table[n3];
        while (entry2 != null) {
            if (entry2.purge(ref)) {
                if (entry == null) {
                    this.table[n3] = entry2.next;
                } else {
                    entry.next = entry2.next;
                }
                --this.size;
                return;
            }
            entry = entry2;
            entry2 = entry2.next;
        }
    }

    public int size() {
        this.purge();
        return this.size;
    }

    public boolean isEmpty() {
        this.purge();
        return this.size == 0;
    }

    public boolean containsKey(Object key) {
        this.purge();
        Entry entry = this.getEntry(key);
        if (entry == null) {
            return false;
        }
        return entry.getValue() != null;
    }

    public Object get(Object key) {
        this.purge();
        Entry entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("null keys not allowed");
        }
        if (value == null) {
            throw new NullPointerException("null values not allowed");
        }
        this.purge();
        if (this.size + 1 > this.threshold) {
            this.resize();
        }
        int n2 = key.hashCode();
        int n3 = this.indexFor(n2);
        Entry entry = this.table[n3];
        while (entry != null) {
            if (n2 == entry.hash && key.equals(entry.getKey())) {
                Object object = entry.getValue();
                entry.setValue(value);
                return object;
            }
            entry = entry.next;
        }
        ++this.size;
        ++this.modCount;
        ReferenceMap referenceMap = this;
        key = referenceMap.toReference(referenceMap.keyType, key, n2);
        ReferenceMap referenceMap2 = this;
        value = referenceMap2.toReference(referenceMap2.valueType, value, n2);
        this.table[n3] = new Entry(this, key, n2, value, this.table[n3]);
        return null;
    }

    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        this.purge();
        int n2 = key.hashCode();
        int n3 = this.indexFor(n2);
        Entry entry = null;
        Entry entry2 = this.table[n3];
        while (entry2 != null) {
            if (n2 == entry2.hash && key.equals(entry2.getKey())) {
                if (entry == null) {
                    this.table[n3] = entry2.next;
                } else {
                    entry.next = entry2.next;
                }
                --this.size;
                ++this.modCount;
                return entry2.getValue();
            }
            entry = entry2;
            entry2 = entry2.next;
        }
        return null;
    }

    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    public Set entrySet() {
        if (this.entrySet != null) {
            return this.entrySet;
        }
        this.entrySet = new AbstractSet(this){
            private final ReferenceMap this$0;
            {
                this.this$0 = referenceMap;
            }

            public int size() {
                return this.this$0.size();
            }

            public void clear() {
                this.this$0.clear();
            }

            public boolean contains(Object o2) {
                if (o2 == null) {
                    return false;
                }
                if (!(o2 instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o2;
                Entry entry2 = ReferenceMap.access$000(this.this$0, entry.getKey());
                return entry2 != null && entry.equals(entry2);
            }

            public boolean remove(Object o2) {
                boolean bl = this.contains(o2);
                if (bl) {
                    Map.Entry entry = (Map.Entry)o2;
                    this.this$0.remove(entry.getKey());
                }
                return bl;
            }

            public Iterator iterator() {
                return new EntryIterator(this.this$0);
            }

            public Object[] toArray() {
                return this.toArray(new Object[0]);
            }

            public Object[] toArray(Object[] arr) {
                ArrayList<DefaultMapEntry> arrayList = new ArrayList<DefaultMapEntry>();
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    Entry entry = (Entry)iterator.next();
                    arrayList.add(new DefaultMapEntry(entry.getKey(), entry.getValue()));
                }
                return arrayList.toArray(arr);
            }
        };
        return this.entrySet;
    }

    public Set keySet() {
        if (this.keySet != null) {
            return this.keySet;
        }
        this.keySet = new AbstractSet(this){
            private final ReferenceMap this$0;
            {
                this.this$0 = referenceMap;
            }

            public int size() {
                return this.this$0.size();
            }

            public Iterator iterator() {
                return new KeyIterator(this.this$0, null);
            }

            public boolean contains(Object o2) {
                return this.this$0.containsKey(o2);
            }

            public boolean remove(Object o2) {
                Object object = this.this$0.remove(o2);
                return object != null;
            }

            public void clear() {
                this.this$0.clear();
            }

            public Object[] toArray() {
                return this.toArray(new Object[0]);
            }

            public Object[] toArray(Object[] array) {
                ArrayList arrayList = new ArrayList(this.size());
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                return arrayList.toArray(array);
            }
        };
        return this.keySet;
    }

    public Collection values() {
        if (this.values != null) {
            return this.values;
        }
        this.values = new AbstractCollection(this){
            private final ReferenceMap this$0;
            {
                this.this$0 = referenceMap;
            }

            public int size() {
                return this.this$0.size();
            }

            public void clear() {
                this.this$0.clear();
            }

            public Iterator iterator() {
                return new ValueIterator(this.this$0, null);
            }

            public Object[] toArray() {
                return this.toArray(new Object[0]);
            }

            public Object[] toArray(Object[] array) {
                ArrayList arrayList = new ArrayList(this.size());
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                return arrayList.toArray(array);
            }
        };
        return this.values;
    }

    static Entry access$000(ReferenceMap x0, Object x1) {
        return x0.getEntry(x1);
    }

    static int access$300(ReferenceMap x0) {
        return x0.keyType;
    }

    static int access$400(ReferenceMap x0) {
        return x0.valueType;
    }

    static Object access$500(ReferenceMap x0, int x1, Object x2, int x3) {
        return x0.toReference(x1, x2, x3);
    }

    static boolean access$600(ReferenceMap x0) {
        return x0.purgeValues;
    }

    static Entry[] access$700(ReferenceMap x0) {
        return x0.table;
    }

    static int access$800(ReferenceMap x0) {
        return x0.modCount;
    }

    private static class WeakRef
    extends WeakReference {
        private int hash;

        public WeakRef(int hash, Object r2, ReferenceQueue q2) {
            super(r2, q2);
            this.hash = hash;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class SoftRef
    extends SoftReference {
        private int hash;

        public SoftRef(int hash, Object r2, ReferenceQueue q2) {
            super(r2, q2);
            this.hash = hash;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private class KeyIterator
    extends EntryIterator {
        private final ReferenceMap this$0;

        private KeyIterator(ReferenceMap referenceMap) {
            super(referenceMap);
            this.this$0 = referenceMap;
        }

        public Object next() {
            return this.nextEntry().getKey();
        }

        KeyIterator(ReferenceMap x0, 1 x1) {
            this(x0);
        }
    }

    private class ValueIterator
    extends EntryIterator {
        private final ReferenceMap this$0;

        private ValueIterator(ReferenceMap referenceMap) {
            super(referenceMap);
            this.this$0 = referenceMap;
        }

        public Object next() {
            return this.nextEntry().getValue();
        }

        ValueIterator(ReferenceMap x0, 1 x1) {
            this(x0);
        }
    }

    private class EntryIterator
    implements Iterator {
        int index;
        Entry entry;
        Entry previous;
        Object nextKey;
        Object nextValue;
        Object currentKey;
        Object currentValue;
        int expectedModCount;
        private final ReferenceMap this$0;

        public EntryIterator(ReferenceMap referenceMap) {
            this.this$0 = referenceMap;
            this.index = referenceMap.size() != 0 ? ReferenceMap.access$700(referenceMap).length : 0;
            this.expectedModCount = ReferenceMap.access$800(referenceMap);
        }

        public boolean hasNext() {
            this.checkMod();
            while (this.nextNull()) {
                Entry entry = this.entry;
                int n2 = this.index;
                while (entry == null && n2 > 0) {
                    entry = ReferenceMap.access$700(this.this$0)[--n2];
                }
                this.entry = entry;
                this.index = n2;
                if (entry == null) {
                    this.currentKey = null;
                    this.currentValue = null;
                    return false;
                }
                this.nextKey = entry.getKey();
                this.nextValue = entry.getValue();
                if (!this.nextNull()) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        private void checkMod() {
            if (ReferenceMap.access$800(this.this$0) != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        private boolean nextNull() {
            return this.nextKey == null || this.nextValue == null;
        }

        protected Entry nextEntry() {
            this.checkMod();
            if (this.nextNull() && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.previous = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.currentValue = this.nextValue;
            this.nextKey = null;
            this.nextValue = null;
            return this.previous;
        }

        public Object next() {
            return this.nextEntry();
        }

        public void remove() {
            this.checkMod();
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            this.this$0.remove(this.currentKey);
            this.previous = null;
            this.currentKey = null;
            this.currentValue = null;
            this.expectedModCount = ReferenceMap.access$800(this.this$0);
        }
    }

    private class Entry
    implements Map.Entry,
    KeyValue {
        Object key;
        Object value;
        int hash;
        Entry next;
        private final ReferenceMap this$0;

        public Entry(ReferenceMap referenceMap, Object key, int hash, Object value, Entry next) {
            this.this$0 = referenceMap;
            this.key = key;
            this.hash = hash;
            this.value = value;
            this.next = next;
        }

        public Object getKey() {
            if (ReferenceMap.access$300(this.this$0) > 0) {
                return ((Reference)this.key).get();
            }
            return this.key;
        }

        public Object getValue() {
            if (ReferenceMap.access$400(this.this$0) > 0) {
                return ((Reference)this.value).get();
            }
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.getValue();
            if (ReferenceMap.access$400(this.this$0) > 0) {
                ((Reference)this.value).clear();
            }
            this.value = ReferenceMap.access$500(this.this$0, ReferenceMap.access$400(this.this$0), object, this.hash);
            return object2;
        }

        public boolean equals(Object o2) {
            if (o2 == null) {
                return false;
            }
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o2;
            Object k2 = entry.getKey();
            Object v2 = entry.getValue();
            if (k2 == null || v2 == null) {
                return false;
            }
            return k2.equals(this.getKey()) && v2.equals(this.getValue());
        }

        public int hashCode() {
            Object object = this.getValue();
            return this.hash ^ (object == null ? 0 : object.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        boolean purge(Reference ref) {
            boolean bl = ReferenceMap.access$300(this.this$0) > 0 && this.key == ref;
            if (bl = bl || ReferenceMap.access$400(this.this$0) > 0 && this.value == ref) {
                if (ReferenceMap.access$300(this.this$0) > 0) {
                    ((Reference)this.key).clear();
                }
                if (ReferenceMap.access$400(this.this$0) > 0) {
                    ((Reference)this.value).clear();
                } else if (ReferenceMap.access$600(this.this$0)) {
                    this.value = null;
                }
            }
            return bl;
        }
    }
}

