/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;

public class UnboundedFifoBuffer
extends AbstractCollection
implements Buffer {
    protected Object[] m_buffer;
    protected int m_head;
    protected int m_tail;

    public UnboundedFifoBuffer() {
        this(32);
    }

    public UnboundedFifoBuffer(int initialSize) {
        if (initialSize <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.m_buffer = new Object[initialSize + 1];
        this.m_head = 0;
        this.m_tail = 0;
    }

    public int size() {
        int n2 = this.m_tail < this.m_head ? this.m_buffer.length - this.m_head + this.m_tail : this.m_tail - this.m_head;
        return n2;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean add(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Attempted to add null object to buffer");
        }
        if (this.size() + 1 >= this.m_buffer.length) {
            Object[] objectArray = new Object[(this.m_buffer.length - 1 << 1) + 1];
            int n2 = 0;
            int n3 = this.m_head;
            while (n3 != this.m_tail) {
                objectArray[n2] = this.m_buffer[n3];
                this.m_buffer[n3] = null;
                ++n2;
                if (++n3 != this.m_buffer.length) continue;
                n3 = 0;
            }
            this.m_buffer = objectArray;
            this.m_head = 0;
            this.m_tail = n2;
        }
        this.m_buffer[this.m_tail] = obj;
        ++this.m_tail;
        if (this.m_tail >= this.m_buffer.length) {
            this.m_tail = 0;
        }
        return true;
    }

    public Object get() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        return this.m_buffer[this.m_head];
    }

    public Object remove() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        Object object = this.m_buffer[this.m_head];
        if (object != null) {
            this.m_buffer[this.m_head] = null;
            ++this.m_head;
            if (this.m_head >= this.m_buffer.length) {
                this.m_head = 0;
            }
        }
        return object;
    }

    private int increment(int index) {
        if (++index >= this.m_buffer.length) {
            index = 0;
        }
        return index;
    }

    private int decrement(int index) {
        if (--index < 0) {
            index = this.m_buffer.length - 1;
        }
        return index;
    }

    public Iterator iterator() {
        return new Iterator(this){
            private int index;
            private int lastReturnedIndex;
            private final UnboundedFifoBuffer this$0;
            {
                this.this$0 = unboundedFifoBuffer;
                this.index = this.this$0.m_head;
                this.lastReturnedIndex = -1;
            }

            public boolean hasNext() {
                return this.index != this.this$0.m_tail;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturnedIndex = this.index;
                this.index = UnboundedFifoBuffer.access$000(this.this$0, this.index);
                return this.this$0.m_buffer[this.lastReturnedIndex];
            }

            public void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                if (this.lastReturnedIndex == this.this$0.m_head) {
                    this.this$0.remove();
                    this.lastReturnedIndex = -1;
                    return;
                }
                int n2 = UnboundedFifoBuffer.access$000(this.this$0, this.lastReturnedIndex);
                while (n2 != this.this$0.m_tail) {
                    this.this$0.m_buffer[UnboundedFifoBuffer.access$100((UnboundedFifoBuffer)this.this$0, (int)n2)] = this.this$0.m_buffer[n2];
                    n2 = UnboundedFifoBuffer.access$000(this.this$0, n2);
                }
                this.lastReturnedIndex = -1;
                this.this$0.m_tail = UnboundedFifoBuffer.access$100(this.this$0, this.this$0.m_tail);
                this.this$0.m_buffer[this.this$0.m_tail] = null;
                this.index = UnboundedFifoBuffer.access$100(this.this$0, this.index);
            }
        };
    }

    static int access$000(UnboundedFifoBuffer x0, int x1) {
        return x0.increment(x1);
    }

    static int access$100(UnboundedFifoBuffer x0, int x1) {
        return x0.decrement(x1);
    }
}

