/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.comparators;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FixedOrderComparator
implements Comparator {
    public static final int UNKNOWN_BEFORE = 0;
    public static final int UNKNOWN_AFTER = 1;
    public static final int UNKNOWN_THROW_EXCEPTION = 2;
    private final Map map = new HashMap();
    private int counter = 0;
    private boolean isLocked = false;
    private int unknownObjectBehavior = 2;

    public FixedOrderComparator() {
    }

    public FixedOrderComparator(Object[] items) {
        if (items == null) {
            throw new IllegalArgumentException("The list of items must not be null");
        }
        for (int i2 = 0; i2 < items.length; ++i2) {
            this.add(items[i2]);
        }
    }

    public FixedOrderComparator(List items) {
        if (items == null) {
            throw new IllegalArgumentException("The list of items must not be null");
        }
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    protected void checkLocked() {
        if (this.isLocked()) {
            throw new UnsupportedOperationException("Cannot modify a FixedOrderComparator after a comparison");
        }
    }

    public int getUnknownObjectBehavior() {
        return this.unknownObjectBehavior;
    }

    public void setUnknownObjectBehavior(int unknownObjectBehavior) {
        this.checkLocked();
        if (unknownObjectBehavior != 1 && unknownObjectBehavior != 0 && unknownObjectBehavior != 2) {
            throw new IllegalArgumentException("Unrecognised value for unknown behaviour flag");
        }
        this.unknownObjectBehavior = unknownObjectBehavior;
    }

    public boolean add(Object obj) {
        this.checkLocked();
        Integer n2 = this.map.put(obj, new Integer(this.counter++));
        return n2 == null;
    }

    public boolean addAsEqual(Object existingObj, Object newObj) {
        this.checkLocked();
        Integer n2 = (Integer)this.map.get(existingObj);
        if (n2 == null) {
            throw new IllegalArgumentException(existingObj + " not known to " + this);
        }
        Integer n3 = this.map.put(newObj, n2);
        return n3 == null;
    }

    public int compare(Object obj1, Object obj2) {
        this.isLocked = true;
        Integer n2 = (Integer)this.map.get(obj1);
        Integer n3 = (Integer)this.map.get(obj2);
        if (n2 == null || n3 == null) {
            switch (this.unknownObjectBehavior) {
                case 0: {
                    if (n2 == null) {
                        if (n3 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    return 1;
                }
                case 1: {
                    if (n2 == null) {
                        if (n3 == null) {
                            return 0;
                        }
                        return 1;
                    }
                    return -1;
                }
                case 2: {
                    Object object = n2 == null ? obj1 : obj2;
                    throw new IllegalArgumentException("Attempting to compare unknown object " + object);
                }
            }
            throw new UnsupportedOperationException("Unknown unknownObjectBehavior: " + this.unknownObjectBehavior);
        }
        return n2.compareTo(n3);
    }
}

