/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.FalsePredicate;
import org.apache.commons.collections.functors.FunctorUtils;
import org.apache.commons.collections.functors.PredicateDecorator;

public final class AnyPredicate
implements Serializable,
Predicate,
PredicateDecorator {
    private static final long serialVersionUID = 7429999530934647542L;
    private final Predicate[] iPredicates;

    public static Predicate getInstance(Predicate[] predicates) {
        FunctorUtils.validate(predicates);
        if (predicates.length == 0) {
            return FalsePredicate.INSTANCE;
        }
        if (predicates.length == 1) {
            return predicates[0];
        }
        return new AnyPredicate(FunctorUtils.copy(predicates));
    }

    public static Predicate getInstance(Collection predicates) {
        Predicate[] predicateArray = FunctorUtils.validate(predicates);
        if (predicateArray.length == 0) {
            return FalsePredicate.INSTANCE;
        }
        if (predicateArray.length == 1) {
            return predicateArray[0];
        }
        return new AnyPredicate(predicateArray);
    }

    public AnyPredicate(Predicate[] predicates) {
        this.iPredicates = predicates;
    }

    public final boolean evaluate(Object object) {
        for (int i2 = 0; i2 < this.iPredicates.length; ++i2) {
            if (!this.iPredicates[i2].evaluate(object)) continue;
            return true;
        }
        return false;
    }

    public final Predicate[] getPredicates() {
        return this.iPredicates;
    }
}

