/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.FunctorException;
import org.apache.commons.collections.functors.ConstantFactory;
import org.apache.commons.collections.functors.FunctorUtils;
import org.apache.commons.collections.functors.InstantiateFactory;

public class PrototypeFactory {
    static Class class$org$apache$commons$collections$functors$PrototypeFactory$PrototypeCloneFactory;
    static Class class$org$apache$commons$collections$functors$PrototypeFactory$PrototypeSerializationFactory;

    public static Factory getInstance(Object prototype) {
        if (prototype == null) {
            return ConstantFactory.NULL_INSTANCE;
        }
        try {
            Method method = prototype.getClass().getMethod("clone", null);
            return new PrototypeCloneFactory(prototype, method, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                prototype.getClass().getConstructor(prototype.getClass());
                return new InstantiateFactory(prototype.getClass(), new Class[]{prototype.getClass()}, new Object[]{prototype});
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                if (prototype instanceof Serializable) {
                    return new PrototypeSerializationFactory((Serializable)prototype, null);
                }
                throw new IllegalArgumentException("The prototype must be cloneable via a public clone method");
            }
        }
    }

    private PrototypeFactory() {
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class 1 {
    }

    static class PrototypeSerializationFactory
    implements Serializable,
    Factory {
        private static final long serialVersionUID = -8704966966139178833L;
        private final Serializable iPrototype;

        private PrototypeSerializationFactory(Serializable prototype) {
            this.iPrototype = prototype;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object create() {
            Object object;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(this.iPrototype);
                byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                object = objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    throw new FunctorException(classNotFoundException);
                    catch (IOException iOException) {
                        throw new FunctorException(iOException);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (byteArrayInputStream != null) {
                            byteArrayInputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        byteArrayOutputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                byteArrayOutputStream.close();
                return object;
            }
            catch (IOException iOException) {}
            return object;
        }

        private void writeObject(ObjectOutputStream os) throws IOException {
            FunctorUtils.checkUnsafeSerialization(class$org$apache$commons$collections$functors$PrototypeFactory$PrototypeSerializationFactory == null ? (class$org$apache$commons$collections$functors$PrototypeFactory$PrototypeSerializationFactory = PrototypeFactory.class$("org.apache.commons.collections.functors.PrototypeFactory$PrototypeSerializationFactory")) : class$org$apache$commons$collections$functors$PrototypeFactory$PrototypeSerializationFactory);
            os.defaultWriteObject();
        }

        private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
            FunctorUtils.checkUnsafeSerialization(class$org$apache$commons$collections$functors$PrototypeFactory$PrototypeSerializationFactory == null ? (class$org$apache$commons$collections$functors$PrototypeFactory$PrototypeSerializationFactory = PrototypeFactory.class$("org.apache.commons.collections.functors.PrototypeFactory$PrototypeSerializationFactory")) : class$org$apache$commons$collections$functors$PrototypeFactory$PrototypeSerializationFactory);
            is.defaultReadObject();
        }

        PrototypeSerializationFactory(Serializable x0, 1 x1) {
            this(x0);
        }
    }

    static class PrototypeCloneFactory
    implements Serializable,
    Factory {
        private static final long serialVersionUID = 5604271422565175555L;
        private final Object iPrototype;
        private transient Method iCloneMethod;

        private PrototypeCloneFactory(Object prototype, Method method) {
            this.iPrototype = prototype;
            this.iCloneMethod = method;
        }

        private void findCloneMethod() {
            try {
                this.iCloneMethod = this.iPrototype.getClass().getMethod("clone", null);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException("PrototypeCloneFactory: The clone method must exist and be public ");
            }
        }

        public Object create() {
            if (this.iCloneMethod == null) {
                this.findCloneMethod();
            }
            try {
                return this.iCloneMethod.invoke(this.iPrototype, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new FunctorException("PrototypeCloneFactory: Clone method must be public", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new FunctorException("PrototypeCloneFactory: Clone method threw an exception", invocationTargetException);
            }
        }

        private void writeObject(ObjectOutputStream os) throws IOException {
            FunctorUtils.checkUnsafeSerialization(class$org$apache$commons$collections$functors$PrototypeFactory$PrototypeCloneFactory == null ? (class$org$apache$commons$collections$functors$PrototypeFactory$PrototypeCloneFactory = PrototypeFactory.class$("org.apache.commons.collections.functors.PrototypeFactory$PrototypeCloneFactory")) : class$org$apache$commons$collections$functors$PrototypeFactory$PrototypeCloneFactory);
            os.defaultWriteObject();
        }

        private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
            FunctorUtils.checkUnsafeSerialization(class$org$apache$commons$collections$functors$PrototypeFactory$PrototypeCloneFactory == null ? (class$org$apache$commons$collections$functors$PrototypeFactory$PrototypeCloneFactory = PrototypeFactory.class$("org.apache.commons.collections.functors.PrototypeFactory$PrototypeCloneFactory")) : class$org$apache$commons$collections$functors$PrototypeFactory$PrototypeCloneFactory);
            is.defaultReadObject();
        }

        PrototypeCloneFactory(Object x0, Method x1, 1 x2) {
            this(x0, x1);
        }
    }
}

