/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.ConstantTransformer;
import org.apache.commons.collections.functors.FunctorUtils;

public class SwitchTransformer
implements Serializable,
Transformer {
    private static final long serialVersionUID = -6404460890903469332L;
    private final Predicate[] iPredicates;
    private final Transformer[] iTransformers;
    private final Transformer iDefault;

    public static Transformer getInstance(Predicate[] predicates, Transformer[] transformers, Transformer defaultTransformer) {
        FunctorUtils.validate(predicates);
        FunctorUtils.validate(transformers);
        if (predicates.length != transformers.length) {
            throw new IllegalArgumentException("The predicate and transformer arrays must be the same size");
        }
        if (predicates.length == 0) {
            if (defaultTransformer == null) {
                return ConstantTransformer.NULL_INSTANCE;
            }
            return defaultTransformer;
        }
        predicates = FunctorUtils.copy(predicates);
        transformers = FunctorUtils.copy(transformers);
        return new SwitchTransformer(predicates, transformers, defaultTransformer);
    }

    public static Transformer getInstance(Map predicatesAndTransformers) {
        if (predicatesAndTransformers == null) {
            throw new IllegalArgumentException("The predicate and transformer map must not be null");
        }
        if (predicatesAndTransformers.size() == 0) {
            return ConstantTransformer.NULL_INSTANCE;
        }
        Transformer transformer = (Transformer)predicatesAndTransformers.remove(null);
        int n2 = predicatesAndTransformers.size();
        if (n2 == 0) {
            if (transformer == null) {
                return ConstantTransformer.NULL_INSTANCE;
            }
            return transformer;
        }
        Transformer[] transformers = new Transformer[n2];
        Predicate[] preds = new Predicate[n2];
        int n3 = 0;
        Iterator iterator = predicatesAndTransformers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            preds[n3] = (Predicate)entry.getKey();
            transformers[n3] = (Transformer)entry.getValue();
            ++n3;
        }
        return new SwitchTransformer(preds, transformers, transformer);
    }

    public SwitchTransformer(Predicate[] predicates, Transformer[] transformers, Transformer defaultTransformer) {
        this.iPredicates = predicates;
        this.iTransformers = transformers;
        this.iDefault = defaultTransformer == null ? ConstantTransformer.NULL_INSTANCE : defaultTransformer;
    }

    public Object transform(Object input) {
        for (int i2 = 0; i2 < this.iPredicates.length; ++i2) {
            if (!this.iPredicates[i2].evaluate(input)) continue;
            return this.iTransformers[i2].transform(input);
        }
        return this.iDefault.transform(input);
    }

    public Predicate[] getPredicates() {
        return this.iPredicates;
    }

    public Transformer[] getTransformers() {
        return this.iTransformers;
    }

    public Transformer getDefaultTransformer() {
        return this.iDefault;
    }
}

