/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.keyvalue;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.KeyValue;

public class TiedMapEntry
implements Serializable,
Map.Entry,
KeyValue {
    private static final long serialVersionUID = -8453869361373831205L;
    private final Map map;
    private final Object key;

    public TiedMapEntry(Map map, Object key) {
        this.map = map;
        this.key = key;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.map.get(this.key);
    }

    public Object setValue(Object value) {
        if (value == this) {
            throw new IllegalArgumentException("Cannot set value to this map entry");
        }
        return this.map.put(this.key, value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)obj;
        Object object = this.getValue();
        return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (object == null ? entry.getValue() == null : object.equals(entry.getValue()));
    }

    public int hashCode() {
        Object object = this.getValue();
        return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (object == null ? 0 : object.hashCode());
    }

    public String toString() {
        return this.getKey() + "=" + this.getValue();
    }
}

