/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.KeyValue;

public final class StaticBucketMap
implements Map {
    private static final int DEFAULT_BUCKETS = 255;
    private Node[] buckets;
    private Lock[] locks;

    public StaticBucketMap() {
        this(255);
    }

    public StaticBucketMap(int numBuckets) {
        int n2 = Math.max(17, numBuckets);
        if (n2 % 2 == 0) {
            --n2;
        }
        this.buckets = new Node[n2];
        this.locks = new Lock[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.locks[i2] = new Lock(null);
        }
    }

    private final int getHash(Object key) {
        if (key == null) {
            return 0;
        }
        int n2 = key.hashCode();
        n2 += ~(n2 << 15);
        n2 ^= n2 >>> 10;
        n2 += n2 << 3;
        n2 ^= n2 >>> 6;
        n2 += ~(n2 << 11);
        n2 ^= n2 >>> 16;
        if ((n2 %= this.buckets.length) < 0) {
            return -n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.buckets.length; ++i2) {
            Lock lock = this.locks[i2];
            synchronized (lock) {
                n2 += this.locks[i2].size;
                continue;
            }
        }
        return n2;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get(Object key) {
        int n2 = this.getHash(key);
        Lock lock = this.locks[n2];
        synchronized (lock) {
            Node node = this.buckets[n2];
            while (node != null) {
                if (node.key == key || node.key != null && node.key.equals(key)) {
                    return node.value;
                }
                node = node.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsKey(Object key) {
        int n2 = this.getHash(key);
        Lock lock = this.locks[n2];
        synchronized (lock) {
            Node node = this.buckets[n2];
            while (node != null) {
                if (node.key == key || node.key != null && node.key.equals(key)) {
                    return true;
                }
                node = node.next;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsValue(Object value) {
        for (int i2 = 0; i2 < this.buckets.length; ++i2) {
            Lock lock = this.locks[i2];
            synchronized (lock) {
                Node node = this.buckets[i2];
                while (node != null) {
                    if (node.value == value || node.value != null && node.value.equals(value)) {
                        return true;
                    }
                    node = node.next;
                }
                continue;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object put(Object key, Object value) {
        int n2 = this.getHash(key);
        Lock lock = this.locks[n2];
        synchronized (lock) {
            Node node = this.buckets[n2];
            if (node == null) {
                node = new Node(null);
                new Node(null).key = key;
                node.value = value;
                this.buckets[n2] = node;
                ++this.locks[n2].size;
                return null;
            }
            Node node2 = node;
            while (node2 != null) {
                node = node2;
                if (node.key == key || node.key != null && node.key.equals(key)) {
                    Object object = node.value;
                    node.value = value;
                    return object;
                }
                node2 = node2.next;
            }
            node2 = new Node(null);
            new Node(null).key = key;
            node2.value = value;
            node.next = node2;
            ++this.locks[n2].size;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object remove(Object key) {
        int n2 = this.getHash(key);
        Lock lock = this.locks[n2];
        synchronized (lock) {
            Node node = this.buckets[n2];
            Node node2 = null;
            while (node != null) {
                if (node.key == key || node.key != null && node.key.equals(key)) {
                    if (node2 == null) {
                        this.buckets[n2] = node.next;
                    } else {
                        node2.next = node.next;
                    }
                    --this.locks[n2].size;
                    return node.value;
                }
                node2 = node;
                node = node.next;
            }
        }
        return null;
    }

    public final Set keySet() {
        return new KeySet(this, null);
    }

    public final Collection values() {
        return new Values(this, null);
    }

    public final Set entrySet() {
        return new EntrySet(this, null);
    }

    public final void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            this.put(k2, map.get(k2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void clear() {
        int n2 = 0;
        while (n2 < this.buckets.length) {
            Lock lock;
            Lock lock2 = lock = this.locks[n2];
            // MONITORENTER : lock
            this.buckets[n2] = null;
            lock.size = 0;
            // MONITOREXIT : lock2
            ++n2;
        }
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map map = (Map)obj;
        return this.entrySet().equals(map.entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.buckets.length; ++i2) {
            Lock lock = this.locks[i2];
            synchronized (lock) {
                Node node = this.buckets[i2];
                while (node != null) {
                    n2 += node.hashCode();
                    node = node.next;
                }
                continue;
            }
        }
        return n2;
    }

    public final void atomic(Runnable r2) {
        if (r2 == null) {
            throw new NullPointerException();
        }
        this.atomic(r2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atomic(Runnable r2, int bucket) {
        if (bucket >= this.buckets.length) {
            r2.run();
            return;
        }
        Lock lock = this.locks[bucket];
        synchronized (lock) {
            this.atomic(r2, bucket + 1);
            return;
        }
    }

    static Node[] access$500(StaticBucketMap x0) {
        return x0.buckets;
    }

    static Lock[] access$600(StaticBucketMap x0) {
        return x0.locks;
    }

    static int access$800(StaticBucketMap x0, Object x1) {
        return x0.getHash(x1);
    }

    static class 1 {
    }

    private class Values
    extends AbstractCollection {
        private final StaticBucketMap this$0;

        private Values(StaticBucketMap staticBucketMap) {
            this.this$0 = staticBucketMap;
        }

        public int size() {
            return this.this$0.size();
        }

        public void clear() {
            this.this$0.clear();
        }

        public Iterator iterator() {
            return new ValueIterator(this.this$0, null);
        }

        Values(StaticBucketMap x0, 1 x1) {
            this(x0);
        }
    }

    private class KeySet
    extends AbstractSet {
        private final StaticBucketMap this$0;

        private KeySet(StaticBucketMap staticBucketMap) {
            this.this$0 = staticBucketMap;
        }

        public int size() {
            return this.this$0.size();
        }

        public void clear() {
            this.this$0.clear();
        }

        public Iterator iterator() {
            return new KeyIterator(this.this$0, null);
        }

        public boolean contains(Object obj) {
            return this.this$0.containsKey(obj);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object obj) {
            int n2 = StaticBucketMap.access$800(this.this$0, obj);
            Lock lock = StaticBucketMap.access$600(this.this$0)[n2];
            synchronized (lock) {
                Node node = StaticBucketMap.access$500(this.this$0)[n2];
                while (node != null) {
                    Object object = node.getKey();
                    if (object == obj || object != null && object.equals(obj)) {
                        this.this$0.remove(object);
                        return true;
                    }
                    node = node.next;
                }
            }
            return false;
        }

        KeySet(StaticBucketMap x0, 1 x1) {
            this(x0);
        }
    }

    private class EntrySet
    extends AbstractSet {
        private final StaticBucketMap this$0;

        private EntrySet(StaticBucketMap staticBucketMap) {
            this.this$0 = staticBucketMap;
        }

        public int size() {
            return this.this$0.size();
        }

        public void clear() {
            this.this$0.clear();
        }

        public Iterator iterator() {
            return new EntryIterator(this.this$0, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object obj) {
            Map.Entry entry = (Map.Entry)obj;
            int n2 = StaticBucketMap.access$800(this.this$0, entry.getKey());
            Lock lock = StaticBucketMap.access$600(this.this$0)[n2];
            synchronized (lock) {
                Node node = StaticBucketMap.access$500(this.this$0)[n2];
                while (node != null) {
                    if (node.equals(entry)) {
                        return true;
                    }
                    node = node.next;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            int n2 = StaticBucketMap.access$800(this.this$0, entry.getKey());
            Lock lock = StaticBucketMap.access$600(this.this$0)[n2];
            synchronized (lock) {
                Node node = StaticBucketMap.access$500(this.this$0)[n2];
                while (node != null) {
                    if (node.equals(entry)) {
                        this.this$0.remove(node.getKey());
                        return true;
                    }
                    node = node.next;
                }
            }
            return false;
        }

        EntrySet(StaticBucketMap x0, 1 x1) {
            this(x0);
        }
    }

    private class KeyIterator
    extends EntryIterator {
        private final StaticBucketMap this$0;

        private KeyIterator(StaticBucketMap staticBucketMap) {
            super(staticBucketMap, null);
            this.this$0 = staticBucketMap;
        }

        public Object next() {
            return this.nextEntry().getKey();
        }

        KeyIterator(StaticBucketMap x0, 1 x1) {
            this(x0);
        }
    }

    private class ValueIterator
    extends EntryIterator {
        private final StaticBucketMap this$0;

        private ValueIterator(StaticBucketMap staticBucketMap) {
            super(staticBucketMap, null);
            this.this$0 = staticBucketMap;
        }

        public Object next() {
            return this.nextEntry().getValue();
        }

        ValueIterator(StaticBucketMap x0, 1 x1) {
            this(x0);
        }
    }

    private class EntryIterator
    implements Iterator {
        private ArrayList current;
        private int bucket;
        private Map.Entry last;
        private final StaticBucketMap this$0;

        private EntryIterator(StaticBucketMap staticBucketMap) {
            this.this$0 = staticBucketMap;
            this.current = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            if (this.current.size() > 0) {
                return true;
            }
            while (this.bucket < StaticBucketMap.access$500(this.this$0).length) {
                Lock lock = StaticBucketMap.access$600(this.this$0)[this.bucket];
                synchronized (lock) {
                    Node node = StaticBucketMap.access$500(this.this$0)[this.bucket];
                    while (node != null) {
                        this.current.add(node);
                        node = node.next;
                    }
                    ++this.bucket;
                    if (this.current.size() > 0) {
                        return true;
                    }
                }
            }
            return false;
        }

        protected Map.Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = (Map.Entry)this.current.remove(this.current.size() - 1);
            return this.last;
        }

        public Object next() {
            return this.nextEntry();
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.this$0.remove(this.last.getKey());
            this.last = null;
        }

        EntryIterator(StaticBucketMap x0, 1 x1) {
            this(x0);
        }
    }

    private static final class Lock {
        public int size;

        private Lock() {
        }

        Lock(1 x0) {
            this();
        }
    }

    private static final class Node
    implements Map.Entry,
    KeyValue {
        protected Object key;
        protected Object value;
        protected Node next;

        private Node() {
        }

        public final Object getKey() {
            return this.key;
        }

        public final Object getValue() {
            return this.value;
        }

        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        public final Object setValue(Object obj) {
            Object object = this.value;
            this.value = obj;
            return object;
        }

        Node(1 x0) {
            this();
        }
    }
}

